package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) S3 location where you want Amazon SageMaker to save the results from the transform job.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-14T21:02:43.644Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.TransformOutput")
@software.amazon.jsii.Jsii.Proxy(TransformOutput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransformOutput extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) S3 path where you want Amazon SageMaker to store the results of the transform job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getS3OutputPath();

    /**
     * (experimental) MIME type used to specify the output data.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccept() {
        return null;
    }

    /**
     * (experimental) Defines how to assemble the results of the transform job as a single S3 object.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith getAssembleWith() {
        return null;
    }

    /**
     * (experimental) AWS KMS key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     * <p>
     * Default: - default KMS key for Amazon S3 for your role's account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TransformOutput> {
        private java.lang.String s3OutputPath;
        private java.lang.String accept;
        private software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Sets the value of {@link TransformOutput#getS3OutputPath}
         * @param s3OutputPath S3 path where you want Amazon SageMaker to store the results of the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3OutputPath(java.lang.String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        /**
         * Sets the value of {@link TransformOutput#getAccept}
         * @param accept MIME type used to specify the output data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accept(java.lang.String accept) {
            this.accept = accept;
            return this;
        }

        /**
         * Sets the value of {@link TransformOutput#getAssembleWith}
         * @param assembleWith Defines how to assemble the results of the transform job as a single S3 object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assembleWith(software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        /**
         * Sets the value of {@link TransformOutput#getEncryptionKey}
         * @param encryptionKey AWS KMS key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformOutput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TransformOutput build() {
            return new Jsii$Proxy(s3OutputPath, accept, assembleWith, encryptionKey);
        }
    }

    /**
     * An implementation for {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformOutput {
        private final java.lang.String s3OutputPath;
        private final java.lang.String accept;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accept = software.amazon.jsii.Kernel.get(this, "accept", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assembleWith = software.amazon.jsii.Kernel.get(this, "assembleWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String s3OutputPath, final java.lang.String accept, final software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith, final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3OutputPath = java.util.Objects.requireNonNull(s3OutputPath, "s3OutputPath is required");
            this.accept = accept;
            this.assembleWith = assembleWith;
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final java.lang.String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final java.lang.String getAccept() {
            return this.accept;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith getAssembleWith() {
            return this.assembleWith;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
            if (this.getAccept() != null) {
                data.set("accept", om.valueToTree(this.getAccept()));
            }
            if (this.getAssembleWith() != null) {
                data.set("assembleWith", om.valueToTree(this.getAssembleWith()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.TransformOutput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformOutput.Jsii$Proxy that = (TransformOutput.Jsii$Proxy) o;

            if (!s3OutputPath.equals(that.s3OutputPath)) return false;
            if (this.accept != null ? !this.accept.equals(that.accept) : that.accept != null) return false;
            if (this.assembleWith != null ? !this.assembleWith.equals(that.assembleWith) : that.assembleWith != null) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3OutputPath.hashCode();
            result = 31 * result + (this.accept != null ? this.accept.hashCode() : 0);
            result = 31 * result + (this.assembleWith != null ? this.assembleWith.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
