package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of states to chain onto
 * 
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.238Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Chain")
public class Chain extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IChainable {
    protected Chain(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Make a Chain with specific start and end states, and a last-added Chainable
     */
    public static software.amazon.awscdk.services.stepfunctions.Chain custom(final software.amazon.awscdk.services.stepfunctions.State startState, final java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> endStates, final software.amazon.awscdk.services.stepfunctions.IChainable lastAdded) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "custom", software.amazon.awscdk.services.stepfunctions.Chain.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(startState, "startState is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(endStates, "endStates is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(lastAdded, "lastAdded is required"))).toArray());
    }

    /**
     * Make a Chain with the start from one chain and the ends from another
     */
    public static software.amazon.awscdk.services.stepfunctions.Chain sequence(final software.amazon.awscdk.services.stepfunctions.IChainable start, final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "sequence", software.amazon.awscdk.services.stepfunctions.Chain.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(start, "start is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(next, "next is required"))).toArray());
    }

    /**
     * Begin a new Chain from one chainable
     */
    public static software.amazon.awscdk.services.stepfunctions.Chain start(final software.amazon.awscdk.services.stepfunctions.IChainable state) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "start", software.amazon.awscdk.services.stepfunctions.Chain.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(state, "state is required")).toArray());
    }

    /**
     * Continue normal execution with the given state
     */
    public software.amazon.awscdk.services.stepfunctions.Chain next(final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(next, "next is required")).toArray());
    }

    /**
     * Return a single state that encompasses all states in the chain
     * 
     * This can be used to add error handling to a sequence of states.
     * 
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    public software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.ParallelProps props) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Return a single state that encompasses all states in the chain
     * 
     * This can be used to add error handling to a sequence of states.
     * 
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    public software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final java.lang.String id) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required")).toArray());
    }

    /**
     * The chainable end state(s) of this chain
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }

    /**
     * Identify this Chain
     */
    @Override
    public java.lang.String getId() {
        return this.jsiiGet("id", java.lang.String.class);
    }

    public software.amazon.awscdk.services.stepfunctions.IChainable getLastAdded() {
        return this.jsiiGet("lastAdded", software.amazon.awscdk.services.stepfunctions.IChainable.class);
    }

    /**
     * The start state of this chain
     */
    @Override
    public software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }
}
