package software.amazon.awscdk.services.stepfunctions;

/**
 * Options for creating a single state
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.245Z")
public interface SingleStateOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.ParallelProps {
    /**
     * String to prefix all stateIds in the state machine with
     * @default stateId
     */
    java.lang.String getPrefixStates();
    /**
     * String to prefix all stateIds in the state machine with
     * @default stateId
     */
    void setPrefixStates(final java.lang.String value);
    /**
     * ID of newly created containing state
     * @default Construct ID of the StateMachineFragment
     */
    java.lang.String getStateId();
    /**
     * ID of newly created containing state
     * @default Construct ID of the StateMachineFragment
     */
    void setStateId(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link SingleStateOptions}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SingleStateOptions}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _prefixStates;
        @javax.annotation.Nullable
        private java.lang.String _stateId;
        @javax.annotation.Nullable
        private java.lang.String _comment;
        @javax.annotation.Nullable
        private java.lang.String _inputPath;
        @javax.annotation.Nullable
        private java.lang.String _outputPath;
        @javax.annotation.Nullable
        private java.lang.String _resultPath;

        /**
         * Sets the value of PrefixStates
         * @param value String to prefix all stateIds in the state machine with
         * @return {@code this}
         */
        public Builder withPrefixStates(@javax.annotation.Nullable final java.lang.String value) {
            this._prefixStates = value;
            return this;
        }
        /**
         * Sets the value of StateId
         * @param value ID of newly created containing state
         * @return {@code this}
         */
        public Builder withStateId(@javax.annotation.Nullable final java.lang.String value) {
            this._stateId = value;
            return this;
        }
        /**
         * Sets the value of Comment
         * @param value An optional description for this state
         * @return {@code this}
         */
        public Builder withComment(@javax.annotation.Nullable final java.lang.String value) {
            this._comment = value;
            return this;
        }
        /**
         * Sets the value of InputPath
         * @param value JSONPath expression to select part of the state to be the input to this state.

May also be the special value DISCARD, which will cause the effective
input to be the empty object {}.
         * @return {@code this}
         */
        public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
            this._inputPath = value;
            return this;
        }
        /**
         * Sets the value of OutputPath
         * @param value JSONPath expression to select part of the state to be the output to this state.

May also be the special value DISCARD, which will cause the effective
output to be the empty object {}.
         * @return {@code this}
         */
        public Builder withOutputPath(@javax.annotation.Nullable final java.lang.String value) {
            this._outputPath = value;
            return this;
        }
        /**
         * Sets the value of ResultPath
         * @param value JSONPath expression to indicate where to inject the state's output

May also be the special value DISCARD, which will cause the state's
input to become its output.
         * @return {@code this}
         */
        public Builder withResultPath(@javax.annotation.Nullable final java.lang.String value) {
            this._resultPath = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingleStateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SingleStateOptions build() {
            return new SingleStateOptions() {
                @javax.annotation.Nullable
                private java.lang.String $prefixStates = _prefixStates;
                @javax.annotation.Nullable
                private java.lang.String $stateId = _stateId;
                @javax.annotation.Nullable
                private java.lang.String $comment = _comment;
                @javax.annotation.Nullable
                private java.lang.String $inputPath = _inputPath;
                @javax.annotation.Nullable
                private java.lang.String $outputPath = _outputPath;
                @javax.annotation.Nullable
                private java.lang.String $resultPath = _resultPath;

                @Override
                public java.lang.String getPrefixStates() {
                    return this.$prefixStates;
                }

                @Override
                public void setPrefixStates(@javax.annotation.Nullable final java.lang.String value) {
                    this.$prefixStates = value;
                }

                @Override
                public java.lang.String getStateId() {
                    return this.$stateId;
                }

                @Override
                public void setStateId(@javax.annotation.Nullable final java.lang.String value) {
                    this.$stateId = value;
                }

                @Override
                public java.lang.String getComment() {
                    return this.$comment;
                }

                @Override
                public void setComment(@javax.annotation.Nullable final java.lang.String value) {
                    this.$comment = value;
                }

                @Override
                public java.lang.String getInputPath() {
                    return this.$inputPath;
                }

                @Override
                public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$inputPath = value;
                }

                @Override
                public java.lang.String getOutputPath() {
                    return this.$outputPath;
                }

                @Override
                public void setOutputPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$outputPath = value;
                }

                @Override
                public java.lang.String getResultPath() {
                    return this.$resultPath;
                }

                @Override
                public void setResultPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$resultPath = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.SingleStateOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * String to prefix all stateIds in the state machine with
         * @default stateId
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPrefixStates() {
            return this.jsiiGet("prefixStates", java.lang.String.class);
        }

        /**
         * String to prefix all stateIds in the state machine with
         * @default stateId
         */
        @Override
        public void setPrefixStates(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("prefixStates", value);
        }

        /**
         * ID of newly created containing state
         * @default Construct ID of the StateMachineFragment
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getStateId() {
            return this.jsiiGet("stateId", java.lang.String.class);
        }

        /**
         * ID of newly created containing state
         * @default Construct ID of the StateMachineFragment
         */
        @Override
        public void setStateId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("stateId", value);
        }

        /**
         * An optional description for this state
         * @default No comment
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getComment() {
            return this.jsiiGet("comment", java.lang.String.class);
        }

        /**
         * An optional description for this state
         * @default No comment
         */
        @Override
        public void setComment(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("comment", value);
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * input to be the empty object {}.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getInputPath() {
            return this.jsiiGet("inputPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * input to be the empty object {}.
         * @default $
         */
        @Override
        public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("inputPath", value);
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * output to be the empty object {}.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOutputPath() {
            return this.jsiiGet("outputPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * output to be the empty object {}.
         * @default $
         */
        @Override
        public void setOutputPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("outputPath", value);
        }

        /**
         * JSONPath expression to indicate where to inject the state's output
         * 
         * May also be the special value DISCARD, which will cause the state's
         * input to become its output.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getResultPath() {
            return this.jsiiGet("resultPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to indicate where to inject the state's output
         * 
         * May also be the special value DISCARD, which will cause the state's
         * input to become its output.
         * @default $
         */
        @Override
        public void setResultPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("resultPath", value);
        }
    }
}
