package software.amazon.awscdk.services.stepfunctions;

/**
 * Base class for all other state classes
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.State")
public abstract class State extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.stepfunctions.IChainable {
    protected State(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Return only the states that allow chaining from an array of states
     */
    public static java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> filterNextables(final java.util.List<software.amazon.awscdk.services.stepfunctions.State> states) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "filterNextables", java.util.List.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(states, "states is required")).toArray());
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state
     */
    public static java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final software.amazon.awscdk.services.stepfunctions.State start, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.FindStateOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", java.util.List.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(start, "start is required")), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state
     */
    public static java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final software.amazon.awscdk.services.stepfunctions.State start) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", java.util.List.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(start, "start is required")).toArray());
    }

    /**
     * Add a prefix to the stateId of all States found in a construct tree
     */
    public static void prefixStates(final software.amazon.awscdk.Construct root, final java.lang.String prefix) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "prefixStates", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(root, "root is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(prefix, "prefix is required"))).toArray());
    }

    /**
     * Add a paralle branch to this state
     */
    protected void addBranch(final software.amazon.awscdk.services.stepfunctions.StateGraph branch) {
        this.jsiiCall("addBranch", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(branch, "branch is required")).toArray());
    }

    /**
     * Add a choice branch to this state
     */
    protected void addChoice(final software.amazon.awscdk.services.stepfunctions.Condition condition, final software.amazon.awscdk.services.stepfunctions.State next) {
        this.jsiiCall("addChoice", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(condition, "condition is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(next, "next is required"))).toArray());
    }

    /**
     * Add a prefix to the stateId of this state
     */
    public void addPrefix(final java.lang.String x) {
        this.jsiiCall("addPrefix", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(x, "x is required")).toArray());
    }

    /**
     * Register this state as part of the given graph
     * 
     * Don't call this. It will be called automatically when you work
     * states normally.
     */
    public void bindToGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("bindToGraph", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    /**
     * Make the indicated state the default choice transition of this state
     */
    protected void makeDefault(final software.amazon.awscdk.services.stepfunctions.State def) {
        this.jsiiCall("makeDefault", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(def, "def is required")).toArray());
    }

    /**
     * Make the indicated state the default transition of this state
     */
    protected void makeNext(final software.amazon.awscdk.services.stepfunctions.State next) {
        this.jsiiCall("makeNext", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(next, "next is required")).toArray());
    }

    /**
     * Called whenever this state is bound to a graph
     * 
     * Can be overridden by subclasses.
     */
    protected void onBindToGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("onBindToGraph", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    /**
     * Render parallel branches in ASL JSON format
     */
    protected java.lang.Object renderBranches() {
        return this.jsiiCall("renderBranches", java.lang.Object.class);
    }

    /**
     * Render the choices in ASL JSON format
     */
    protected java.lang.Object renderChoices() {
        return this.jsiiCall("renderChoices", java.lang.Object.class);
    }

    /**
     * Render InputPath/OutputPath in ASL JSON format
     */
    protected java.lang.Object renderInputOutput() {
        return this.jsiiCall("renderInputOutput", java.lang.Object.class);
    }

    /**
     * Render the default next state in ASL JSON format
     */
    protected java.lang.Object renderNextEnd() {
        return this.jsiiCall("renderNextEnd", java.lang.Object.class);
    }

    /**
     * Render error recovery options in ASL JSON format
     */
    protected java.lang.Object renderRetryCatch() {
        return this.jsiiCall("renderRetryCatch", java.lang.Object.class);
    }

    /**
     * Render the state as JSON
     */
    public abstract com.fasterxml.jackson.databind.node.ObjectNode toStateJson();

    protected java.util.List<software.amazon.awscdk.services.stepfunctions.StateGraph> getBranches() {
        return this.jsiiGet("branches", java.util.List.class);
    }

    /**
     * Continuable states of this Chainable
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }

    /**
     * First state of this Chainable
     */
    @Override
    public software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    /**
     * Tokenized string that evaluates to the state's ID
     */
    public java.lang.String getStateId() {
        return this.jsiiGet("stateId", java.lang.String.class);
    }

    @javax.annotation.Nullable
    protected java.lang.String getComment() {
        return this.jsiiGet("comment", java.lang.String.class);
    }

    @javax.annotation.Nullable
    protected java.lang.String getInputPath() {
        return this.jsiiGet("inputPath", java.lang.String.class);
    }

    @javax.annotation.Nullable
    protected java.lang.String getOutputPath() {
        return this.jsiiGet("outputPath", java.lang.String.class);
    }

    @javax.annotation.Nullable
    protected java.lang.String getResultPath() {
        return this.jsiiGet("resultPath", java.lang.String.class);
    }

    @javax.annotation.Nullable
    protected software.amazon.awscdk.services.stepfunctions.State getDefaultChoice() {
        return this.jsiiGet("defaultChoice", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    protected void setDefaultChoice(@javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.State value) {
        this.jsiiSet("defaultChoice", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.State {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The chainable end state(s) of this chainable
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return this.jsiiGet("endStates", java.util.List.class);
        }

        /**
         * Descriptive identifier for this chainable
         */
        @Override
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The start state of this chainable
         */
        @Override
        public software.amazon.awscdk.services.stepfunctions.State getStartState() {
            return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
        }

        /**
         * Render the state as JSON
         */
        @Override
        public com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
            return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
        }
    }
}
