package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of connected states
 * 
 * A StateGraph is used to keep track of all states that are connected (have
 * transitions between them). It does not include the substatemachines in
 * a Parallel's branches: those are their own StateGraphs, but the graphs
 * themselves have a hierarchical relationship as well.
 * 
 * By assigning states to a definintive StateGraph, we verify that no state
 * machines are constructed. In particular:
 * 
 * - Every state object can only ever be in 1 StateGraph, and not inadvertently
 *    be used in two graphs.
 * - Every stateId must be unique across all states in the entire state
 *    machine.
 * 
 * All policy statements in all states in all substatemachines are bubbled so
 * that the top-level StateMachine instantiation can read them all and add
 * them to the IAM Role.
 * 
 * You do not need to instantiate this class; it is used internally.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.247Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.StateGraph")
public class StateGraph extends software.amazon.jsii.JsiiObject {
    protected StateGraph(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public StateGraph(final software.amazon.awscdk.services.stepfunctions.State startState, final java.lang.String graphDescription) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(startState, "startState is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(graphDescription, "graphDescription is required"))).toArray());
    }

    /**
     * Register a Policy Statement used by states in this graph
     */
    public void registerPolicyStatement(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("registerPolicyStatement", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Register a state as part of this graph
     * 
     * Called by State.bindToGraph().
     */
    public void registerState(final software.amazon.awscdk.services.stepfunctions.State state) {
        this.jsiiCall("registerState", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(state, "state is required")).toArray());
    }

    /**
     * Register this graph as a child of the given graph
     * 
     * Resource changes will be bubbled up to the given graph.
     */
    public void registerSuperGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("registerSuperGraph", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    /**
     * Return the Amazon States Language JSON for this graph
     */
    public com.fasterxml.jackson.databind.node.ObjectNode toGraphJson() {
        return this.jsiiCall("toGraphJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Return a string description of this graph
     */
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    public java.lang.String getGraphDescription() {
        return this.jsiiGet("graphDescription", java.lang.String.class);
    }

    /**
     * The accumulated policy statements
     */
    public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
        return this.jsiiGet("policyStatements", java.util.List.class);
    }

    public software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    /**
     * Set a timeout to render into the graph JSON.
     * 
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * @default No timeout
     */
    @javax.annotation.Nullable
    public java.lang.Number getTimeoutSeconds() {
        return this.jsiiGet("timeoutSeconds", java.lang.Number.class);
    }

    /**
     * Set a timeout to render into the graph JSON.
     * 
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * @default No timeout
     */
    public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("timeoutSeconds", value);
    }
}
