package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties that define how to refer to a TaskResource
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.250Z")
public interface StepFunctionsTaskResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the resource
     */
    java.lang.String getResourceArn();
    /**
     * The ARN of the resource
     */
    void setResourceArn(final java.lang.String value);
    /**
     * The dimensions to attach to metrics
     * @default No metrics
     */
    java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions();
    /**
     * The dimensions to attach to metrics
     * @default No metrics
     */
    void setMetricDimensions(final java.util.Map<java.lang.String, java.lang.Object> value);
    /**
     * Prefix for plural metric names of activity actions
     * @default No such metrics
     */
    java.lang.String getMetricPrefixPlural();
    /**
     * Prefix for plural metric names of activity actions
     * @default No such metrics
     */
    void setMetricPrefixPlural(final java.lang.String value);
    /**
     * Prefix for singular metric names of activity actions
     * @default No such metrics
     */
    java.lang.String getMetricPrefixSingular();
    /**
     * Prefix for singular metric names of activity actions
     * @default No such metrics
     */
    void setMetricPrefixSingular(final java.lang.String value);
    /**
     * Additional policy statements to add to the execution role
     * @default No policy roles
     */
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements();
    /**
     * Additional policy statements to add to the execution role
     * @default No policy roles
     */
    void setPolicyStatements(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value);

    /**
     * @return a {@link Builder} of {@link StepFunctionsTaskResourceProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StepFunctionsTaskResourceProps}
     */
    final class Builder {
        private java.lang.String _resourceArn;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _metricDimensions;
        @javax.annotation.Nullable
        private java.lang.String _metricPrefixPlural;
        @javax.annotation.Nullable
        private java.lang.String _metricPrefixSingular;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _policyStatements;

        /**
         * Sets the value of ResourceArn
         * @param value The ARN of the resource
         * @return {@code this}
         */
        public Builder withResourceArn(final java.lang.String value) {
            this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
            return this;
        }
        /**
         * Sets the value of MetricDimensions
         * @param value The dimensions to attach to metrics
         * @return {@code this}
         */
        public Builder withMetricDimensions(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._metricDimensions = value;
            return this;
        }
        /**
         * Sets the value of MetricPrefixPlural
         * @param value Prefix for plural metric names of activity actions
         * @return {@code this}
         */
        public Builder withMetricPrefixPlural(@javax.annotation.Nullable final java.lang.String value) {
            this._metricPrefixPlural = value;
            return this;
        }
        /**
         * Sets the value of MetricPrefixSingular
         * @param value Prefix for singular metric names of activity actions
         * @return {@code this}
         */
        public Builder withMetricPrefixSingular(@javax.annotation.Nullable final java.lang.String value) {
            this._metricPrefixSingular = value;
            return this;
        }
        /**
         * Sets the value of PolicyStatements
         * @param value Additional policy statements to add to the execution role
         * @return {@code this}
         */
        public Builder withPolicyStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._policyStatements = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepFunctionsTaskResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StepFunctionsTaskResourceProps build() {
            return new StepFunctionsTaskResourceProps() {
                private java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.Object> $metricDimensions = _metricDimensions;
                @javax.annotation.Nullable
                private java.lang.String $metricPrefixPlural = _metricPrefixPlural;
                @javax.annotation.Nullable
                private java.lang.String $metricPrefixSingular = _metricPrefixSingular;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $policyStatements = _policyStatements;

                @Override
                public java.lang.String getResourceArn() {
                    return this.$resourceArn;
                }

                @Override
                public void setResourceArn(final java.lang.String value) {
                    this.$resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions() {
                    return this.$metricDimensions;
                }

                @Override
                public void setMetricDimensions(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.$metricDimensions = value;
                }

                @Override
                public java.lang.String getMetricPrefixPlural() {
                    return this.$metricPrefixPlural;
                }

                @Override
                public void setMetricPrefixPlural(@javax.annotation.Nullable final java.lang.String value) {
                    this.$metricPrefixPlural = value;
                }

                @Override
                public java.lang.String getMetricPrefixSingular() {
                    return this.$metricPrefixSingular;
                }

                @Override
                public void setMetricPrefixSingular(@javax.annotation.Nullable final java.lang.String value) {
                    this.$metricPrefixSingular = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
                    return this.$policyStatements;
                }

                @Override
                public void setPolicyStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
                    this.$policyStatements = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the resource
         */
        @Override
        public java.lang.String getResourceArn() {
            return this.jsiiGet("resourceArn", java.lang.String.class);
        }

        /**
         * The ARN of the resource
         */
        @Override
        public void setResourceArn(final java.lang.String value) {
            this.jsiiSet("resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
        }

        /**
         * The dimensions to attach to metrics
         * @default No metrics
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions() {
            return this.jsiiGet("metricDimensions", java.util.Map.class);
        }

        /**
         * The dimensions to attach to metrics
         * @default No metrics
         */
        @Override
        public void setMetricDimensions(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("metricDimensions", value);
        }

        /**
         * Prefix for plural metric names of activity actions
         * @default No such metrics
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getMetricPrefixPlural() {
            return this.jsiiGet("metricPrefixPlural", java.lang.String.class);
        }

        /**
         * Prefix for plural metric names of activity actions
         * @default No such metrics
         */
        @Override
        public void setMetricPrefixPlural(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("metricPrefixPlural", value);
        }

        /**
         * Prefix for singular metric names of activity actions
         * @default No such metrics
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getMetricPrefixSingular() {
            return this.jsiiGet("metricPrefixSingular", java.lang.String.class);
        }

        /**
         * Prefix for singular metric names of activity actions
         * @default No such metrics
         */
        @Override
        public void setMetricPrefixSingular(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("metricPrefixSingular", value);
        }

        /**
         * Additional policy statements to add to the execution role
         * @default No policy roles
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
            return this.jsiiGet("policyStatements", java.util.List.class);
        }

        /**
         * Additional policy statements to add to the execution role
         * @default No policy roles
         */
        @Override
        public void setPolicyStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this.jsiiSet("policyStatements", value);
        }
    }
}
