package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Task state in the state machine
 * 
 * Reaching a Task state causes some work to be executed, represented
 * by the Task's resource property.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.252Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Task")
public class Task extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {
    protected Task(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Task(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.stepfunctions.TaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Add a recovery handler for this state
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     */
    public software.amazon.awscdk.services.stepfunctions.Task addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Task.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(handler, "handler is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Add a recovery handler for this state
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     */
    public software.amazon.awscdk.services.stepfunctions.Task addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Task.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(handler, "handler is required")).toArray());
    }

    /**
     * Add retry configuration for this state
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    public software.amazon.awscdk.services.stepfunctions.Task addRetry(@javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Task.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Add retry configuration for this state
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    public software.amazon.awscdk.services.stepfunctions.Task addRetry() {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Task.class);
    }

    /**
     * Return the given named metric for this Task
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Return the given named metric for this Task
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    /**
     * Metric for the number of times this activity fails
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailed(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times this activity fails
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailed() {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut() {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRunTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRunTime() {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is scheduled
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduled(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times this activity is scheduled
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduled() {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime() {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is started
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricStarted(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times this activity is started
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricStarted() {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity succeeds
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times this activity succeeds
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded() {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTime() {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity times out
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of times this activity times out
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut() {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Continue normal execution with the given state
     */
    @Override
    public software.amazon.awscdk.services.stepfunctions.Chain next(final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(next, "next is required")).toArray());
    }

    /**
     * Called whenever this state is bound to a graph
     * 
     * Can be overridden by subclasses.
     */
    @Override
    protected void onBindToGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("onBindToGraph", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    /**
     * Return the Amazon States Language object for this state
     */
    @Override
    public com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Continuable states of this Chainable
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }
}
