package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a Task state
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:20:29.253Z")
public interface TaskProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The resource that represents the work to be executed
     * 
     * Can be either a Lambda Function or an Activity.
     */
    software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource getResource();
    /**
     * The resource that represents the work to be executed
     * 
     * Can be either a Lambda Function or an Activity.
     */
    void setResource(final software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource value);
    /**
     * An optional description for this state
     * @default No comment
     */
    java.lang.String getComment();
    /**
     * An optional description for this state
     * @default No comment
     */
    void setComment(final java.lang.String value);
    /**
     * Maximum time between heart beats
     * 
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     * 
     * This is only relevant when using an Activity type as resource.
     * @default No heart beat timeout
     */
    java.lang.Number getHeartbeatSeconds();
    /**
     * Maximum time between heart beats
     * 
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     * 
     * This is only relevant when using an Activity type as resource.
     * @default No heart beat timeout
     */
    void setHeartbeatSeconds(final java.lang.Number value);
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     * 
     * May also be the special value DISCARD, which will cause the effective
     * input to be the empty object {}.
     * @default $
     */
    java.lang.String getInputPath();
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     * 
     * May also be the special value DISCARD, which will cause the effective
     * input to be the empty object {}.
     * @default $
     */
    void setInputPath(final java.lang.String value);
    /**
     * JSONPath expression to select part of the state to be the output to this state.
     * 
     * May also be the special value DISCARD, which will cause the effective
     * output to be the empty object {}.
     * @default $
     */
    java.lang.String getOutputPath();
    /**
     * JSONPath expression to select part of the state to be the output to this state.
     * 
     * May also be the special value DISCARD, which will cause the effective
     * output to be the empty object {}.
     * @default $
     */
    void setOutputPath(final java.lang.String value);
    /**
     * JSONPath expression to indicate where to inject the state's output
     * 
     * May also be the special value DISCARD, which will cause the state's
     * input to become its output.
     * @default $
     */
    java.lang.String getResultPath();
    /**
     * JSONPath expression to indicate where to inject the state's output
     * 
     * May also be the special value DISCARD, which will cause the state's
     * input to become its output.
     * @default $
     */
    void setResultPath(final java.lang.String value);
    /**
     * Maximum run time of this state
     * 
     * If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
     * @default 60
     */
    java.lang.Number getTimeoutSeconds();
    /**
     * Maximum run time of this state
     * 
     * If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
     * @default 60
     */
    void setTimeoutSeconds(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link TaskProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TaskProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource _resource;
        @javax.annotation.Nullable
        private java.lang.String _comment;
        @javax.annotation.Nullable
        private java.lang.Number _heartbeatSeconds;
        @javax.annotation.Nullable
        private java.lang.String _inputPath;
        @javax.annotation.Nullable
        private java.lang.String _outputPath;
        @javax.annotation.Nullable
        private java.lang.String _resultPath;
        @javax.annotation.Nullable
        private java.lang.Number _timeoutSeconds;

        /**
         * Sets the value of Resource
         * @param value The resource that represents the work to be executed

Can be either a Lambda Function or an Activity.
         * @return {@code this}
         */
        public Builder withResource(final software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource value) {
            this._resource = java.util.Objects.requireNonNull(value, "resource is required");
            return this;
        }
        /**
         * Sets the value of Comment
         * @param value An optional description for this state
         * @return {@code this}
         */
        public Builder withComment(@javax.annotation.Nullable final java.lang.String value) {
            this._comment = value;
            return this;
        }
        /**
         * Sets the value of HeartbeatSeconds
         * @param value Maximum time between heart beats

If the time between heart beats takes longer than this, a 'Timeout' error is raised.

This is only relevant when using an Activity type as resource.
         * @return {@code this}
         */
        public Builder withHeartbeatSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this._heartbeatSeconds = value;
            return this;
        }
        /**
         * Sets the value of InputPath
         * @param value JSONPath expression to select part of the state to be the input to this state.

May also be the special value DISCARD, which will cause the effective
input to be the empty object {}.
         * @return {@code this}
         */
        public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
            this._inputPath = value;
            return this;
        }
        /**
         * Sets the value of OutputPath
         * @param value JSONPath expression to select part of the state to be the output to this state.

May also be the special value DISCARD, which will cause the effective
output to be the empty object {}.
         * @return {@code this}
         */
        public Builder withOutputPath(@javax.annotation.Nullable final java.lang.String value) {
            this._outputPath = value;
            return this;
        }
        /**
         * Sets the value of ResultPath
         * @param value JSONPath expression to indicate where to inject the state's output

May also be the special value DISCARD, which will cause the state's
input to become its output.
         * @return {@code this}
         */
        public Builder withResultPath(@javax.annotation.Nullable final java.lang.String value) {
            this._resultPath = value;
            return this;
        }
        /**
         * Sets the value of TimeoutSeconds
         * @param value Maximum run time of this state

If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
         * @return {@code this}
         */
        public Builder withTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this._timeoutSeconds = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public TaskProps build() {
            return new TaskProps() {
                private software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource $resource = java.util.Objects.requireNonNull(_resource, "resource is required");
                @javax.annotation.Nullable
                private java.lang.String $comment = _comment;
                @javax.annotation.Nullable
                private java.lang.Number $heartbeatSeconds = _heartbeatSeconds;
                @javax.annotation.Nullable
                private java.lang.String $inputPath = _inputPath;
                @javax.annotation.Nullable
                private java.lang.String $outputPath = _outputPath;
                @javax.annotation.Nullable
                private java.lang.String $resultPath = _resultPath;
                @javax.annotation.Nullable
                private java.lang.Number $timeoutSeconds = _timeoutSeconds;

                @Override
                public software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource getResource() {
                    return this.$resource;
                }

                @Override
                public void setResource(final software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource value) {
                    this.$resource = java.util.Objects.requireNonNull(value, "resource is required");
                }

                @Override
                public java.lang.String getComment() {
                    return this.$comment;
                }

                @Override
                public void setComment(@javax.annotation.Nullable final java.lang.String value) {
                    this.$comment = value;
                }

                @Override
                public java.lang.Number getHeartbeatSeconds() {
                    return this.$heartbeatSeconds;
                }

                @Override
                public void setHeartbeatSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$heartbeatSeconds = value;
                }

                @Override
                public java.lang.String getInputPath() {
                    return this.$inputPath;
                }

                @Override
                public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$inputPath = value;
                }

                @Override
                public java.lang.String getOutputPath() {
                    return this.$outputPath;
                }

                @Override
                public void setOutputPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$outputPath = value;
                }

                @Override
                public java.lang.String getResultPath() {
                    return this.$resultPath;
                }

                @Override
                public void setResultPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$resultPath = value;
                }

                @Override
                public java.lang.Number getTimeoutSeconds() {
                    return this.$timeoutSeconds;
                }

                @Override
                public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$timeoutSeconds = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.TaskProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The resource that represents the work to be executed
         * 
         * Can be either a Lambda Function or an Activity.
         */
        @Override
        public software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource getResource() {
            return this.jsiiGet("resource", software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource.class);
        }

        /**
         * The resource that represents the work to be executed
         * 
         * Can be either a Lambda Function or an Activity.
         */
        @Override
        public void setResource(final software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource value) {
            this.jsiiSet("resource", java.util.Objects.requireNonNull(value, "resource is required"));
        }

        /**
         * An optional description for this state
         * @default No comment
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getComment() {
            return this.jsiiGet("comment", java.lang.String.class);
        }

        /**
         * An optional description for this state
         * @default No comment
         */
        @Override
        public void setComment(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("comment", value);
        }

        /**
         * Maximum time between heart beats
         * 
         * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
         * 
         * This is only relevant when using an Activity type as resource.
         * @default No heart beat timeout
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getHeartbeatSeconds() {
            return this.jsiiGet("heartbeatSeconds", java.lang.Number.class);
        }

        /**
         * Maximum time between heart beats
         * 
         * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
         * 
         * This is only relevant when using an Activity type as resource.
         * @default No heart beat timeout
         */
        @Override
        public void setHeartbeatSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("heartbeatSeconds", value);
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * input to be the empty object {}.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getInputPath() {
            return this.jsiiGet("inputPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * input to be the empty object {}.
         * @default $
         */
        @Override
        public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("inputPath", value);
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * output to be the empty object {}.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOutputPath() {
            return this.jsiiGet("outputPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * 
         * May also be the special value DISCARD, which will cause the effective
         * output to be the empty object {}.
         * @default $
         */
        @Override
        public void setOutputPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("outputPath", value);
        }

        /**
         * JSONPath expression to indicate where to inject the state's output
         * 
         * May also be the special value DISCARD, which will cause the state's
         * input to become its output.
         * @default $
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getResultPath() {
            return this.jsiiGet("resultPath", java.lang.String.class);
        }

        /**
         * JSONPath expression to indicate where to inject the state's output
         * 
         * May also be the special value DISCARD, which will cause the state's
         * input to become its output.
         * @default $
         */
        @Override
        public void setResultPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("resultPath", value);
        }

        /**
         * Maximum run time of this state
         * 
         * If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
         * @default 60
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTimeoutSeconds() {
            return this.jsiiGet("timeoutSeconds", java.lang.Number.class);
        }

        /**
         * Maximum run time of this state
         * 
         * If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
         * @default 60
         */
        @Override
        public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("timeoutSeconds", value);
        }
    }
}
