package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of states to chain onto.
 * 
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:09:30.917Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Chain")
public class Chain extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IChainable {
    protected Chain(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Make a Chain with specific start and end states, and a last-added Chainable.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.stepfunctions.Chain custom(final software.amazon.awscdk.services.stepfunctions.State startState, final java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> endStates, final software.amazon.awscdk.services.stepfunctions.IChainable lastAdded) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "custom", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(startState, "startState is required"), java.util.Objects.requireNonNull(endStates, "endStates is required"), java.util.Objects.requireNonNull(lastAdded, "lastAdded is required") });
    }

    /**
     * Make a Chain with the start from one chain and the ends from another.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.stepfunctions.Chain sequence(final software.amazon.awscdk.services.stepfunctions.IChainable start, final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "sequence", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Begin a new Chain from one chainable.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.stepfunctions.Chain start(final software.amazon.awscdk.services.stepfunctions.IChainable state) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "start", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(state, "state is required") });
    }

    /**
     * Continue normal execution with the given state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Chain next(final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return a single state that encompasses all states in the chain.
     * 
     * This can be used to add error handling to a sequence of states.
     * 
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.ParallelProps props) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Return a single state that encompasses all states in the chain.
     * 
     * This can be used to add error handling to a sequence of states.
     * 
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final java.lang.String id) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The chainable end state(s) of this chain.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }

    /**
     * Identify this Chain.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getId() {
        return this.jsiiGet("id", java.lang.String.class);
    }

    /**
     * The start state of this chain.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }
}
