package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Parallel state in the state machine.
 * 
 * A Parallel state can be used to run one or more state machines at the same
 * time.
 * 
 * The Result of a Parallel state is an array of the results of its substatemachines.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:09:30.924Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Parallel")
public class Parallel extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {
    protected Parallel(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Parallel(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.ParallelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Parallel(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a recovery handler for this state.
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel addRetry(@javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel addRetry() {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Parallel.class);
    }

    /**
     * Define one or more branches to run in parallel.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Parallel branch(final software.amazon.awscdk.services.stepfunctions.IChainable... branches) {
        return this.jsiiCall("branch", software.amazon.awscdk.services.stepfunctions.Parallel.class, java.util.Arrays.<Object>stream(branches).toArray(Object[]::new));
    }

    /**
     * Continue normal execution with the given state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.stepfunctions.Chain next(final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Validate this state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * Continuable states of this Chainable.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }
}
