package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of connected states.
 * 
 * A StateGraph is used to keep track of all states that are connected (have
 * transitions between them). It does not include the substatemachines in
 * a Parallel's branches: those are their own StateGraphs, but the graphs
 * themselves have a hierarchical relationship as well.
 * 
 * By assigning states to a definintive StateGraph, we verify that no state
 * machines are constructed. In particular:
 * 
 * - Every state object can only ever be in 1 StateGraph, and not inadvertently
 *    be used in two graphs.
 * - Every stateId must be unique across all states in the entire state
 *    machine.
 * 
 * All policy statements in all states in all substatemachines are bubbled so
 * that the top-level StateMachine instantiation can read them all and add
 * them to the IAM Role.
 * 
 * You do not need to instantiate this class; it is used internally.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:09:30.931Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.StateGraph")
public class StateGraph extends software.amazon.jsii.JsiiObject {
    protected StateGraph(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public StateGraph(final software.amazon.awscdk.services.stepfunctions.State startState, final java.lang.String graphDescription) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(startState, "startState is required"), java.util.Objects.requireNonNull(graphDescription, "graphDescription is required") });
    }

    /**
     * Register a Policy Statement used by states in this graph.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void registerPolicyStatement(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("registerPolicyStatement", Void.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Register a state as part of this graph.
     * 
     * Called by State.bindToGraph().
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void registerState(final software.amazon.awscdk.services.stepfunctions.State state) {
        this.jsiiCall("registerState", Void.class, new Object[] { java.util.Objects.requireNonNull(state, "state is required") });
    }

    /**
     * Register this graph as a child of the given graph.
     * 
     * Resource changes will be bubbled up to the given graph.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void registerSuperGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("registerSuperGraph", Void.class, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Return the Amazon States Language JSON for this graph.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public com.fasterxml.jackson.databind.node.ObjectNode toGraphJson() {
        return this.jsiiCall("toGraphJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Return a string description of this graph.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * The accumulated policy statements.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
        return this.jsiiGet("policyStatements", java.util.List.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    /**
     * Set a timeout to render into the graph JSON.
     * 
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * 
     * Default: No timeout
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public java.lang.Number getTimeoutSeconds() {
        return this.jsiiGet("timeoutSeconds", java.lang.Number.class);
    }

    /**
     * Set a timeout to render into the graph JSON.
     * 
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * 
     * Default: No timeout
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("timeoutSeconds", value);
    }
}
