package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties that define what kind of task should be created.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:09:30.935Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StepFunctionsTaskConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * The resource that represents the work to be executed.
     * 
     * Either the ARN of a Lambda Function or Activity, or a special
     * ARN.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getResourceArn();
    /**
     * Maximum time between heart beats.
     * 
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     * 
     * This is only relevant when using an Activity type as resource.
     * 
     * Default: No heart beat timeout
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getHeartbeatSeconds();
    /**
     * The dimensions to attach to metrics.
     * 
     * Default: No metrics
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions();
    /**
     * Prefix for plural metric names of activity actions.
     * 
     * Default: No such metrics
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMetricPrefixPlural();
    /**
     * Prefix for singular metric names of activity actions.
     * 
     * Default: No such metrics
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMetricPrefixSingular();
    /**
     * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     * 
     * What is passed here will be merged with any default parameters
     * configured by the `resource`. For example, a DynamoDB table target
     * will
     * 
     * Default: No parameters
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.Object> getParameters();
    /**
     * Additional policy statements to add to the execution role.
     * 
     * Default: No policy roles
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements();

    /**
     * @return a {@link Builder} of {@link StepFunctionsTaskConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StepFunctionsTaskConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _resourceArn;
        @javax.annotation.Nullable
        private java.lang.Number _heartbeatSeconds;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _metricDimensions;
        @javax.annotation.Nullable
        private java.lang.String _metricPrefixPlural;
        @javax.annotation.Nullable
        private java.lang.String _metricPrefixSingular;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _parameters;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _policyStatements;

        /**
         * Sets the value of ResourceArn
         * @param value The resource that represents the work to be executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResourceArn(final java.lang.String value) {
            this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
            return this;
        }
        /**
         * Sets the value of HeartbeatSeconds
         * @param value Maximum time between heart beats.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withHeartbeatSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this._heartbeatSeconds = value;
            return this;
        }
        /**
         * Sets the value of MetricDimensions
         * @param value The dimensions to attach to metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetricDimensions(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._metricDimensions = value;
            return this;
        }
        /**
         * Sets the value of MetricPrefixPlural
         * @param value Prefix for plural metric names of activity actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetricPrefixPlural(@javax.annotation.Nullable final java.lang.String value) {
            this._metricPrefixPlural = value;
            return this;
        }
        /**
         * Sets the value of MetricPrefixSingular
         * @param value Prefix for singular metric names of activity actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetricPrefixSingular(@javax.annotation.Nullable final java.lang.String value) {
            this._metricPrefixSingular = value;
            return this;
        }
        /**
         * Sets the value of Parameters
         * @param value Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._parameters = value;
            return this;
        }
        /**
         * Sets the value of PolicyStatements
         * @param value Additional policy statements to add to the execution role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPolicyStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._policyStatements = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepFunctionsTaskConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public StepFunctionsTaskConfig build() {
            return new StepFunctionsTaskConfig() {
                private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                @javax.annotation.Nullable
                private final java.lang.Number $heartbeatSeconds = _heartbeatSeconds;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $metricDimensions = _metricDimensions;
                @javax.annotation.Nullable
                private final java.lang.String $metricPrefixPlural = _metricPrefixPlural;
                @javax.annotation.Nullable
                private final java.lang.String $metricPrefixSingular = _metricPrefixSingular;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $parameters = _parameters;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $policyStatements = _policyStatements;

                @Override
                public java.lang.String getResourceArn() {
                    return this.$resourceArn;
                }

                @Override
                public java.lang.Number getHeartbeatSeconds() {
                    return this.$heartbeatSeconds;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions() {
                    return this.$metricDimensions;
                }

                @Override
                public java.lang.String getMetricPrefixPlural() {
                    return this.$metricPrefixPlural;
                }

                @Override
                public java.lang.String getMetricPrefixSingular() {
                    return this.$metricPrefixSingular;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getParameters() {
                    return this.$parameters;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
                    return this.$policyStatements;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                    if (this.getHeartbeatSeconds() != null) {
                        obj.set("heartbeatSeconds", om.valueToTree(this.getHeartbeatSeconds()));
                    }
                    if (this.getMetricDimensions() != null) {
                        obj.set("metricDimensions", om.valueToTree(this.getMetricDimensions()));
                    }
                    if (this.getMetricPrefixPlural() != null) {
                        obj.set("metricPrefixPlural", om.valueToTree(this.getMetricPrefixPlural()));
                    }
                    if (this.getMetricPrefixSingular() != null) {
                        obj.set("metricPrefixSingular", om.valueToTree(this.getMetricPrefixSingular()));
                    }
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    if (this.getPolicyStatements() != null) {
                        obj.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The resource that represents the work to be executed.
         * 
         * Either the ARN of a Lambda Function or Activity, or a special
         * ARN.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getResourceArn() {
            return this.jsiiGet("resourceArn", java.lang.String.class);
        }

        /**
         * Maximum time between heart beats.
         * 
         * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
         * 
         * This is only relevant when using an Activity type as resource.
         * 
         * Default: No heart beat timeout
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getHeartbeatSeconds() {
            return this.jsiiGet("heartbeatSeconds", java.lang.Number.class);
        }

        /**
         * The dimensions to attach to metrics.
         * 
         * Default: No metrics
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getMetricDimensions() {
            return this.jsiiGet("metricDimensions", java.util.Map.class);
        }

        /**
         * Prefix for plural metric names of activity actions.
         * 
         * Default: No such metrics
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getMetricPrefixPlural() {
            return this.jsiiGet("metricPrefixPlural", java.lang.String.class);
        }

        /**
         * Prefix for singular metric names of activity actions.
         * 
         * Default: No such metrics
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getMetricPrefixSingular() {
            return this.jsiiGet("metricPrefixSingular", java.lang.String.class);
        }

        /**
         * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
         * 
         * What is passed here will be merged with any default parameters
         * configured by the `resource`. For example, a DynamoDB table target
         * will
         * 
         * Default: No parameters
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.jsiiGet("parameters", java.util.Map.class);
        }

        /**
         * Additional policy statements to add to the execution role.
         * 
         * Default: No policy roles
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
            return this.jsiiGet("policyStatements", java.util.List.class);
        }
    }
}
