package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Task state in the state machine.
 * 
 * Reaching a Task state causes some work to be executed, represented by the
 * Task's resource property. Task constructs represent a generic Amazon
 * States Language Task.
 * 
 * For some resource types, more specific subclasses of Task may be available
 * which are more convenient to use.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:09:30.936Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Task")
public class Task extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {
    protected Task(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Task(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.stepfunctions.TaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a recovery handler for this state.
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Task addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler, @javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Task.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * 
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Task addCatch(final software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return this.jsiiCall("addCatch", software.amazon.awscdk.services.stepfunctions.Task.class, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Task addRetry(@javax.annotation.Nullable final software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Task.class, new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * 
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.stepfunctions.Task addRetry() {
        return this.jsiiCall("addRetry", software.amazon.awscdk.services.stepfunctions.Task.class);
    }

    /**
     * Return the given named metric for this Task.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Task.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of times this activity fails.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailed(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity fails.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricFailed() {
        return this.jsiiCall("metricFailed", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times the heartbeat times out for this activity.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricHeartbeatTimedOut() {
        return this.jsiiCall("metricHeartbeatTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRunTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, between the time the Task starts and the time it closes.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricRunTime() {
        return this.jsiiCall("metricRunTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is scheduled.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduled(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity is scheduled.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduled() {
        return this.jsiiCall("metricScheduled", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, for which the activity stays in the schedule state.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricScheduleTime() {
        return this.jsiiCall("metricScheduleTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity is started.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricStarted(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity is started.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricStarted() {
        return this.jsiiCall("metricStarted", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity succeeds.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity succeeds.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricSucceeded() {
        return this.jsiiCall("metricSucceeded", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     * 
     * Default: average over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTime() {
        return this.jsiiCall("metricTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of times this activity times out.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of times this activity times out.
     * 
     * Default: sum over 5 minutes
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric metricTimedOut() {
        return this.jsiiCall("metricTimedOut", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Continue normal execution with the given state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.stepfunctions.Chain next(final software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Called whenever this state is bound to a graph.
     * 
     * Can be overridden by subclasses.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected void whenBoundToGraph(final software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("whenBoundToGraph", Void.class, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Continuable states of this Chainable.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return this.jsiiGet("endStates", java.util.List.class);
    }
}
