package software.amazon.awscdk.services.stepfunctions.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html
 */
public interface ActivityResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::StepFunctions::Activity.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
     */
    java.lang.Object getActivityName();
    /**
     * ``AWS::StepFunctions::Activity.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
     */
    void setActivityName(final java.lang.String value);
    /**
     * ``AWS::StepFunctions::Activity.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
     */
    void setActivityName(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ActivityResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::StepFunctions::Activity.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
         */
        public Build withActivityName(final java.lang.String value) {
            return new FullBuilder().withActivityName(value);
        }
        /**
         * ``AWS::StepFunctions::Activity.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
         */
        public Build withActivityName(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withActivityName(value);
        }

        public interface Build {
            /**
             * @return a new {@link ActivityResourceProps} object, initialized with the values set on this builder.
             */
            ActivityResourceProps build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::StepFunctions::Activity.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
             */
            public Build withActivityName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "ActivityResourceProps#activityName is required");
                this.instance._activityName = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::Activity.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
             */
            public Build withActivityName(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "ActivityResourceProps#activityName is required");
                this.instance._activityName = value;
                return this;
            }
            public ActivityResourceProps build() {
                ActivityResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ActivityResourceProps}.
     */
    final class Jsii$Pojo implements ActivityResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _activityName;

        public java.lang.Object getActivityName() {
            return this._activityName;
        }
        public void setActivityName(final java.lang.String value) {
            this._activityName = value;
        }
        public void setActivityName(final software.amazon.awscdk.Token value) {
            this._activityName = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.cloudformation.ActivityResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::StepFunctions::Activity.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
         */
        public java.lang.Object getActivityName() {
            return this.jsiiGet("activityName", java.lang.Object.class);
        }
        /**
         * ``AWS::StepFunctions::Activity.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
         */
        public void setActivityName(final java.lang.String value) {
            this.jsiiSet("activityName", java.util.Objects.requireNonNull(value, "activityName is required"));
        }
        /**
         * ``AWS::StepFunctions::Activity.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
         */
        public void setActivityName(final software.amazon.awscdk.Token value) {
            this.jsiiSet("activityName", java.util.Objects.requireNonNull(value, "activityName is required"));
        }
    }
}
