package software.amazon.awscdk.services.stepfunctions.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 */
public interface StateMachineResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::StepFunctions::StateMachine.DefinitionString``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
     */
    java.lang.Object getDefinitionString();
    /**
     * ``AWS::StepFunctions::StateMachine.DefinitionString``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
     */
    void setDefinitionString(final java.lang.String value);
    /**
     * ``AWS::StepFunctions::StateMachine.DefinitionString``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
     */
    void setDefinitionString(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::StepFunctions::StateMachine.RoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
     */
    java.lang.Object getRoleArn();
    /**
     * ``AWS::StepFunctions::StateMachine.RoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
     */
    void setRoleArn(final java.lang.String value);
    /**
     * ``AWS::StepFunctions::StateMachine.RoleArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
     */
    void setRoleArn(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::StepFunctions::StateMachine.StateMachineName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
     */
    java.lang.Object getStateMachineName();
    /**
     * ``AWS::StepFunctions::StateMachine.StateMachineName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
     */
    void setStateMachineName(final java.lang.String value);
    /**
     * ``AWS::StepFunctions::StateMachine.StateMachineName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
     */
    void setStateMachineName(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link StateMachineResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::StepFunctions::StateMachine.DefinitionString``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
         */
        public RoleArnStep withDefinitionString(final java.lang.String value) {
            return new FullBuilder().withDefinitionString(value);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.DefinitionString``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
         */
        public RoleArnStep withDefinitionString(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withDefinitionString(value);
        }

        public interface RoleArnStep {
            /**
             * ``AWS::StepFunctions::StateMachine.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
             */
            Build withRoleArn(final java.lang.String value);
            /**
             * ``AWS::StepFunctions::StateMachine.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
             */
            Build withRoleArn(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link StateMachineResourceProps} object, initialized with the values set on this builder.
             */
            StateMachineResourceProps build();
            /**
             * ``AWS::StepFunctions::StateMachine.StateMachineName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
             */
            Build withStateMachineName(final java.lang.String value);
            /**
             * ``AWS::StepFunctions::StateMachine.StateMachineName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
             */
            Build withStateMachineName(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements RoleArnStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::StepFunctions::StateMachine.DefinitionString``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
             */
            public RoleArnStep withDefinitionString(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "StateMachineResourceProps#definitionString is required");
                this.instance._definitionString = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::StateMachine.DefinitionString``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
             */
            public RoleArnStep withDefinitionString(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "StateMachineResourceProps#definitionString is required");
                this.instance._definitionString = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::StateMachine.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
             */
            public Build withRoleArn(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "StateMachineResourceProps#roleArn is required");
                this.instance._roleArn = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::StateMachine.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
             */
            public Build withRoleArn(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "StateMachineResourceProps#roleArn is required");
                this.instance._roleArn = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::StateMachine.StateMachineName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
             */
            public Build withStateMachineName(final java.lang.String value) {
                this.instance._stateMachineName = value;
                return this;
            }
            /**
             * ``AWS::StepFunctions::StateMachine.StateMachineName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
             */
            public Build withStateMachineName(final software.amazon.awscdk.Token value) {
                this.instance._stateMachineName = value;
                return this;
            }
            public StateMachineResourceProps build() {
                StateMachineResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link StateMachineResourceProps}.
     */
    final class Jsii$Pojo implements StateMachineResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _definitionString;

        public java.lang.Object getDefinitionString() {
            return this._definitionString;
        }
        public void setDefinitionString(final java.lang.String value) {
            this._definitionString = value;
        }
        public void setDefinitionString(final software.amazon.awscdk.Token value) {
            this._definitionString = value;
        }

        protected java.lang.Object _roleArn;

        public java.lang.Object getRoleArn() {
            return this._roleArn;
        }
        public void setRoleArn(final java.lang.String value) {
            this._roleArn = value;
        }
        public void setRoleArn(final software.amazon.awscdk.Token value) {
            this._roleArn = value;
        }

        protected java.lang.Object _stateMachineName;

        public java.lang.Object getStateMachineName() {
            return this._stateMachineName;
        }
        public void setStateMachineName(final java.lang.String value) {
            this._stateMachineName = value;
        }
        public void setStateMachineName(final software.amazon.awscdk.Token value) {
            this._stateMachineName = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.cloudformation.StateMachineResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.DefinitionString``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
         */
        public java.lang.Object getDefinitionString() {
            return this.jsiiGet("definitionString", java.lang.Object.class);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.DefinitionString``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
         */
        public void setDefinitionString(final java.lang.String value) {
            this.jsiiSet("definitionString", java.util.Objects.requireNonNull(value, "definitionString is required"));
        }
        /**
         * ``AWS::StepFunctions::StateMachine.DefinitionString``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
         */
        public void setDefinitionString(final software.amazon.awscdk.Token value) {
            this.jsiiSet("definitionString", java.util.Objects.requireNonNull(value, "definitionString is required"));
        }
        /**
         * ``AWS::StepFunctions::StateMachine.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
         */
        public java.lang.Object getRoleArn() {
            return this.jsiiGet("roleArn", java.lang.Object.class);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
         */
        public void setRoleArn(final java.lang.String value) {
            this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
        }
        /**
         * ``AWS::StepFunctions::StateMachine.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
         */
        public void setRoleArn(final software.amazon.awscdk.Token value) {
            this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
        }
        /**
         * ``AWS::StepFunctions::StateMachine.StateMachineName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
         */
        @javax.annotation.Nullable
        public java.lang.Object getStateMachineName() {
            return this.jsiiGet("stateMachineName", java.lang.Object.class);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.StateMachineName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
         */
        public void setStateMachineName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("stateMachineName", value);
        }
        /**
         * ``AWS::StepFunctions::StateMachine.StateMachineName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
         */
        public void setStateMachineName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("stateMachineName", value);
        }
    }
}
