package software.amazon.awscdk.services.stepfunctions;

/**
 * Retry details.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-06-02T17:52:47.674Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.RetryProps")
@software.amazon.jsii.Jsii.Proxy(RetryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RetryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Multiplication for how much longer the wait interval gets on every retry.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackoffRate() {
        return null;
    }

    /**
     * Errors to retry.
     * <p>
     * A list of error strings to retry, which can be either predefined errors
     * (for example Errors.NoChoiceMatched) or a self-defined error.
     * <p>
     * Default: All errors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getErrors() {
        return null;
    }

    /**
     * How many seconds to wait initially before retrying.
     * <p>
     * Default: Duration.seconds(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getInterval() {
        return null;
    }

    /**
     * How many times to retry this particular error.
     * <p>
     * May be 0 to disable retry for specific errors (in case you have
     * a catch-all retry policy).
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAttempts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RetryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RetryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RetryProps> {
        private java.lang.Number backoffRate;
        private java.util.List<java.lang.String> errors;
        private software.amazon.awscdk.core.Duration interval;
        private java.lang.Number maxAttempts;

        /**
         * Sets the value of {@link RetryProps#getBackoffRate}
         * @param backoffRate Multiplication for how much longer the wait interval gets on every retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffRate(java.lang.Number backoffRate) {
            this.backoffRate = backoffRate;
            return this;
        }

        /**
         * Sets the value of {@link RetryProps#getErrors}
         * @param errors Errors to retry.
         *               A list of error strings to retry, which can be either predefined errors
         *               (for example Errors.NoChoiceMatched) or a self-defined error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errors(java.util.List<java.lang.String> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Sets the value of {@link RetryProps#getInterval}
         * @param interval How many seconds to wait initially before retrying.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.core.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link RetryProps#getMaxAttempts}
         * @param maxAttempts How many times to retry this particular error.
         *                    May be 0 to disable retry for specific errors (in case you have
         *                    a catch-all retry policy).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttempts(java.lang.Number maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RetryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RetryProps build() {
            return new Jsii$Proxy(backoffRate, errors, interval, maxAttempts);
        }
    }

    /**
     * An implementation for {@link RetryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryProps {
        private final java.lang.Number backoffRate;
        private final java.util.List<java.lang.String> errors;
        private final software.amazon.awscdk.core.Duration interval;
        private final java.lang.Number maxAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backoffRate = software.amazon.jsii.Kernel.get(this, "backoffRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.maxAttempts = software.amazon.jsii.Kernel.get(this, "maxAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number backoffRate, final java.util.List<java.lang.String> errors, final software.amazon.awscdk.core.Duration interval, final java.lang.Number maxAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backoffRate = backoffRate;
            this.errors = errors;
            this.interval = interval;
            this.maxAttempts = maxAttempts;
        }

        @Override
        public final java.lang.Number getBackoffRate() {
            return this.backoffRate;
        }

        @Override
        public final java.util.List<java.lang.String> getErrors() {
            return this.errors;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final java.lang.Number getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackoffRate() != null) {
                data.set("backoffRate", om.valueToTree(this.getBackoffRate()));
            }
            if (this.getErrors() != null) {
                data.set("errors", om.valueToTree(this.getErrors()));
            }
            if (this.getInterval() != null) {
                data.set("interval", om.valueToTree(this.getInterval()));
            }
            if (this.getMaxAttempts() != null) {
                data.set("maxAttempts", om.valueToTree(this.getMaxAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.RetryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RetryProps.Jsii$Proxy that = (RetryProps.Jsii$Proxy) o;

            if (this.backoffRate != null ? !this.backoffRate.equals(that.backoffRate) : that.backoffRate != null) return false;
            if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
            if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
            return this.maxAttempts != null ? this.maxAttempts.equals(that.maxAttempts) : that.maxAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backoffRate != null ? this.backoffRate.hashCode() : 0;
            result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
            result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
            result = 31 * result + (this.maxAttempts != null ? this.maxAttempts.hashCode() : 0);
            return result;
        }
    }
}
