/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.transform.AlarmMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Alarm
implements StructuredPojo,
ToCopyableBuilder<Builder, Alarm> {
    private final String alarmName;
    private final String alarmARN;

    private Alarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmARN = builder.alarmARN;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmARN() {
        return this.alarmARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmName() == null ? 0 : this.alarmName().hashCode());
        hashCode = 31 * hashCode + (this.alarmARN() == null ? 0 : this.alarmARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.alarmARN() == null ^ this.alarmARN() == null) {
            return false;
        }
        return other.alarmARN() == null || other.alarmARN().equals(this.alarmARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.alarmARN() != null) {
            sb.append("AlarmARN: ").append(this.alarmARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            this.setAlarmName(model.alarmName);
            this.setAlarmARN(model.alarmARN);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmARN() {
            return this.alarmARN;
        }

        @Override
        public final Builder alarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
            return this;
        }

        public final void setAlarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
        }

        public Alarm build() {
            return new Alarm(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Alarm> {
        public Builder alarmName(String var1);

        public Builder alarmARN(String var1);
    }
}

