/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricDimensionsCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic;
import software.amazon.awssdk.services.applicationautoscaling.transform.CustomizedMetricSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomizedMetricSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, CustomizedMetricSpecification> {
    private final String metricName;
    private final String namespace;
    private final List<MetricDimension> dimensions;
    private final String statistic;
    private final String unit;

    private CustomizedMetricSpecification(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.dimensions = builder.dimensions;
        this.statistic = builder.statistic;
        this.unit = builder.unit;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public String statistic() {
        return this.statistic;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.statistic() == null ? 0 : this.statistic().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizedMetricSpecification)) {
            return false;
        }
        CustomizedMetricSpecification other = (CustomizedMetricSpecification)obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.statistic() != null) {
            sb.append("Statistic: ").append(this.statistic()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomizedMetricSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String namespace;
        private List<MetricDimension> dimensions;
        private String statistic;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizedMetricSpecification model) {
            this.setMetricName(model.metricName);
            this.setNamespace(model.namespace);
            this.setDimensions(model.dimensions);
            this.setStatistic(model.statistic);
            this.setUnit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(MetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionsCopier.copy(dimensions);
        }

        @SafeVarargs
        public final void setDimensions(MetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(MetricStatistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final void setStatistic(MetricStatistic statistic) {
            this.statistic(statistic.toString());
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public CustomizedMetricSpecification build() {
            return new CustomizedMetricSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomizedMetricSpecification> {
        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder dimensions(Collection<MetricDimension> var1);

        public Builder dimensions(MetricDimension ... var1);

        public Builder statistic(String var1);

        public Builder statistic(MetricStatistic var1);

        public Builder unit(String var1);
    }
}

