/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ResourceIdsMaxLen1600Copier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalableTargetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeScalableTargetsRequest> {
    private final String serviceNamespace;
    private final List<String> resourceIds;
    private final String scalableDimension;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeScalableTargetsRequest(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceIds = builder.resourceIds;
        this.scalableDimension = builder.scalableDimension;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String serviceNamespace() {
        return this.serviceNamespace;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public String scalableDimension() {
        return this.scalableDimension;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serviceNamespace() == null ? 0 : this.serviceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.resourceIds() == null ? 0 : this.resourceIds().hashCode());
        hashCode = 31 * hashCode + (this.scalableDimension() == null ? 0 : this.scalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsRequest)) {
            return false;
        }
        DescribeScalableTargetsRequest other = (DescribeScalableTargetsRequest)((Object)obj);
        if (other.serviceNamespace() == null ^ this.serviceNamespace() == null) {
            return false;
        }
        if (other.serviceNamespace() != null && !other.serviceNamespace().equals(this.serviceNamespace())) {
            return false;
        }
        if (other.resourceIds() == null ^ this.resourceIds() == null) {
            return false;
        }
        if (other.resourceIds() != null && !other.resourceIds().equals(this.resourceIds())) {
            return false;
        }
        if (other.scalableDimension() == null ^ this.scalableDimension() == null) {
            return false;
        }
        if (other.scalableDimension() != null && !other.scalableDimension().equals(this.scalableDimension())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.serviceNamespace()).append(",");
        }
        if (this.resourceIds() != null) {
            sb.append("ResourceIds: ").append(this.resourceIds()).append(",");
        }
        if (this.scalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.scalableDimension()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private List<String> resourceIds;
        private String scalableDimension;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsRequest model) {
            this.setServiceNamespace(model.serviceNamespace);
            this.setResourceIds(model.resourceIds);
            this.setScalableDimension(model.scalableDimension);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final void setServiceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsMaxLen1600Copier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsMaxLen1600Copier.copy(resourceIds);
        }

        @SafeVarargs
        public final void setResourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final void setScalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalableTargetsRequest build() {
            return new DescribeScalableTargetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalableTargetsRequest> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

