/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalableTargetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScalableTargetsResponse> {
    private final List<ScalableTarget> scalableTargets;
    private final String nextToken;

    private DescribeScalableTargetsResponse(BuilderImpl builder) {
        this.scalableTargets = builder.scalableTargets;
        this.nextToken = builder.nextToken;
    }

    public List<ScalableTarget> scalableTargets() {
        return this.scalableTargets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.scalableTargets() == null ? 0 : this.scalableTargets().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsResponse)) {
            return false;
        }
        DescribeScalableTargetsResponse other = (DescribeScalableTargetsResponse)((Object)obj);
        if (other.scalableTargets() == null ^ this.scalableTargets() == null) {
            return false;
        }
        if (other.scalableTargets() != null && !other.scalableTargets().equals(this.scalableTargets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.scalableTargets() != null) {
            sb.append("ScalableTargets: ").append(this.scalableTargets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ScalableTarget> scalableTargets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsResponse model) {
            this.setScalableTargets(model.scalableTargets);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ScalableTarget> getScalableTargets() {
            return this.scalableTargets;
        }

        @Override
        public final Builder scalableTargets(Collection<ScalableTarget> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copy(scalableTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(ScalableTarget ... scalableTargets) {
            this.scalableTargets(Arrays.asList(scalableTargets));
            return this;
        }

        public final void setScalableTargets(Collection<ScalableTarget> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copy(scalableTargets);
        }

        @SafeVarargs
        public final void setScalableTargets(ScalableTarget ... scalableTargets) {
            this.scalableTargets(Arrays.asList(scalableTargets));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalableTargetsResponse build() {
            return new DescribeScalableTargetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalableTargetsResponse> {
        public Builder scalableTargets(Collection<ScalableTarget> var1);

        public Builder scalableTargets(ScalableTarget ... var1);

        public Builder nextToken(String var1);
    }
}

