/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivitiesCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingActivitiesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
    private final List<ScalingActivity> scalingActivities;
    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        this.scalingActivities = builder.scalingActivities;
        this.nextToken = builder.nextToken;
    }

    public List<ScalingActivity> scalingActivities() {
        return this.scalingActivities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.scalingActivities() == null ? 0 : this.scalingActivities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse)((Object)obj);
        if (other.scalingActivities() == null ^ this.scalingActivities() == null) {
            return false;
        }
        if (other.scalingActivities() != null && !other.scalingActivities().equals(this.scalingActivities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.scalingActivities() != null) {
            sb.append("ScalingActivities: ").append(this.scalingActivities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ScalingActivity> scalingActivities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            this.setScalingActivities(model.scalingActivities);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ScalingActivity> getScalingActivities() {
            return this.scalingActivities;
        }

        @Override
        public final Builder scalingActivities(Collection<ScalingActivity> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copy(scalingActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(ScalingActivity ... scalingActivities) {
            this.scalingActivities(Arrays.asList(scalingActivities));
            return this;
        }

        public final void setScalingActivities(Collection<ScalingActivity> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copy(scalingActivities);
        }

        @SafeVarargs
        public final void setScalingActivities(ScalingActivity ... scalingActivities) {
            this.scalingActivities(Arrays.asList(scalingActivities));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        public Builder scalingActivities(Collection<ScalingActivity> var1);

        public Builder scalingActivities(ScalingActivity ... var1);

        public Builder nextToken(String var1);
    }
}

