/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.applicationautoscaling.model.Alarm;
import software.amazon.awssdk.services.applicationautoscaling.model.AlarmsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutScalingPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutScalingPolicyResponse> {
    private final String policyARN;
    private final List<Alarm> alarms;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.alarms = builder.alarms;
    }

    public String policyARN() {
        return this.policyARN;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyARN() == null ? 0 : this.policyARN().hashCode());
        hashCode = 31 * hashCode + (this.alarms() == null ? 0 : this.alarms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse)((Object)obj);
        if (other.policyARN() == null ^ this.policyARN() == null) {
            return false;
        }
        if (other.policyARN() != null && !other.policyARN().equals(this.policyARN())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        return other.alarms() == null || other.alarms().equals(this.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyARN() != null) {
            sb.append("PolicyARN: ").append(this.policyARN()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policyARN;
        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            this.setPolicyARN(model.policyARN);
            this.setAlarms(model.alarms);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final Collection<Alarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
        }

        @SafeVarargs
        public final void setAlarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
        }

        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutScalingPolicyResponse> {
        public Builder policyARN(String var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);
    }
}

