/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ScalableDimension {
    EcsServiceDesiredCount("ecs:service:DesiredCount"),
    Ec2SpotFleetRequestTargetCapacity("ec2:spot-fleet-request:TargetCapacity"),
    ElasticmapreduceInstancegroupInstanceCount("elasticmapreduce:instancegroup:InstanceCount"),
    AppstreamFleetDesiredCapacity("appstream:fleet:DesiredCapacity"),
    DynamodbTableReadCapacityUnits("dynamodb:table:ReadCapacityUnits"),
    DynamodbTableWriteCapacityUnits("dynamodb:table:WriteCapacityUnits"),
    DynamodbIndexReadCapacityUnits("dynamodb:index:ReadCapacityUnits"),
    DynamodbIndexWriteCapacityUnits("dynamodb:index:WriteCapacityUnits");

    private final String value;

    private ScalableDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ScalableDimension fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ScalableDimension.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

