/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.transform.ScalableTargetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalableTarget
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalableTarget> {
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final String roleARN;
    private final Instant creationTime;

    private ScalableTarget(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.roleARN = builder.roleARN;
        this.creationTime = builder.creationTime;
    }

    public String serviceNamespace() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String scalableDimension() {
        return this.scalableDimension;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serviceNamespace() == null ? 0 : this.serviceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.scalableDimension() == null ? 0 : this.scalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.minCapacity() == null ? 0 : this.minCapacity().hashCode());
        hashCode = 31 * hashCode + (this.maxCapacity() == null ? 0 : this.maxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalableTarget)) {
            return false;
        }
        ScalableTarget other = (ScalableTarget)obj;
        if (other.serviceNamespace() == null ^ this.serviceNamespace() == null) {
            return false;
        }
        if (other.serviceNamespace() != null && !other.serviceNamespace().equals(this.serviceNamespace())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.scalableDimension() == null ^ this.scalableDimension() == null) {
            return false;
        }
        if (other.scalableDimension() != null && !other.scalableDimension().equals(this.scalableDimension())) {
            return false;
        }
        if (other.minCapacity() == null ^ this.minCapacity() == null) {
            return false;
        }
        if (other.minCapacity() != null && !other.minCapacity().equals(this.minCapacity())) {
            return false;
        }
        if (other.maxCapacity() == null ^ this.maxCapacity() == null) {
            return false;
        }
        if (other.maxCapacity() != null && !other.maxCapacity().equals(this.maxCapacity())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        return other.creationTime() == null || other.creationTime().equals(this.creationTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.serviceNamespace()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.scalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.scalableDimension()).append(",");
        }
        if (this.minCapacity() != null) {
            sb.append("MinCapacity: ").append(this.minCapacity()).append(",");
        }
        if (this.maxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.maxCapacity()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalableTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer minCapacity;
        private Integer maxCapacity;
        private String roleARN;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalableTarget model) {
            this.setServiceNamespace(model.serviceNamespace);
            this.setResourceId(model.resourceId);
            this.setScalableDimension(model.scalableDimension);
            this.setMinCapacity(model.minCapacity);
            this.setMaxCapacity(model.maxCapacity);
            this.setRoleARN(model.roleARN);
            this.setCreationTime(model.creationTime);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final void setServiceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final void setScalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public ScalableTarget build() {
            return new ScalableTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalableTarget> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder roleARN(String var1);

        public Builder creationTime(Instant var1);
    }
}

