/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.transform.ScalingActivityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingActivity
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingActivity> {
    private final String activityId;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String description;
    private final String cause;
    private final Instant startTime;
    private final Instant endTime;
    private final String statusCode;
    private final String statusMessage;
    private final String details;

    private ScalingActivity(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.description = builder.description;
        this.cause = builder.cause;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.details = builder.details;
    }

    public String activityId() {
        return this.activityId;
    }

    public String serviceNamespace() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String scalableDimension() {
        return this.scalableDimension;
    }

    public String description() {
        return this.description;
    }

    public String cause() {
        return this.cause;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activityId() == null ? 0 : this.activityId().hashCode());
        hashCode = 31 * hashCode + (this.serviceNamespace() == null ? 0 : this.serviceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.scalableDimension() == null ? 0 : this.scalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.cause() == null ? 0 : this.cause().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingActivity)) {
            return false;
        }
        ScalingActivity other = (ScalingActivity)obj;
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        if (other.serviceNamespace() == null ^ this.serviceNamespace() == null) {
            return false;
        }
        if (other.serviceNamespace() != null && !other.serviceNamespace().equals(this.serviceNamespace())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.scalableDimension() == null ^ this.scalableDimension() == null) {
            return false;
        }
        if (other.scalableDimension() != null && !other.scalableDimension().equals(this.scalableDimension())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        return other.details() == null || other.details().equals(this.details());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activityId() != null) {
            sb.append("ActivityId: ").append(this.activityId()).append(",");
        }
        if (this.serviceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.serviceNamespace()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.scalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.scalableDimension()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.cause() != null) {
            sb.append("Cause: ").append(this.cause()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String activityId;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String description;
        private String cause;
        private Instant startTime;
        private Instant endTime;
        private String statusCode;
        private String statusMessage;
        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingActivity model) {
            this.setActivityId(model.activityId);
            this.setServiceNamespace(model.serviceNamespace);
            this.setResourceId(model.resourceId);
            this.setScalableDimension(model.scalableDimension);
            this.setDescription(model.description);
            this.setCause(model.cause);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setStatusCode(model.statusCode);
            this.setStatusMessage(model.statusMessage);
            this.setDetails(model.details);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final void setServiceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final void setScalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCause() {
            return this.cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final void setStatusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public ScalingActivity build() {
            return new ScalingActivity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingActivity> {
        public Builder activityId(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder description(String var1);

        public Builder cause(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ScalingActivityStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder details(String var1);
    }
}

