/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.Alarm;
import software.amazon.awssdk.services.applicationautoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.PolicyType;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.transform.ScalingPolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private final String policyARN;
    private final String policyName;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String policyType;
    private final StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
    private final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
    private final List<Alarm> alarms;
    private final Instant creationTime;

    private ScalingPolicy(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.policyName = builder.policyName;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.policyType = builder.policyType;
        this.stepScalingPolicyConfiguration = builder.stepScalingPolicyConfiguration;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
        this.alarms = builder.alarms;
        this.creationTime = builder.creationTime;
    }

    public String policyARN() {
        return this.policyARN;
    }

    public String policyName() {
        return this.policyName;
    }

    public String serviceNamespace() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String scalableDimension() {
        return this.scalableDimension;
    }

    public String policyType() {
        return this.policyType;
    }

    public StepScalingPolicyConfiguration stepScalingPolicyConfiguration() {
        return this.stepScalingPolicyConfiguration;
    }

    public TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyARN() == null ? 0 : this.policyARN().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.serviceNamespace() == null ? 0 : this.serviceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.scalableDimension() == null ? 0 : this.scalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.policyType() == null ? 0 : this.policyType().hashCode());
        hashCode = 31 * hashCode + (this.stepScalingPolicyConfiguration() == null ? 0 : this.stepScalingPolicyConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.targetTrackingScalingPolicyConfiguration() == null ? 0 : this.targetTrackingScalingPolicyConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.alarms() == null ? 0 : this.alarms().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.policyARN() == null ^ this.policyARN() == null) {
            return false;
        }
        if (other.policyARN() != null && !other.policyARN().equals(this.policyARN())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.serviceNamespace() == null ^ this.serviceNamespace() == null) {
            return false;
        }
        if (other.serviceNamespace() != null && !other.serviceNamespace().equals(this.serviceNamespace())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.scalableDimension() == null ^ this.scalableDimension() == null) {
            return false;
        }
        if (other.scalableDimension() != null && !other.scalableDimension().equals(this.scalableDimension())) {
            return false;
        }
        if (other.policyType() == null ^ this.policyType() == null) {
            return false;
        }
        if (other.policyType() != null && !other.policyType().equals(this.policyType())) {
            return false;
        }
        if (other.stepScalingPolicyConfiguration() == null ^ this.stepScalingPolicyConfiguration() == null) {
            return false;
        }
        if (other.stepScalingPolicyConfiguration() != null && !other.stepScalingPolicyConfiguration().equals(this.stepScalingPolicyConfiguration())) {
            return false;
        }
        if (other.targetTrackingScalingPolicyConfiguration() == null ^ this.targetTrackingScalingPolicyConfiguration() == null) {
            return false;
        }
        if (other.targetTrackingScalingPolicyConfiguration() != null && !other.targetTrackingScalingPolicyConfiguration().equals(this.targetTrackingScalingPolicyConfiguration())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        if (other.alarms() != null && !other.alarms().equals(this.alarms())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        return other.creationTime() == null || other.creationTime().equals(this.creationTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyARN() != null) {
            sb.append("PolicyARN: ").append(this.policyARN()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.serviceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.serviceNamespace()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.scalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.scalableDimension()).append(",");
        }
        if (this.policyType() != null) {
            sb.append("PolicyType: ").append(this.policyType()).append(",");
        }
        if (this.stepScalingPolicyConfiguration() != null) {
            sb.append("StepScalingPolicyConfiguration: ").append(this.stepScalingPolicyConfiguration()).append(",");
        }
        if (this.targetTrackingScalingPolicyConfiguration() != null) {
            sb.append("TargetTrackingScalingPolicyConfiguration: ").append(this.targetTrackingScalingPolicyConfiguration()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String policyARN;
        private String policyName;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String policyType;
        private StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
        private TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
        private List<Alarm> alarms;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.setPolicyARN(model.policyARN);
            this.setPolicyName(model.policyName);
            this.setServiceNamespace(model.serviceNamespace);
            this.setResourceId(model.resourceId);
            this.setScalableDimension(model.scalableDimension);
            this.setPolicyType(model.policyType);
            this.setStepScalingPolicyConfiguration(model.stepScalingPolicyConfiguration);
            this.setTargetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
            this.setAlarms(model.alarms);
            this.setCreationTime(model.creationTime);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final void setServiceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final void setScalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final void setPolicyType(PolicyType policyType) {
            this.policyType(policyType.toString());
        }

        public final StepScalingPolicyConfiguration getStepScalingPolicyConfiguration() {
            return this.stepScalingPolicyConfiguration;
        }

        @Override
        public final Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        public final void setStepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
        }

        public final TargetTrackingScalingPolicyConfiguration getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
        }

        public final Collection<Alarm> getAlarms() {
            return this.alarms;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
        }

        @SafeVarargs
        public final void setAlarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingPolicy> {
        public Builder policyARN(String var1);

        public Builder policyName(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration var1);

        public Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder creationTime(Instant var1);
    }
}

