/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType;
import software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.services.applicationautoscaling.transform.StepScalingPolicyConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepScalingPolicyConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, StepScalingPolicyConfiguration> {
    private final String adjustmentType;
    private final List<StepAdjustment> stepAdjustments;
    private final Integer minAdjustmentMagnitude;
    private final Integer cooldown;
    private final String metricAggregationType;

    private StepScalingPolicyConfiguration(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
        this.stepAdjustments = builder.stepAdjustments;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
    }

    public String adjustmentType() {
        return this.adjustmentType;
    }

    public List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public Integer cooldown() {
        return this.cooldown;
    }

    public String metricAggregationType() {
        return this.metricAggregationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.adjustmentType() == null ? 0 : this.adjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.stepAdjustments() == null ? 0 : this.stepAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.minAdjustmentMagnitude() == null ? 0 : this.minAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + (this.cooldown() == null ? 0 : this.cooldown().hashCode());
        hashCode = 31 * hashCode + (this.metricAggregationType() == null ? 0 : this.metricAggregationType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepScalingPolicyConfiguration)) {
            return false;
        }
        StepScalingPolicyConfiguration other = (StepScalingPolicyConfiguration)obj;
        if (other.adjustmentType() == null ^ this.adjustmentType() == null) {
            return false;
        }
        if (other.adjustmentType() != null && !other.adjustmentType().equals(this.adjustmentType())) {
            return false;
        }
        if (other.stepAdjustments() == null ^ this.stepAdjustments() == null) {
            return false;
        }
        if (other.stepAdjustments() != null && !other.stepAdjustments().equals(this.stepAdjustments())) {
            return false;
        }
        if (other.minAdjustmentMagnitude() == null ^ this.minAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.minAdjustmentMagnitude() != null && !other.minAdjustmentMagnitude().equals(this.minAdjustmentMagnitude())) {
            return false;
        }
        if (other.cooldown() == null ^ this.cooldown() == null) {
            return false;
        }
        if (other.cooldown() != null && !other.cooldown().equals(this.cooldown())) {
            return false;
        }
        if (other.metricAggregationType() == null ^ this.metricAggregationType() == null) {
            return false;
        }
        return other.metricAggregationType() == null || other.metricAggregationType().equals(this.metricAggregationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(this.adjustmentType()).append(",");
        }
        if (this.stepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(this.stepAdjustments()).append(",");
        }
        if (this.minAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(this.minAdjustmentMagnitude()).append(",");
        }
        if (this.cooldown() != null) {
            sb.append("Cooldown: ").append(this.cooldown()).append(",");
        }
        if (this.metricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(this.metricAggregationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepScalingPolicyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String adjustmentType;
        private List<StepAdjustment> stepAdjustments;
        private Integer minAdjustmentMagnitude;
        private Integer cooldown;
        private String metricAggregationType;

        private BuilderImpl() {
        }

        private BuilderImpl(StepScalingPolicyConfiguration model) {
            this.setAdjustmentType(model.adjustmentType);
            this.setStepAdjustments(model.stepAdjustments);
            this.setMinAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.setCooldown(model.cooldown);
            this.setMetricAggregationType(model.metricAggregationType);
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        @Override
        public final Builder adjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final void setAdjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
        }

        public final Collection<StepAdjustment> getStepAdjustments() {
            return this.stepAdjustments;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
        }

        @SafeVarargs
        public final void setStepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        @Override
        public final Builder metricAggregationType(MetricAggregationType metricAggregationType) {
            this.metricAggregationType(metricAggregationType.toString());
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final void setMetricAggregationType(MetricAggregationType metricAggregationType) {
            this.metricAggregationType(metricAggregationType.toString());
        }

        public StepScalingPolicyConfiguration build() {
            return new StepScalingPolicyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepScalingPolicyConfiguration> {
        public Builder adjustmentType(String var1);

        public Builder adjustmentType(AdjustmentType var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder metricAggregationType(String var1);

        public Builder metricAggregationType(MetricAggregationType var1);
    }
}

