/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.services.applicationautoscaling.transform.TargetTrackingScalingPolicyConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetTrackingScalingPolicyConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
    private final Double targetValue;
    private final PredefinedMetricSpecification predefinedMetricSpecification;
    private final CustomizedMetricSpecification customizedMetricSpecification;
    private final Integer scaleOutCooldown;
    private final Integer scaleInCooldown;

    private TargetTrackingScalingPolicyConfiguration(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scaleInCooldown = builder.scaleInCooldown;
    }

    public Double targetValue() {
        return this.targetValue;
    }

    public PredefinedMetricSpecification predefinedMetricSpecification() {
        return this.predefinedMetricSpecification;
    }

    public CustomizedMetricSpecification customizedMetricSpecification() {
        return this.customizedMetricSpecification;
    }

    public Integer scaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public Integer scaleInCooldown() {
        return this.scaleInCooldown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetValue() == null ? 0 : this.targetValue().hashCode());
        hashCode = 31 * hashCode + (this.predefinedMetricSpecification() == null ? 0 : this.predefinedMetricSpecification().hashCode());
        hashCode = 31 * hashCode + (this.customizedMetricSpecification() == null ? 0 : this.customizedMetricSpecification().hashCode());
        hashCode = 31 * hashCode + (this.scaleOutCooldown() == null ? 0 : this.scaleOutCooldown().hashCode());
        hashCode = 31 * hashCode + (this.scaleInCooldown() == null ? 0 : this.scaleInCooldown().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicyConfiguration)) {
            return false;
        }
        TargetTrackingScalingPolicyConfiguration other = (TargetTrackingScalingPolicyConfiguration)obj;
        if (other.targetValue() == null ^ this.targetValue() == null) {
            return false;
        }
        if (other.targetValue() != null && !other.targetValue().equals(this.targetValue())) {
            return false;
        }
        if (other.predefinedMetricSpecification() == null ^ this.predefinedMetricSpecification() == null) {
            return false;
        }
        if (other.predefinedMetricSpecification() != null && !other.predefinedMetricSpecification().equals(this.predefinedMetricSpecification())) {
            return false;
        }
        if (other.customizedMetricSpecification() == null ^ this.customizedMetricSpecification() == null) {
            return false;
        }
        if (other.customizedMetricSpecification() != null && !other.customizedMetricSpecification().equals(this.customizedMetricSpecification())) {
            return false;
        }
        if (other.scaleOutCooldown() == null ^ this.scaleOutCooldown() == null) {
            return false;
        }
        if (other.scaleOutCooldown() != null && !other.scaleOutCooldown().equals(this.scaleOutCooldown())) {
            return false;
        }
        if (other.scaleInCooldown() == null ^ this.scaleInCooldown() == null) {
            return false;
        }
        return other.scaleInCooldown() == null || other.scaleInCooldown().equals(this.scaleInCooldown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetValue() != null) {
            sb.append("TargetValue: ").append(this.targetValue()).append(",");
        }
        if (this.predefinedMetricSpecification() != null) {
            sb.append("PredefinedMetricSpecification: ").append(this.predefinedMetricSpecification()).append(",");
        }
        if (this.customizedMetricSpecification() != null) {
            sb.append("CustomizedMetricSpecification: ").append(this.customizedMetricSpecification()).append(",");
        }
        if (this.scaleOutCooldown() != null) {
            sb.append("ScaleOutCooldown: ").append(this.scaleOutCooldown()).append(",");
        }
        if (this.scaleInCooldown() != null) {
            sb.append("ScaleInCooldown: ").append(this.scaleInCooldown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetTrackingScalingPolicyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Double targetValue;
        private PredefinedMetricSpecification predefinedMetricSpecification;
        private CustomizedMetricSpecification customizedMetricSpecification;
        private Integer scaleOutCooldown;
        private Integer scaleInCooldown;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicyConfiguration model) {
            this.setTargetValue(model.targetValue);
            this.setPredefinedMetricSpecification(model.predefinedMetricSpecification);
            this.setCustomizedMetricSpecification(model.customizedMetricSpecification);
            this.setScaleOutCooldown(model.scaleOutCooldown);
            this.setScaleInCooldown(model.scaleInCooldown);
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final PredefinedMetricSpecification getPredefinedMetricSpecification() {
            return this.predefinedMetricSpecification;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
        }

        public final CustomizedMetricSpecification getCustomizedMetricSpecification() {
            return this.customizedMetricSpecification;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
        }

        public final Integer getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Integer getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public TargetTrackingScalingPolicyConfiguration build() {
            return new TargetTrackingScalingPolicyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
        public Builder targetValue(Double var1);

        public Builder predefinedMetricSpecification(PredefinedMetricSpecification var1);

        public Builder customizedMetricSpecification(CustomizedMetricSpecification var1);

        public Builder scaleOutCooldown(Integer var1);

        public Builder scaleInCooldown(Integer var1);
    }
}

