/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.model.Alarm;

@SdkInternalApi
public class AlarmMarshaller {
    private static final MarshallingInfo<String> ALARMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmName").build();
    private static final MarshallingInfo<String> ALARMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmARN").build();
    private static final AlarmMarshaller instance = new AlarmMarshaller();

    public static AlarmMarshaller getInstance() {
        return instance;
    }

    public void marshall(Alarm alarm, ProtocolMarshaller protocolMarshaller) {
        if (alarm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarm.alarmName(), ALARMNAME_BINDING);
            protocolMarshaller.marshall((Object)alarm.alarmARN(), ALARMARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

