/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification;

@SdkInternalApi
public class CustomizedMetricSpecificationMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").build();
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final MarshallingInfo<String> STATISTIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistic").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final CustomizedMetricSpecificationMarshaller instance = new CustomizedMetricSpecificationMarshaller();

    public static CustomizedMetricSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomizedMetricSpecification customizedMetricSpecification, ProtocolMarshaller protocolMarshaller) {
        if (customizedMetricSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customizedMetricSpecification.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)customizedMetricSpecification.namespace(), NAMESPACE_BINDING);
            protocolMarshaller.marshall(customizedMetricSpecification.dimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall((Object)customizedMetricSpecification.statistic(), STATISTIC_BINDING);
            protocolMarshaller.marshall((Object)customizedMetricSpecification.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

