/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;

@SdkInternalApi
public class ScalableTargetMarshaller {
    private static final MarshallingInfo<String> SERVICENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceNamespace").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> SCALABLEDIMENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalableDimension").build();
    private static final MarshallingInfo<Integer> MINCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinCapacity").build();
    private static final MarshallingInfo<Integer> MAXCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxCapacity").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final ScalableTargetMarshaller instance = new ScalableTargetMarshaller();

    public static ScalableTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalableTarget scalableTarget, ProtocolMarshaller protocolMarshaller) {
        if (scalableTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalableTarget.serviceNamespace(), SERVICENAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.scalableDimension(), SCALABLEDIMENSION_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.minCapacity(), MINCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.maxCapacity(), MAXCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

