/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;

public class ScalableTargetUnmarshaller
implements Unmarshaller<ScalableTarget, JsonUnmarshallerContext> {
    private static ScalableTargetUnmarshaller INSTANCE;

    public ScalableTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        ScalableTarget.Builder scalableTargetBuilder = ScalableTarget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ServiceNamespace", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.serviceNamespace((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceId", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScalableDimension", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.scalableDimension((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MinCapacity", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.minCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxCapacity", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.maxCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.roleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    scalableTargetBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ScalableTarget)scalableTargetBuilder.build();
    }

    public static ScalableTargetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScalableTargetUnmarshaller();
        }
        return INSTANCE;
    }
}

