/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;

@SdkInternalApi
public class ScalingActivityMarshaller {
    private static final MarshallingInfo<String> ACTIVITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivityId").build();
    private static final MarshallingInfo<String> SERVICENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceNamespace").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> SCALABLEDIMENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalableDimension").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CAUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cause").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<String> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").build();
    private static final ScalingActivityMarshaller instance = new ScalingActivityMarshaller();

    public static ScalingActivityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalingActivity scalingActivity, ProtocolMarshaller protocolMarshaller) {
        if (scalingActivity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalingActivity.activityId(), ACTIVITYID_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.serviceNamespace(), SERVICENAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.scalableDimension(), SCALABLEDIMENSION_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.cause(), CAUSE_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)scalingActivity.details(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

