/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicableIndividualAssessmentsResponse extends DatabaseMigrationResponse
        implements
        ToCopyableBuilder<DescribeApplicableIndividualAssessmentsResponse.Builder, DescribeApplicableIndividualAssessmentsResponse> {
    private static final SdkField<List<String>> INDIVIDUAL_ASSESSMENT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IndividualAssessmentNames")
            .getter(getter(DescribeApplicableIndividualAssessmentsResponse::individualAssessmentNames))
            .setter(setter(Builder::individualAssessmentNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndividualAssessmentNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeApplicableIndividualAssessmentsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INDIVIDUAL_ASSESSMENT_NAMES_FIELD, MARKER_FIELD));

    private final List<String> individualAssessmentNames;

    private final String marker;

    private DescribeApplicableIndividualAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.individualAssessmentNames = builder.individualAssessmentNames;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndividualAssessmentNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIndividualAssessmentNames() {
        return individualAssessmentNames != null && !(individualAssessmentNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of names for the individual assessments supported by the premigration assessment run that you start based on
     * the specified request parameters. For more information on the available individual assessments, including
     * compatibility with different migration task configurations, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
     * premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndividualAssessmentNames} method.
     * </p>
     * 
     * @return List of names for the individual assessments supported by the premigration assessment run that you start
     *         based on the specified request parameters. For more information on the available individual assessments,
     *         including compatibility with different migration task configurations, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
     *         premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
     */
    public final List<String> individualAssessmentNames() {
        return individualAssessmentNames;
    }

    /**
     * <p>
     * Pagination token returned for you to pass to a subsequent request. If you pass this token as the
     * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to
     * the value specified in the request by <code>MaxRecords</code>.
     * </p>
     * 
     * @return Pagination token returned for you to pass to a subsequent request. If you pass this token as the
     *         <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker,
     *         up to the value specified in the request by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndividualAssessmentNames() ? individualAssessmentNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicableIndividualAssessmentsResponse)) {
            return false;
        }
        DescribeApplicableIndividualAssessmentsResponse other = (DescribeApplicableIndividualAssessmentsResponse) obj;
        return hasIndividualAssessmentNames() == other.hasIndividualAssessmentNames()
                && Objects.equals(individualAssessmentNames(), other.individualAssessmentNames())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicableIndividualAssessmentsResponse")
                .add("IndividualAssessmentNames", hasIndividualAssessmentNames() ? individualAssessmentNames() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndividualAssessmentNames":
            return Optional.ofNullable(clazz.cast(individualAssessmentNames()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicableIndividualAssessmentsResponse, T> g) {
        return obj -> g.apply((DescribeApplicableIndividualAssessmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsResponse> {
        /**
         * <p>
         * List of names for the individual assessments supported by the premigration assessment run that you start
         * based on the specified request parameters. For more information on the available individual assessments,
         * including compatibility with different migration task configurations, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
         * premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param individualAssessmentNames
         *        List of names for the individual assessments supported by the premigration assessment run that you
         *        start based on the specified request parameters. For more information on the available individual
         *        assessments, including compatibility with different migration task configurations, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
         *        premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualAssessmentNames(Collection<String> individualAssessmentNames);

        /**
         * <p>
         * List of names for the individual assessments supported by the premigration assessment run that you start
         * based on the specified request parameters. For more information on the available individual assessments,
         * including compatibility with different migration task configurations, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
         * premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param individualAssessmentNames
         *        List of names for the individual assessments supported by the premigration assessment run that you
         *        start based on the specified request parameters. For more information on the available individual
         *        assessments, including compatibility with different migration task configurations, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with
         *        premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualAssessmentNames(String... individualAssessmentNames);

        /**
         * <p>
         * Pagination token returned for you to pass to a subsequent request. If you pass this token as the
         * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up
         * to the value specified in the request by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        Pagination token returned for you to pass to a subsequent request. If you pass this token as the
         *        <code>Marker</code> value in a subsequent request, the response includes only records beyond the
         *        marker, up to the value specified in the request by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<String> individualAssessmentNames = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicableIndividualAssessmentsResponse model) {
            super(model);
            individualAssessmentNames(model.individualAssessmentNames);
            marker(model.marker);
        }

        public final Collection<String> getIndividualAssessmentNames() {
            if (individualAssessmentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return individualAssessmentNames;
        }

        public final void setIndividualAssessmentNames(Collection<String> individualAssessmentNames) {
            this.individualAssessmentNames = IndividualAssessmentNameListCopier.copy(individualAssessmentNames);
        }

        @Override
        @Transient
        public final Builder individualAssessmentNames(Collection<String> individualAssessmentNames) {
            this.individualAssessmentNames = IndividualAssessmentNameListCopier.copy(individualAssessmentNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder individualAssessmentNames(String... individualAssessmentNames) {
            individualAssessmentNames(Arrays.asList(individualAssessmentNames));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeApplicableIndividualAssessmentsResponse build() {
            return new DescribeApplicableIndividualAssessmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
