/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationTasksResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationTasksResponse.Builder, DescribeReplicationTasksResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationTasksResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationTask>> REPLICATION_TASKS_FIELD = SdkField
            .<List<ReplicationTask>> builder(MarshallingType.LIST)
            .memberName("ReplicationTasks")
            .getter(getter(DescribeReplicationTasksResponse::replicationTasks))
            .setter(setter(Builder::replicationTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_TASKS_FIELD));

    private final String marker;

    private final List<ReplicationTask> replicationTasks;

    private DescribeReplicationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTasks = builder.replicationTasks;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationTasks() {
        return replicationTasks != null && !(replicationTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of the replication tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTasks} method.
     * </p>
     * 
     * @return A description of the replication tasks.
     */
    public final List<ReplicationTask> replicationTasks() {
        return replicationTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationTasks() ? replicationTasks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTasksResponse)) {
            return false;
        }
        DescribeReplicationTasksResponse other = (DescribeReplicationTasksResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasReplicationTasks() == other.hasReplicationTasks()
                && Objects.equals(replicationTasks(), other.replicationTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationTasksResponse").add("Marker", marker())
                .add("ReplicationTasks", hasReplicationTasks() ? replicationTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationTasks":
            return Optional.ofNullable(clazz.cast(replicationTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTasksResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationTasksResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A description of the replication tasks.
         * </p>
         * 
         * @param replicationTasks
         *        A description of the replication tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTasks(Collection<ReplicationTask> replicationTasks);

        /**
         * <p>
         * A description of the replication tasks.
         * </p>
         * 
         * @param replicationTasks
         *        A description of the replication tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTasks(ReplicationTask... replicationTasks);

        /**
         * <p>
         * A description of the replication tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationTask>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicationTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationTask>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationTasks(List<ReplicationTask>)}.
         * 
         * @param replicationTasks
         *        a consumer that will call methods on {@link List<ReplicationTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTasks(List<ReplicationTask>)
         */
        Builder replicationTasks(Consumer<ReplicationTask.Builder>... replicationTasks);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationTask> replicationTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTasksResponse model) {
            super(model);
            marker(model.marker);
            replicationTasks(model.replicationTasks);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationTask.Builder> getReplicationTasks() {
            List<ReplicationTask.Builder> result = ReplicationTaskListCopier.copyToBuilder(this.replicationTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationTasks(Collection<ReplicationTask.BuilderImpl> replicationTasks) {
            this.replicationTasks = ReplicationTaskListCopier.copyFromBuilder(replicationTasks);
        }

        @Override
        @Transient
        public final Builder replicationTasks(Collection<ReplicationTask> replicationTasks) {
            this.replicationTasks = ReplicationTaskListCopier.copy(replicationTasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationTasks(ReplicationTask... replicationTasks) {
            replicationTasks(Arrays.asList(replicationTasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationTasks(Consumer<ReplicationTask.Builder>... replicationTasks) {
            replicationTasks(Stream.of(replicationTasks).map(c -> ReplicationTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationTasksResponse build() {
            return new DescribeReplicationTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
