/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebootReplicationInstanceRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<RebootReplicationInstanceRequest.Builder, RebootReplicationInstanceRequest> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn").getter(getter(RebootReplicationInstanceRequest::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<Boolean> FORCE_FAILOVER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceFailover").getter(getter(RebootReplicationInstanceRequest::forceFailover))
            .setter(setter(Builder::forceFailover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceFailover").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_ARN_FIELD, FORCE_FAILOVER_FIELD));

    private final String replicationInstanceArn;

    private final Boolean forceFailover;

    private RebootReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.forceFailover = builder.forceFailover;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. (If the instance
     * isn't configured for Multi-AZ, then you can't specify <code>true</code>.)
     * </p>
     * 
     * @return If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. (If the
     *         instance isn't configured for Multi-AZ, then you can't specify <code>true</code>.)
     */
    public final Boolean forceFailover() {
        return forceFailover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(forceFailover());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootReplicationInstanceRequest)) {
            return false;
        }
        RebootReplicationInstanceRequest other = (RebootReplicationInstanceRequest) obj;
        return Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(forceFailover(), other.forceFailover());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RebootReplicationInstanceRequest").add("ReplicationInstanceArn", replicationInstanceArn())
                .add("ForceFailover", forceFailover()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "ForceFailover":
            return Optional.ofNullable(clazz.cast(forceFailover()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootReplicationInstanceRequest, T> g) {
        return obj -> g.apply((RebootReplicationInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RebootReplicationInstanceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. (If the instance
         * isn't configured for Multi-AZ, then you can't specify <code>true</code>.)
         * </p>
         * 
         * @param forceFailover
         *        If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. (If the
         *        instance isn't configured for Multi-AZ, then you can't specify <code>true</code>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceFailover(Boolean forceFailover);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationInstanceArn;

        private Boolean forceFailover;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootReplicationInstanceRequest model) {
            super(model);
            replicationInstanceArn(model.replicationInstanceArn);
            forceFailover(model.forceFailover);
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        @Transient
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final Boolean getForceFailover() {
            return forceFailover;
        }

        public final void setForceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
        }

        @Override
        @Transient
        public final Builder forceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootReplicationInstanceRequest build() {
            return new RebootReplicationInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
