/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a Redis target endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedisSettings implements SdkPojo, Serializable, ToCopyableBuilder<RedisSettings.Builder, RedisSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(RedisSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RedisSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SSL_SECURITY_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslSecurityProtocol").getter(getter(RedisSettings::sslSecurityProtocolAsString))
            .setter(setter(Builder::sslSecurityProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslSecurityProtocol").build())
            .build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(RedisSettings::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<String> AUTH_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthUserName").getter(getter(RedisSettings::authUserName)).setter(setter(Builder::authUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthUserName").build()).build();

    private static final SdkField<String> AUTH_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthPassword").getter(getter(RedisSettings::authPassword)).setter(setter(Builder::authPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthPassword").build()).build();

    private static final SdkField<String> SSL_CA_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslCaCertificateArn").getter(getter(RedisSettings::sslCaCertificateArn))
            .setter(setter(Builder::sslCaCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCaCertificateArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVER_NAME_FIELD, PORT_FIELD, SSL_SECURITY_PROTOCOL_FIELD, AUTH_TYPE_FIELD, AUTH_USER_NAME_FIELD,
                    AUTH_PASSWORD_FIELD, SSL_CA_CERTIFICATE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverName;

    private final Integer port;

    private final String sslSecurityProtocol;

    private final String authType;

    private final String authUserName;

    private final String authPassword;

    private final String sslCaCertificateArn;

    private RedisSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.sslSecurityProtocol = builder.sslSecurityProtocol;
        this.authType = builder.authType;
        this.authUserName = builder.authUserName;
        this.authPassword = builder.authPassword;
        this.sslCaCertificateArn = builder.sslCaCertificateArn;
    }

    /**
     * <p>
     * Fully qualified domain name of the endpoint.
     * </p>
     * 
     * @return Fully qualified domain name of the endpoint.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Transmission Control Protocol (TCP) port for the endpoint.
     * </p>
     * 
     * @return Transmission Control Protocol (TCP) port for the endpoint.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
     * <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
     * <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource
     * Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>setting. If an ARN
     * isn't given for a CA, DMS uses the Amazon root CA.
     * </p>
     * <p>
     * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between
     * endpoint and database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sslSecurityProtocol} will return {@link SslSecurityProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sslSecurityProtocolAsString}.
     * </p>
     * 
     * @return The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
     *         <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
     *         <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon
     *         Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>
     *         setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.</p>
     *         <p>
     *         The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic
     *         between endpoint and database.
     * @see SslSecurityProtocolValue
     */
    public final SslSecurityProtocolValue sslSecurityProtocol() {
        return SslSecurityProtocolValue.fromValue(sslSecurityProtocol);
    }

    /**
     * <p>
     * The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
     * <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
     * <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource
     * Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>setting. If an ARN
     * isn't given for a CA, DMS uses the Amazon root CA.
     * </p>
     * <p>
     * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between
     * endpoint and database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sslSecurityProtocol} will return {@link SslSecurityProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sslSecurityProtocolAsString}.
     * </p>
     * 
     * @return The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
     *         <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
     *         <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon
     *         Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>
     *         setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.</p>
     *         <p>
     *         The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic
     *         between endpoint and database.
     * @see SslSecurityProtocolValue
     */
    public final String sslSecurityProtocolAsString() {
        return sslSecurityProtocol;
    }

    /**
     * <p>
     * The type of authentication to perform when connecting to a Redis target. Options include <code>none</code>,
     * <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code> option requires an
     * <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires
     * <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link RedisAuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication to perform when connecting to a Redis target. Options include
     *         <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code>
     *         option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option
     *         requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
     * @see RedisAuthTypeValue
     */
    public final RedisAuthTypeValue authType() {
        return RedisAuthTypeValue.fromValue(authType);
    }

    /**
     * <p>
     * The type of authentication to perform when connecting to a Redis target. Options include <code>none</code>,
     * <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code> option requires an
     * <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires
     * <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link RedisAuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication to perform when connecting to a Redis target. Options include
     *         <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code>
     *         option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option
     *         requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
     * @see RedisAuthTypeValue
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a Redis
     * target endpoint.
     * </p>
     * 
     * @return The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a
     *         Redis target endpoint.
     */
    public final String authUserName() {
        return authUserName;
    }

    /**
     * <p>
     * The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the
     * <code>AuthType</code> setting for a Redis target endpoint.
     * </p>
     * 
     * @return The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the
     *         <code>AuthType</code> setting for a Redis target endpoint.
     */
    public final String authPassword() {
        return authPassword;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target
     * endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis
     *         target endpoint.
     */
    public final String sslCaCertificateArn() {
        return sslCaCertificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(sslSecurityProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authUserName());
        hashCode = 31 * hashCode + Objects.hashCode(authPassword());
        hashCode = 31 * hashCode + Objects.hashCode(sslCaCertificateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedisSettings)) {
            return false;
        }
        RedisSettings other = (RedisSettings) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(sslSecurityProtocolAsString(), other.sslSecurityProtocolAsString())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(authUserName(), other.authUserName()) && Objects.equals(authPassword(), other.authPassword())
                && Objects.equals(sslCaCertificateArn(), other.sslCaCertificateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedisSettings").add("ServerName", serverName()).add("Port", port())
                .add("SslSecurityProtocol", sslSecurityProtocolAsString()).add("AuthType", authTypeAsString())
                .add("AuthUserName", authUserName())
                .add("AuthPassword", authPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SslCaCertificateArn", sslCaCertificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "SslSecurityProtocol":
            return Optional.ofNullable(clazz.cast(sslSecurityProtocolAsString()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "AuthUserName":
            return Optional.ofNullable(clazz.cast(authUserName()));
        case "AuthPassword":
            return Optional.ofNullable(clazz.cast(authPassword()));
        case "SslCaCertificateArn":
            return Optional.ofNullable(clazz.cast(sslCaCertificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedisSettings, T> g) {
        return obj -> g.apply((RedisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedisSettings> {
        /**
         * <p>
         * Fully qualified domain name of the endpoint.
         * </p>
         * 
         * @param serverName
         *        Fully qualified domain name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Transmission Control Protocol (TCP) port for the endpoint.
         * </p>
         * 
         * @param port
         *        Transmission Control Protocol (TCP) port for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
         * <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
         * <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon
         * Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>setting.
         * If an ARN isn't given for a CA, DMS uses the Amazon root CA.
         * </p>
         * <p>
         * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic
         * between endpoint and database.
         * </p>
         * 
         * @param sslSecurityProtocol
         *        The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
         *        <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>.
         *        The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an
         *        Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the
         *        <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS uses the Amazon root
         *        CA.</p>
         *        <p>
         *        The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for
         *        traffic between endpoint and database.
         * @see SslSecurityProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SslSecurityProtocolValue
         */
        Builder sslSecurityProtocol(String sslSecurityProtocol);

        /**
         * <p>
         * The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
         * <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The
         * <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon
         * Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>setting.
         * If an ARN isn't given for a CA, DMS uses the Amazon root CA.
         * </p>
         * <p>
         * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic
         * between endpoint and database.
         * </p>
         * 
         * @param sslSecurityProtocol
         *        The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include
         *        <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>.
         *        The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an
         *        Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the
         *        <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS uses the Amazon root
         *        CA.</p>
         *        <p>
         *        The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for
         *        traffic between endpoint and database.
         * @see SslSecurityProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SslSecurityProtocolValue
         */
        Builder sslSecurityProtocol(SslSecurityProtocolValue sslSecurityProtocol);

        /**
         * <p>
         * The type of authentication to perform when connecting to a Redis target. Options include <code>none</code>,
         * <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code> option requires an
         * <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires
         * <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         * </p>
         * 
         * @param authType
         *        The type of authentication to perform when connecting to a Redis target. Options include
         *        <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code>
         *        option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option
         *        requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         * @see RedisAuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedisAuthTypeValue
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authentication to perform when connecting to a Redis target. Options include <code>none</code>,
         * <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code> option requires an
         * <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires
         * <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         * </p>
         * 
         * @param authType
         *        The type of authentication to perform when connecting to a Redis target. Options include
         *        <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code>
         *        option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option
         *        requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         * @see RedisAuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedisAuthTypeValue
         */
        Builder authType(RedisAuthTypeValue authType);

        /**
         * <p>
         * The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a
         * Redis target endpoint.
         * </p>
         * 
         * @param authUserName
         *        The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for
         *        a Redis target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authUserName(String authUserName);

        /**
         * <p>
         * The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the
         * <code>AuthType</code> setting for a Redis target endpoint.
         * </p>
         * 
         * @param authPassword
         *        The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the
         *        <code>AuthType</code> setting for a Redis target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authPassword(String authPassword);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis
         * target endpoint.
         * </p>
         * 
         * @param sslCaCertificateArn
         *        The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your
         *        Redis target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCaCertificateArn(String sslCaCertificateArn);
    }

    static final class BuilderImpl implements Builder {
        private String serverName;

        private Integer port;

        private String sslSecurityProtocol;

        private String authType;

        private String authUserName;

        private String authPassword;

        private String sslCaCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedisSettings model) {
            serverName(model.serverName);
            port(model.port);
            sslSecurityProtocol(model.sslSecurityProtocol);
            authType(model.authType);
            authUserName(model.authUserName);
            authPassword(model.authPassword);
            sslCaCertificateArn(model.sslCaCertificateArn);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        @Transient
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslSecurityProtocol() {
            return sslSecurityProtocol;
        }

        public final void setSslSecurityProtocol(String sslSecurityProtocol) {
            this.sslSecurityProtocol = sslSecurityProtocol;
        }

        @Override
        @Transient
        public final Builder sslSecurityProtocol(String sslSecurityProtocol) {
            this.sslSecurityProtocol = sslSecurityProtocol;
            return this;
        }

        @Override
        @Transient
        public final Builder sslSecurityProtocol(SslSecurityProtocolValue sslSecurityProtocol) {
            this.sslSecurityProtocol(sslSecurityProtocol == null ? null : sslSecurityProtocol.toString());
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        @Transient
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        @Transient
        public final Builder authType(RedisAuthTypeValue authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getAuthUserName() {
            return authUserName;
        }

        public final void setAuthUserName(String authUserName) {
            this.authUserName = authUserName;
        }

        @Override
        @Transient
        public final Builder authUserName(String authUserName) {
            this.authUserName = authUserName;
            return this;
        }

        public final String getAuthPassword() {
            return authPassword;
        }

        public final void setAuthPassword(String authPassword) {
            this.authPassword = authPassword;
        }

        @Override
        @Transient
        public final Builder authPassword(String authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        public final String getSslCaCertificateArn() {
            return sslCaCertificateArn;
        }

        public final void setSslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
        }

        @Override
        @Transient
        public final Builder sslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
            return this;
        }

        @Override
        public RedisSettings build() {
            return new RedisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
