/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata for a replication instance task log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationInstanceTaskLog implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationInstanceTaskLog.Builder, ReplicationInstanceTaskLog> {
    private static final SdkField<String> REPLICATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskName").getter(getter(ReplicationInstanceTaskLog::replicationTaskName))
            .setter(setter(Builder::replicationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskName").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(ReplicationInstanceTaskLog::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<Long> REPLICATION_INSTANCE_TASK_LOG_SIZE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ReplicationInstanceTaskLogSize")
            .getter(getter(ReplicationInstanceTaskLog::replicationInstanceTaskLogSize))
            .setter(setter(Builder::replicationInstanceTaskLogSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceTaskLogSize")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_NAME_FIELD,
            REPLICATION_TASK_ARN_FIELD, REPLICATION_INSTANCE_TASK_LOG_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationTaskName;

    private final String replicationTaskArn;

    private final Long replicationInstanceTaskLogSize;

    private ReplicationInstanceTaskLog(BuilderImpl builder) {
        this.replicationTaskName = builder.replicationTaskName;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationInstanceTaskLogSize = builder.replicationInstanceTaskLogSize;
    }

    /**
     * <p>
     * The name of the replication task.
     * </p>
     * 
     * @return The name of the replication task.
     */
    public final String replicationTaskName() {
        return replicationTaskName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * The size, in bytes, of the replication task log.
     * </p>
     * 
     * @return The size, in bytes, of the replication task log.
     */
    public final Long replicationInstanceTaskLogSize() {
        return replicationInstanceTaskLogSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceTaskLogSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInstanceTaskLog)) {
            return false;
        }
        ReplicationInstanceTaskLog other = (ReplicationInstanceTaskLog) obj;
        return Objects.equals(replicationTaskName(), other.replicationTaskName())
                && Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(replicationInstanceTaskLogSize(), other.replicationInstanceTaskLogSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationInstanceTaskLog").add("ReplicationTaskName", replicationTaskName())
                .add("ReplicationTaskArn", replicationTaskArn())
                .add("ReplicationInstanceTaskLogSize", replicationInstanceTaskLogSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskName":
            return Optional.ofNullable(clazz.cast(replicationTaskName()));
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ReplicationInstanceTaskLogSize":
            return Optional.ofNullable(clazz.cast(replicationInstanceTaskLogSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInstanceTaskLog, T> g) {
        return obj -> g.apply((ReplicationInstanceTaskLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationInstanceTaskLog> {
        /**
         * <p>
         * The name of the replication task.
         * </p>
         * 
         * @param replicationTaskName
         *        The name of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskName(String replicationTaskName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The size, in bytes, of the replication task log.
         * </p>
         * 
         * @param replicationInstanceTaskLogSize
         *        The size, in bytes, of the replication task log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceTaskLogSize(Long replicationInstanceTaskLogSize);
    }

    static final class BuilderImpl implements Builder {
        private String replicationTaskName;

        private String replicationTaskArn;

        private Long replicationInstanceTaskLogSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInstanceTaskLog model) {
            replicationTaskName(model.replicationTaskName);
            replicationTaskArn(model.replicationTaskArn);
            replicationInstanceTaskLogSize(model.replicationInstanceTaskLogSize);
        }

        public final String getReplicationTaskName() {
            return replicationTaskName;
        }

        public final void setReplicationTaskName(String replicationTaskName) {
            this.replicationTaskName = replicationTaskName;
        }

        @Override
        @Transient
        public final Builder replicationTaskName(String replicationTaskName) {
            this.replicationTaskName = replicationTaskName;
            return this;
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final Long getReplicationInstanceTaskLogSize() {
            return replicationInstanceTaskLogSize;
        }

        public final void setReplicationInstanceTaskLogSize(Long replicationInstanceTaskLogSize) {
            this.replicationInstanceTaskLogSize = replicationInstanceTaskLogSize;
        }

        @Override
        @Transient
        public final Builder replicationInstanceTaskLogSize(Long replicationInstanceTaskLogSize) {
            this.replicationInstanceTaskLogSize = replicationInstanceTaskLogSize;
            return this;
        }

        @Override
        public ReplicationInstanceTaskLog build() {
            return new ReplicationInstanceTaskLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
