/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for exporting data to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Settings implements SdkPojo, Serializable, ToCopyableBuilder<S3Settings.Builder, S3Settings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(S3Settings::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalTableDefinition").getter(getter(S3Settings::externalTableDefinition))
            .setter(setter(Builder::externalTableDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build())
            .build();

    private static final SdkField<String> CSV_ROW_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CsvRowDelimiter").getter(getter(S3Settings::csvRowDelimiter)).setter(setter(Builder::csvRowDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvRowDelimiter").build()).build();

    private static final SdkField<String> CSV_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CsvDelimiter").getter(getter(S3Settings::csvDelimiter)).setter(setter(Builder::csvDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvDelimiter").build()).build();

    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketFolder").getter(getter(S3Settings::bucketFolder)).setter(setter(Builder::bucketFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Settings::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompressionType").getter(getter(S3Settings::compressionTypeAsString))
            .setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(S3Settings::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerSideEncryptionKmsKeyId")
            .getter(getter(S3Settings::serverSideEncryptionKmsKeyId))
            .setter(setter(Builder::serverSideEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId")
                    .build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(S3Settings::dataFormatAsString)).setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodingType").getter(getter(S3Settings::encodingTypeAsString)).setter(setter(Builder::encodingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()).build();

    private static final SdkField<Integer> DICT_PAGE_SIZE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DictPageSizeLimit").getter(getter(S3Settings::dictPageSizeLimit))
            .setter(setter(Builder::dictPageSizeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DictPageSizeLimit").build()).build();

    private static final SdkField<Integer> ROW_GROUP_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RowGroupLength").getter(getter(S3Settings::rowGroupLength)).setter(setter(Builder::rowGroupLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowGroupLength").build()).build();

    private static final SdkField<Integer> DATA_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataPageSize").getter(getter(S3Settings::dataPageSize)).setter(setter(Builder::dataPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPageSize").build()).build();

    private static final SdkField<String> PARQUET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParquetVersion").getter(getter(S3Settings::parquetVersionAsString))
            .setter(setter(Builder::parquetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetVersion").build()).build();

    private static final SdkField<Boolean> ENABLE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableStatistics").getter(getter(S3Settings::enableStatistics))
            .setter(setter(Builder::enableStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStatistics").build()).build();

    private static final SdkField<Boolean> INCLUDE_OP_FOR_FULL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeOpForFullLoad").getter(getter(S3Settings::includeOpForFullLoad))
            .setter(setter(Builder::includeOpForFullLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOpForFullLoad").build())
            .build();

    private static final SdkField<Boolean> CDC_INSERTS_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CdcInsertsOnly").getter(getter(S3Settings::cdcInsertsOnly)).setter(setter(Builder::cdcInsertsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsOnly").build()).build();

    private static final SdkField<String> TIMESTAMP_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampColumnName").getter(getter(S3Settings::timestampColumnName))
            .setter(setter(Builder::timestampColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumnName").build())
            .build();

    private static final SdkField<Boolean> PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ParquetTimestampInMillisecond")
            .getter(getter(S3Settings::parquetTimestampInMillisecond))
            .setter(setter(Builder::parquetTimestampInMillisecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetTimestampInMillisecond")
                    .build()).build();

    private static final SdkField<Boolean> CDC_INSERTS_AND_UPDATES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CdcInsertsAndUpdates").getter(getter(S3Settings::cdcInsertsAndUpdates))
            .setter(setter(Builder::cdcInsertsAndUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsAndUpdates").build())
            .build();

    private static final SdkField<Boolean> DATE_PARTITION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DatePartitionEnabled").getter(getter(S3Settings::datePartitionEnabled))
            .setter(setter(Builder::datePartitionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionEnabled").build())
            .build();

    private static final SdkField<String> DATE_PARTITION_SEQUENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatePartitionSequence").getter(getter(S3Settings::datePartitionSequenceAsString))
            .setter(setter(Builder::datePartitionSequence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionSequence").build())
            .build();

    private static final SdkField<String> DATE_PARTITION_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatePartitionDelimiter").getter(getter(S3Settings::datePartitionDelimiterAsString))
            .setter(setter(Builder::datePartitionDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatePartitionDelimiter").build())
            .build();

    private static final SdkField<Boolean> USE_CSV_NO_SUP_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseCsvNoSupValue").getter(getter(S3Settings::useCsvNoSupValue))
            .setter(setter(Builder::useCsvNoSupValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCsvNoSupValue").build()).build();

    private static final SdkField<String> CSV_NO_SUP_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CsvNoSupValue").getter(getter(S3Settings::csvNoSupValue)).setter(setter(Builder::csvNoSupValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvNoSupValue").build()).build();

    private static final SdkField<Boolean> PRESERVE_TRANSACTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreserveTransactions").getter(getter(S3Settings::preserveTransactions))
            .setter(setter(Builder::preserveTransactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveTransactions").build())
            .build();

    private static final SdkField<String> CDC_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcPath").getter(getter(S3Settings::cdcPath)).setter(setter(Builder::cdcPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcPath").build()).build();

    private static final SdkField<String> CANNED_ACL_FOR_OBJECTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CannedAclForObjects").getter(getter(S3Settings::cannedAclForObjectsAsString))
            .setter(setter(Builder::cannedAclForObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAclForObjects").build())
            .build();

    private static final SdkField<Boolean> ADD_COLUMN_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddColumnName").getter(getter(S3Settings::addColumnName)).setter(setter(Builder::addColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddColumnName").build()).build();

    private static final SdkField<Integer> CDC_MAX_BATCH_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CdcMaxBatchInterval").getter(getter(S3Settings::cdcMaxBatchInterval))
            .setter(setter(Builder::cdcMaxBatchInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcMaxBatchInterval").build())
            .build();

    private static final SdkField<Integer> CDC_MIN_FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CdcMinFileSize").getter(getter(S3Settings::cdcMinFileSize)).setter(setter(Builder::cdcMinFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcMinFileSize").build()).build();

    private static final SdkField<String> CSV_NULL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CsvNullValue").getter(getter(S3Settings::csvNullValue)).setter(setter(Builder::csvNullValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvNullValue").build()).build();

    private static final SdkField<Integer> IGNORE_HEADER_ROWS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IgnoreHeaderRows").getter(getter(S3Settings::ignoreHeaderRows))
            .setter(setter(Builder::ignoreHeaderRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreHeaderRows").build()).build();

    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxFileSize").getter(getter(S3Settings::maxFileSize)).setter(setter(Builder::maxFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()).build();

    private static final SdkField<Boolean> RFC4180_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Rfc4180").getter(getter(S3Settings::rfc4180)).setter(setter(Builder::rfc4180))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rfc4180").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD,
            EXTERNAL_TABLE_DEFINITION_FIELD, CSV_ROW_DELIMITER_FIELD, CSV_DELIMITER_FIELD, BUCKET_FOLDER_FIELD,
            BUCKET_NAME_FIELD, COMPRESSION_TYPE_FIELD, ENCRYPTION_MODE_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD,
            DATA_FORMAT_FIELD, ENCODING_TYPE_FIELD, DICT_PAGE_SIZE_LIMIT_FIELD, ROW_GROUP_LENGTH_FIELD, DATA_PAGE_SIZE_FIELD,
            PARQUET_VERSION_FIELD, ENABLE_STATISTICS_FIELD, INCLUDE_OP_FOR_FULL_LOAD_FIELD, CDC_INSERTS_ONLY_FIELD,
            TIMESTAMP_COLUMN_NAME_FIELD, PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD, CDC_INSERTS_AND_UPDATES_FIELD,
            DATE_PARTITION_ENABLED_FIELD, DATE_PARTITION_SEQUENCE_FIELD, DATE_PARTITION_DELIMITER_FIELD,
            USE_CSV_NO_SUP_VALUE_FIELD, CSV_NO_SUP_VALUE_FIELD, PRESERVE_TRANSACTIONS_FIELD, CDC_PATH_FIELD,
            CANNED_ACL_FOR_OBJECTS_FIELD, ADD_COLUMN_NAME_FIELD, CDC_MAX_BATCH_INTERVAL_FIELD, CDC_MIN_FILE_SIZE_FIELD,
            CSV_NULL_VALUE_FIELD, IGNORE_HEADER_ROWS_FIELD, MAX_FILE_SIZE_FIELD, RFC4180_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceAccessRoleArn;

    private final String externalTableDefinition;

    private final String csvRowDelimiter;

    private final String csvDelimiter;

    private final String bucketFolder;

    private final String bucketName;

    private final String compressionType;

    private final String encryptionMode;

    private final String serverSideEncryptionKmsKeyId;

    private final String dataFormat;

    private final String encodingType;

    private final Integer dictPageSizeLimit;

    private final Integer rowGroupLength;

    private final Integer dataPageSize;

    private final String parquetVersion;

    private final Boolean enableStatistics;

    private final Boolean includeOpForFullLoad;

    private final Boolean cdcInsertsOnly;

    private final String timestampColumnName;

    private final Boolean parquetTimestampInMillisecond;

    private final Boolean cdcInsertsAndUpdates;

    private final Boolean datePartitionEnabled;

    private final String datePartitionSequence;

    private final String datePartitionDelimiter;

    private final Boolean useCsvNoSupValue;

    private final String csvNoSupValue;

    private final Boolean preserveTransactions;

    private final String cdcPath;

    private final String cannedAclForObjects;

    private final Boolean addColumnName;

    private final Integer cdcMaxBatchInterval;

    private final Integer cdcMinFileSize;

    private final String csvNullValue;

    private final Integer ignoreHeaderRows;

    private final Integer maxFileSize;

    private final Boolean rfc4180;

    private S3Settings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.csvRowDelimiter = builder.csvRowDelimiter;
        this.csvDelimiter = builder.csvDelimiter;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.compressionType = builder.compressionType;
        this.encryptionMode = builder.encryptionMode;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.dataFormat = builder.dataFormat;
        this.encodingType = builder.encodingType;
        this.dictPageSizeLimit = builder.dictPageSizeLimit;
        this.rowGroupLength = builder.rowGroupLength;
        this.dataPageSize = builder.dataPageSize;
        this.parquetVersion = builder.parquetVersion;
        this.enableStatistics = builder.enableStatistics;
        this.includeOpForFullLoad = builder.includeOpForFullLoad;
        this.cdcInsertsOnly = builder.cdcInsertsOnly;
        this.timestampColumnName = builder.timestampColumnName;
        this.parquetTimestampInMillisecond = builder.parquetTimestampInMillisecond;
        this.cdcInsertsAndUpdates = builder.cdcInsertsAndUpdates;
        this.datePartitionEnabled = builder.datePartitionEnabled;
        this.datePartitionSequence = builder.datePartitionSequence;
        this.datePartitionDelimiter = builder.datePartitionDelimiter;
        this.useCsvNoSupValue = builder.useCsvNoSupValue;
        this.csvNoSupValue = builder.csvNoSupValue;
        this.preserveTransactions = builder.preserveTransactions;
        this.cdcPath = builder.cdcPath;
        this.cannedAclForObjects = builder.cannedAclForObjects;
        this.addColumnName = builder.addColumnName;
        this.cdcMaxBatchInterval = builder.cdcMaxBatchInterval;
        this.cdcMinFileSize = builder.cdcMinFileSize;
        this.csvNullValue = builder.csvNullValue;
        this.ignoreHeaderRows = builder.ignoreHeaderRows;
        this.maxFileSize = builder.maxFileSize;
        this.rfc4180 = builder.rfc4180;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     * <code>iam:PassRole</code> action. It is a required parameter that enables DMS to write and read objects from an
     * S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     *         <code>iam:PassRole</code> action. It is a required parameter that enables DMS to write and read objects
     *         from an S3 bucket.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Specifies how tables are defined in the S3 source files only.
     * </p>
     * 
     * @return Specifies how tables are defined in the S3 source files only.
     */
    public final String externalTableDefinition() {
        return externalTableDefinition;
    }

    /**
     * <p>
     * The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage return
     * (<code>\n</code>).
     * </p>
     * 
     * @return The delimiter used to separate rows in the .csv file for both source and target. The default is a
     *         carriage return (<code>\n</code>).
     */
    public final String csvRowDelimiter() {
        return csvRowDelimiter;
    }

    /**
     * <p>
     * The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
     * </p>
     * 
     * @return The delimiter used to separate columns in the .csv file for both source and target. The default is a
     *         comma.
     */
    public final String csvDelimiter() {
        return csvDelimiter;
    }

    /**
     * <p>
     * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
     * <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter isn't specified, then
     * the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
     * </p>
     * 
     * @return An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
     *         <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter isn't
     *         specified, then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
     */
    public final String bucketFolder() {
        return bucketFolder;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Either
     * set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This parameter applies
     * to both .csv and .parquet file formats.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
     *         Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This
     *         parameter applies to both .csv and .parquet file formats.
     * @see CompressionTypeValue
     */
    public final CompressionTypeValue compressionType() {
        return CompressionTypeValue.fromValue(compressionType);
    }

    /**
     * <p>
     * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Either
     * set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This parameter applies
     * to both .csv and .parquet file formats.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
     *         Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This
     *         parameter applies to both .csv and .parquet file formats.
     * @see CompressionTypeValue
     */
    public final String compressionTypeAsString() {
        return compressionType;
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>.
     * </p>
     * <note>
     * <p>
     * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the
     * existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     * </p>
     * </note>
     * <p>
     * To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to allow
     * <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:CreateBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucketPolicy</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
     *         <p>
     *         For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     *         <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
     *         change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     *         </p>
     *         </note>
     *         <p>
     *         To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to
     *         allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:CreateBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObjectVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucketPolicy</code>
     *         </p>
     *         </li>
     * @see EncryptionModeValue
     */
    public final EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>.
     * </p>
     * <note>
     * <p>
     * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the
     * existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     * </p>
     * </note>
     * <p>
     * To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to allow
     * <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:CreateBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucketPolicy</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
     *         <p>
     *         For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
     *         <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
     *         change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
     *         </p>
     *         </note>
     *         <p>
     *         To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to
     *         allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:CreateBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObjectVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucketPolicy</code>
     *         </p>
     *         </li>
     * @see EncryptionModeValue
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the KMS key ID. The key that
     * you use needs an attached policy that enables Identity and Access Management (IAM) user permissions and allows
     * use of the key.
     * </p>
     * <p>
     * Here is a CLI example:
     * <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
     * </p>
     * 
     * @return If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the KMS key ID. The
     *         key that you use needs an attached policy that enables Identity and Access Management (IAM) user
     *         permissions and allows use of the key.</p>
     *         <p>
     *         Here is a CLI example:
     *         <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
     */
    public final String serverSideEncryptionKmsKeyId() {
        return serverSideEncryptionKmsKeyId;
    }

    /**
     * <p>
     * The format of the data that you want to use for output. You can choose one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
     * compression and provides faster query response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that you want to use for output. You can choose one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
     *         efficient compression and provides faster query response.
     *         </p>
     *         </li>
     * @see DataFormatValue
     */
    public final DataFormatValue dataFormat() {
        return DataFormatValue.fromValue(dataFormat);
    }

    /**
     * <p>
     * The format of the data that you want to use for output. You can choose one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
     * compression and provides faster query response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that you want to use for output. You can choose one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
     *         efficient compression and provides faster query response.
     *         </p>
     *         </li>
     * @see DataFormatValue
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The type of encoding you are using:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values
     * more efficiently. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is
     * stored in a dictionary page for each column chunk.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The type of encoding you are using: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
     *         values more efficiently. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
     *         dictionary is stored in a dictionary page for each column chunk.
     *         </p>
     *         </li>
     * @see EncodingTypeValue
     */
    public final EncodingTypeValue encodingType() {
        return EncodingTypeValue.fromValue(encodingType);
    }

    /**
     * <p>
     * The type of encoding you are using:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values
     * more efficiently. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is
     * stored in a dictionary page for each column chunk.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The type of encoding you are using: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
     *         values more efficiently. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
     *         dictionary is stored in a dictionary page for each column chunk.
     *         </p>
     *         </li>
     * @see EncodingTypeValue
     */
    public final String encodingTypeAsString() {
        return encodingType;
    }

    /**
     * <p>
     * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column is
     * stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024 bytes (1 MiB), the
     * maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for
     * .parquet file format only.
     * </p>
     * 
     * @return The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this
     *         column is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024
     *         bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding.
     *         This size is used for .parquet file format only.
     */
    public final Integer dictPageSizeLimit() {
        return dictPageSizeLimit;
    }

    /**
     * <p>
     * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row
     * groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet
     * file format only.
     * </p>
     * <p>
     * If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length in
     * bytes (64 * 1024 * 1024).
     * </p>
     * 
     * @return The number of rows in a row group. A smaller row group size provides faster reads. But as the number of
     *         row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used
     *         for .parquet file format only. </p>
     *         <p>
     *         If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group
     *         length in bytes (64 * 1024 * 1024).
     */
    public final Integer rowGroupLength() {
        return rowGroupLength;
    }

    /**
     * <p>
     * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for
     * .parquet file format only.
     * </p>
     * 
     * @return The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is
     *         used for .parquet file format only.
     */
    public final Integer dataPageSize() {
        return dataPageSize;
    }

    /**
     * <p>
     * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     * <code>parquet_2_0</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetVersion}
     * will return {@link ParquetVersionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parquetVersionAsString}.
     * </p>
     * 
     * @return The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     *         <code>parquet_2_0</code>.
     * @see ParquetVersionValue
     */
    public final ParquetVersionValue parquetVersion() {
        return ParquetVersionValue.fromValue(parquetVersion);
    }

    /**
     * <p>
     * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     * <code>parquet_2_0</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetVersion}
     * will return {@link ParquetVersionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parquetVersionAsString}.
     * </p>
     * 
     * @return The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     *         <code>parquet_2_0</code>.
     * @see ParquetVersionValue
     */
    public final String parquetVersionAsString() {
        return parquetVersion;
    }

    /**
     * <p>
     * A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable statistics,
     * <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and
     * <code>MIN</code> values. This parameter defaults to <code>true</code>. This value is used for .parquet file
     * format only.
     * </p>
     * 
     * @return A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
     *         statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>,
     *         <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This value
     *         is used for .parquet file format only.
     */
    public final Boolean enableStatistics() {
        return enableStatistics;
    }

    /**
     * <p>
     * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only
     * to indicate how the rows were added to the source database.
     * </p>
     * <note>
     * <p>
     * DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * For full load, records can only be inserted. By default (the <code>false</code> setting), no information is
     * recorded in these output files for a full load to indicate that the rows were inserted at the source database. If
     * <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT is recorded as an I
     * annotation in the first field of the .csv file. This allows the format of your target records from a full load to
     * be consistent with the target records from a CDC load.
     * </p>
     * <note>
     * <p>
     * This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code>
     * parameters for output to .csv files only. For more information about how these settings work together, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">
     * Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.
     * </p>
     * </note>
     * 
     * @return A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output
     *         files only to indicate how the rows were added to the source database.</p> <note>
     *         <p>
     *         DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         For full load, records can only be inserted. By default (the <code>false</code> setting), no information
     *         is recorded in these output files for a full load to indicate that the rows were inserted at the source
     *         database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT
     *         is recorded as an I annotation in the first field of the .csv file. This allows the format of your target
     *         records from a full load to be consistent with the target records from a CDC load.
     *         </p>
     *         <note>
     *         <p>
     *         This setting works together with the <code>CdcInsertsOnly</code> and the
     *         <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about
     *         how these settings work together, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     *         >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
     *         Guide.</i>.
     *         </p>
     */
    public final Boolean includeOpForFullLoad() {
        return includeOpForFullLoad;
    }

    /**
     * <p>
     * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage
     * (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet
     * record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
     * inserted, updated, or deleted at the source database for a CDC load to the target.
     * </p>
     * <p>
     * If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the source
     * database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends
     * on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
     * <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT operation at the
     * source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC record is written without a
     * first field to indicate the INSERT operation at the source. For more information about how these settings work
     * together, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.
     * </p>
     * <note>
     * <p>
     * DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and
     * <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
     * </p>
     * <p>
     * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the
     * same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
     * for the same endpoint, but not both.
     * </p>
     * </note>
     * 
     * @return A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar
     *         storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv
     *         or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate
     *         whether the row was inserted, updated, or deleted at the source database for a CDC load to the
     *         target.</p>
     *         <p>
     *         If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the
     *         source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are
     *         recorded depends on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code>
     *         is set to <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT
     *         operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC
     *         record is written without a first field to indicate the INSERT operation at the source. For more
     *         information about how these settings work together, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     *         >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
     *         Guide.</i>.
     *         </p>
     *         <note>
     *         <p>
     *         DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and
     *         <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
     *         </p>
     *         <p>
     *         <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code>
     *         for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to
     *         <code>true</code> for the same endpoint, but not both.
     *         </p>
     */
    public final Boolean cdcInsertsOnly() {
        return cdcInsertsOnly;
    }

    /**
     * <p>
     * A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for an
     * Amazon S3 target.
     * </p>
     * <note>
     * <p>
     * DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated data
     * when you set <code>TimestampColumnName</code> to a nonblank value.
     * </p>
     * <p>
     * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from
     * the source to the target by DMS.
     * </p>
     * <p>
     * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of
     * that row in the source database.
     * </p>
     * <p>
     * The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
     * precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit
     * timestamp supported by DMS for the source database.
     * </p>
     * <p>
     * When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for the
     * timestamp column that you set with <code>TimestampColumnName</code>.
     * </p>
     * 
     * @return A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for
     *         an Amazon S3 target.</p> <note>
     *         <p>
     *         DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your
     *         migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
     *         </p>
     *         <p>
     *         For a full load, each row of this timestamp column contains a timestamp for when the data was transferred
     *         from the source to the target by DMS.
     *         </p>
     *         <p>
     *         For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the
     *         commit of that row in the source database.
     *         </p>
     *         <p>
     *         The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default,
     *         the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on
     *         the commit timestamp supported by DMS for the source database.
     *         </p>
     *         <p>
     *         When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for
     *         the timestamp column that you set with <code>TimestampColumnName</code>.
     */
    public final String timestampColumnName() {
        return timestampColumnName;
    }

    /**
     * <p>
     * A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3
     * object file in .parquet format.
     * </p>
     * <note>
     * <p>
     * DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, DMS writes all
     * <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes
     * them with microsecond precision.
     * </p>
     * <p>
     * Currently, Amazon Athena and Glue can handle only millisecond precision for <code>TIMESTAMP</code> values. Set
     * this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan to
     * query or process the data with Athena or Glue.
     * </p>
     * <note>
     * <p>
     * DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond
     * precision.
     * </p>
     * <p>
     * Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column
     * value that is inserted by setting the <code>TimestampColumnName</code> parameter.
     * </p>
     * </note>
     * 
     * @return A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an
     *         Amazon S3 object file in .parquet format.</p> <note>
     *         <p>
     *         DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, DMS writes
     *         all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise,
     *         DMS writes them with microsecond precision.
     *         </p>
     *         <p>
     *         Currently, Amazon Athena and Glue can handle only millisecond precision for <code>TIMESTAMP</code>
     *         values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted
     *         only if you plan to query or process the data with Athena or Glue.
     *         </p>
     *         <note>
     *         <p>
     *         DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond
     *         precision.
     *         </p>
     *         <p>
     *         Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp
     *         column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
     *         </p>
     */
    public final Boolean parquetTimestampInMillisecond() {
        return parquetTimestampInMillisecond;
    }

    /**
     * <p>
     * A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet
     * (columnar storage) output files. The default setting is <code>false</code>, but when
     * <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from
     * the source database are migrated to the .csv or .parquet file.
     * </p>
     * <p>
     * For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the
     * <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code>,
     * the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and
     * UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code>, CDC
     * records are written without an indication of INSERT or UPDATE operations at the source. For more information
     * about how these settings work together, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.
     * </p>
     * <note>
     * <p>
     * DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
     * </p>
     * <p>
     * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the
     * same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
     * for the same endpoint, but not both.
     * </p>
     * </note>
     * 
     * @return A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or
     *         .parquet (columnar storage) output files. The default setting is <code>false</code>, but when
     *         <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code>, only INSERTs and UPDATEs
     *         from the source database are migrated to the .csv or .parquet file. </p>
     *         <p>
     *         For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the
     *         <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to
     *         <code>true</code>, the first field of every CDC record is set to either <code>I</code> or <code>U</code>
     *         to indicate INSERT and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set
     *         to <code>false</code>, CDC records are written without an indication of INSERT or UPDATE operations at
     *         the source. For more information about how these settings work together, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     *         >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
     *         Guide.</i>.
     *         </p>
     *         <note>
     *         <p>
     *         DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
     *         </p>
     *         <p>
     *         <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code>
     *         for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to
     *         <code>true</code> for the same endpoint, but not both.
     *         </p>
     */
    public final Boolean cdcInsertsAndUpdates() {
        return cdcInsertsAndUpdates;
    }

    /**
     * <p>
     * When set to <code>true</code>, this parameter partitions S3 bucket folders based on transaction commit dates. The
     * default value is <code>false</code>. For more information about date-based folder partitioning, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using
     * date-based folder partitioning</a>.
     * </p>
     * 
     * @return When set to <code>true</code>, this parameter partitions S3 bucket folders based on transaction commit
     *         dates. The default value is <code>false</code>. For more information about date-based folder
     *         partitioning, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning"
     *         >Using date-based folder partitioning</a>.
     */
    public final Boolean datePartitionEnabled() {
        return datePartitionEnabled;
    }

    /**
     * <p>
     * Identifies the sequence of the date format to use during folder partitioning. The default value is
     * <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datePartitionSequence} will return {@link DatePartitionSequenceValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #datePartitionSequenceAsString}.
     * </p>
     * 
     * @return Identifies the sequence of the date format to use during folder partitioning. The default value is
     *         <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
     *         <code>true</code>.
     * @see DatePartitionSequenceValue
     */
    public final DatePartitionSequenceValue datePartitionSequence() {
        return DatePartitionSequenceValue.fromValue(datePartitionSequence);
    }

    /**
     * <p>
     * Identifies the sequence of the date format to use during folder partitioning. The default value is
     * <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datePartitionSequence} will return {@link DatePartitionSequenceValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #datePartitionSequenceAsString}.
     * </p>
     * 
     * @return Identifies the sequence of the date format to use during folder partitioning. The default value is
     *         <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
     *         <code>true</code>.
     * @see DatePartitionSequenceValue
     */
    public final String datePartitionSequenceAsString() {
        return datePartitionSequence;
    }

    /**
     * <p>
     * Specifies a date separating delimiter to use during folder partitioning. The default value is <code>SLASH</code>.
     * Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datePartitionDelimiter} will return {@link DatePartitionDelimiterValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #datePartitionDelimiterAsString}.
     * </p>
     * 
     * @return Specifies a date separating delimiter to use during folder partitioning. The default value is
     *         <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
     *         <code>true</code>.
     * @see DatePartitionDelimiterValue
     */
    public final DatePartitionDelimiterValue datePartitionDelimiter() {
        return DatePartitionDelimiterValue.fromValue(datePartitionDelimiter);
    }

    /**
     * <p>
     * Specifies a date separating delimiter to use during folder partitioning. The default value is <code>SLASH</code>.
     * Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datePartitionDelimiter} will return {@link DatePartitionDelimiterValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #datePartitionDelimiterAsString}.
     * </p>
     * 
     * @return Specifies a date separating delimiter to use during folder partitioning. The default value is
     *         <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
     *         <code>true</code>.
     * @see DatePartitionDelimiterValue
     */
    public final String datePartitionDelimiterAsString() {
        return datePartitionDelimiter;
    }

    /**
     * <p>
     * This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format.
     * If set to <code>true</code> for columns not included in the supplemental log, DMS uses the value specified by <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
     * <code>CsvNoSupValue</code> </a>. If not set or set to <code>false</code>, DMS uses the null value for these
     * columns.
     * </p>
     * <note>
     * <p>
     * This setting is supported in DMS versions 3.4.1 and later.
     * </p>
     * </note>
     * 
     * @return This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv
     *         format. If set to <code>true</code> for columns not included in the supplemental log, DMS uses the value
     *         specified by <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"
     *         > <code>CsvNoSupValue</code> </a>. If not set or set to <code>false</code>, DMS uses the null value for
     *         these columns.</p> <note>
     *         <p>
     *         This setting is supported in DMS versions 3.4.1 and later.
     *         </p>
     */
    public final Boolean useCsvNoSupValue() {
        return useCsvNoSupValue;
    }

    /**
     * <p>
     * This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in
     * .csv format. If <a href=
     * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue">
     * <code>UseCsvNoSupValue</code> </a> is set to true, specify a string value that you want DMS to use for all
     * columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for
     * these columns regardless of the <code>UseCsvNoSupValue</code> setting.
     * </p>
     * <note>
     * <p>
     * This setting is supported in DMS versions 3.4.1 and later.
     * </p>
     * </note>
     * 
     * @return This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are
     *         written in .csv format. If <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"
     *         > <code>UseCsvNoSupValue</code> </a> is set to true, specify a string value that you want DMS to use for
     *         all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null
     *         value for these columns regardless of the <code>UseCsvNoSupValue</code> setting.</p> <note>
     *         <p>
     *         This setting is supported in DMS versions 3.4.1 and later.
     *         </p>
     */
    public final String csvNoSupValue() {
        return csvNoSupValue;
    }

    /**
     * <p>
     * If set to <code>true</code>, DMS saves the transaction order for a change data capture (CDC) load on the Amazon
     * S3 target specified by <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
     * <code>CdcPath</code> </a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
     * >Capturing data changes (CDC) including transaction order on the S3 target</a>.
     * </p>
     * <note>
     * <p>
     * This setting is supported in DMS versions 3.4.2 and later.
     * </p>
     * </note>
     * 
     * @return If set to <code>true</code>, DMS saves the transaction order for a change data capture (CDC) load on the
     *         Amazon S3 target specified by <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
     *         <code>CdcPath</code> </a>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
     *         >Capturing data changes (CDC) including transaction order on the S3 target</a>.</p> <note>
     *         <p>
     *         This setting is supported in DMS versions 3.4.2 and later.
     *         </p>
     */
    public final Boolean preserveTransactions() {
        return preserveTransactions;
    }

    /**
     * <p>
     * Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures change
     * data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS reads CDC files from this path and replicates
     * the data changes to the target endpoint. For an S3 target if you set <a href=
     * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"
     * > <code>PreserveTransactions</code> </a> to <code>true</code>, DMS verifies that you have set this parameter to a
     * folder path on your S3 target where DMS can save the transaction order for the CDC load. DMS creates this CDC
     * folder path in either your S3 target working directory or the S3 target location specified by <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
     * <code>BucketFolder</code> </a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
     * <code>BucketName</code> </a>.
     * </p>
     * <p>
     * For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you specify
     * <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code>, DMS creates
     * the CDC folder path following: <code>MyTargetBucket/MyChangedData</code>.
     * </p>
     * <p>
     * If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
     * <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>, DMS creates the CDC
     * folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code>.
     * </p>
     * <p>
     * For more information on CDC including transaction order on an S3 target, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
     * >Capturing data changes (CDC) including transaction order on the S3 target</a>.
     * </p>
     * <note>
     * <p>
     * This setting is supported in DMS versions 3.4.2 and later.
     * </p>
     * </note>
     * 
     * @return Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures
     *         change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS reads CDC files from this path
     *         and replicates the data changes to the target endpoint. For an S3 target if you set <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"
     *         > <code>PreserveTransactions</code> </a> to <code>true</code>, DMS verifies that you have set this
     *         parameter to a folder path on your S3 target where DMS can save the transaction order for the CDC load.
     *         DMS creates this CDC folder path in either your S3 target working directory or the S3 target location
     *         specified by <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder"
     *         > <code>BucketFolder</code> </a> and <a
     *         href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName"
     *         > <code>BucketName</code> </a>.</p>
     *         <p>
     *         For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you specify
     *         <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code>, DMS
     *         creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code>.
     *         </p>
     *         <p>
     *         If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
     *         <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>, DMS creates the
     *         CDC folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code>.
     *         </p>
     *         <p>
     *         For more information on CDC including transaction order on an S3 target, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
     *         >Capturing data changes (CDC) including transaction order on the S3 target</a>.
     *         </p>
     *         <note>
     *         <p>
     *         This setting is supported in DMS versions 3.4.2 and later.
     *         </p>
     */
    public final String cdcPath() {
        return cdcPath;
    }

    /**
     * <p>
     * A value that enables DMS to specify a predefined (canned) access control list for objects created in an Amazon S3
     * bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
     * <i>Amazon S3 Developer Guide.</i>
     * </p>
     * <p>
     * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
     * AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cannedAclForObjects} will return {@link CannedAclForObjectsValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cannedAclForObjectsAsString}.
     * </p>
     * 
     * @return A value that enables DMS to specify a predefined (canned) access control list for objects created in an
     *         Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
     *         <i>Amazon S3 Developer Guide.</i> </p>
     *         <p>
     *         The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
     *         AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
     * @see CannedAclForObjectsValue
     */
    public final CannedAclForObjectsValue cannedAclForObjects() {
        return CannedAclForObjectsValue.fromValue(cannedAclForObjects);
    }

    /**
     * <p>
     * A value that enables DMS to specify a predefined (canned) access control list for objects created in an Amazon S3
     * bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
     * <i>Amazon S3 Developer Guide.</i>
     * </p>
     * <p>
     * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
     * AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cannedAclForObjects} will return {@link CannedAclForObjectsValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cannedAclForObjectsAsString}.
     * </p>
     * 
     * @return A value that enables DMS to specify a predefined (canned) access control list for objects created in an
     *         Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
     *         <i>Amazon S3 Developer Guide.</i> </p>
     *         <p>
     *         The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
     *         AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
     * @see CannedAclForObjectsValue
     */
    public final String cannedAclForObjectsAsString() {
        return cannedAclForObjects;
    }

    /**
     * <p>
     * An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use to add column name
     * information to the .csv output file.
     * </p>
     * <p>
     * The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>, <code>y</code>,
     * and <code>n</code>.
     * </p>
     * 
     * @return An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use to add column
     *         name information to the .csv output file.</p>
     *         <p>
     *         The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
     *         <code>y</code>, and <code>n</code>.
     */
    public final Boolean addColumnName() {
        return addColumnName;
    }

    /**
     * <p>
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
     * </p>
     * <p>
     * When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write is
     * triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     * </p>
     * <p>
     * The default value is 60 seconds.
     * </p>
     * 
     * @return Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
     *         <p>
     *         When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write
     *         is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     *         </p>
     *         <p>
     *         The default value is 60 seconds.
     */
    public final Integer cdcMaxBatchInterval() {
        return cdcMaxBatchInterval;
    }

    /**
     * <p>
     * Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.
     * </p>
     * <p>
     * When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write is
     * triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     * </p>
     * <p>
     * The default value is 32 MB.
     * </p>
     * 
     * @return Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
     *         <p>
     *         When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write
     *         is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     *         </p>
     *         <p>
     *         The default value is 32 MB.
     */
    public final Integer cdcMinFileSize() {
        return cdcMinFileSize;
    }

    /**
     * <p>
     * An optional parameter that specifies how DMS treats null values. While handling the null value, you can use this
     * parameter to pass a user-defined string as null when writing to the target. For example, when target columns are
     * not nullable, you can use this option to differentiate between the empty string value and the null value. So, if
     * you set this parameter value to the empty string ("" or ''), DMS treats the empty string as the null value
     * instead of <code>NULL</code>.
     * </p>
     * <p>
     * The default value is <code>NULL</code>. Valid values include any valid string.
     * </p>
     * 
     * @return An optional parameter that specifies how DMS treats null values. While handling the null value, you can
     *         use this parameter to pass a user-defined string as null when writing to the target. For example, when
     *         target columns are not nullable, you can use this option to differentiate between the empty string value
     *         and the null value. So, if you set this parameter value to the empty string ("" or ''), DMS treats the
     *         empty string as the null value instead of <code>NULL</code>.</p>
     *         <p>
     *         The default value is <code>NULL</code>. Valid values include any valid string.
     */
    public final String csvNullValue() {
        return csvNullValue;
    }

    /**
     * <p>
     * When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the feature;
     * a value of 0 turns off the feature.
     * </p>
     * <p>
     * The default is 0.
     * </p>
     * 
     * @return When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the
     *         feature; a value of 0 turns off the feature.</p>
     *         <p>
     *         The default is 0.
     */
    public final Integer ignoreHeaderRows() {
        return ignoreHeaderRows;
    }

    /**
     * <p>
     * A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target
     * during full load.
     * </p>
     * <p>
     * The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
     * </p>
     * 
     * @return A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3
     *         target during full load.</p>
     *         <p>
     *         The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
     */
    public final Integer maxFileSize() {
        return maxFileSize;
    }

    /**
     * <p>
     * For an S3 source, when this value is set to <code>true</code> or <code>y</code>, each leading double quotation
     * mark has to be followed by an ending double quotation mark. This formatting complies with RFC 4180. When this
     * value is set to <code>false</code> or <code>n</code>, string literals are copied to the target as is. In this
     * case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the
     * string, because it signals the end of the value.
     * </p>
     * <p>
     * For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon
     * S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using Amazon S3 as
     * a target, if the data has quotation marks or newline characters in it, DMS encloses the entire column with an
     * additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
     * </p>
     * <p>
     * The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
     * <code>y</code>, and <code>n</code>.
     * </p>
     * 
     * @return For an S3 source, when this value is set to <code>true</code> or <code>y</code>, each leading double
     *         quotation mark has to be followed by an ending double quotation mark. This formatting complies with RFC
     *         4180. When this value is set to <code>false</code> or <code>n</code>, string literals are copied to the
     *         target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use
     *         a delimiter as part of the string, because it signals the end of the value.</p>
     *         <p>
     *         For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to
     *         Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code>
     *         using Amazon S3 as a target, if the data has quotation marks or newline characters in it, DMS encloses
     *         the entire column with an additional pair of double quotation marks ("). Every quotation mark within the
     *         data is repeated twice.
     *         </p>
     *         <p>
     *         The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
     *         <code>y</code>, and <code>n</code>.
     */
    public final Boolean rfc4180() {
        return rfc4180;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(csvRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(csvDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dictPageSizeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(rowGroupLength());
        hashCode = 31 * hashCode + Objects.hashCode(dataPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(parquetVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(includeOpForFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(cdcInsertsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(timestampColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(parquetTimestampInMillisecond());
        hashCode = 31 * hashCode + Objects.hashCode(cdcInsertsAndUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(datePartitionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(datePartitionSequenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datePartitionDelimiterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useCsvNoSupValue());
        hashCode = 31 * hashCode + Objects.hashCode(csvNoSupValue());
        hashCode = 31 * hashCode + Objects.hashCode(preserveTransactions());
        hashCode = 31 * hashCode + Objects.hashCode(cdcPath());
        hashCode = 31 * hashCode + Objects.hashCode(cannedAclForObjectsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(cdcMaxBatchInterval());
        hashCode = 31 * hashCode + Objects.hashCode(cdcMinFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(csvNullValue());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreHeaderRows());
        hashCode = 31 * hashCode + Objects.hashCode(maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(rfc4180());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Settings)) {
            return false;
        }
        S3Settings other = (S3Settings) obj;
        return Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(externalTableDefinition(), other.externalTableDefinition())
                && Objects.equals(csvRowDelimiter(), other.csvRowDelimiter())
                && Objects.equals(csvDelimiter(), other.csvDelimiter()) && Objects.equals(bucketFolder(), other.bucketFolder())
                && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(encodingTypeAsString(), other.encodingTypeAsString())
                && Objects.equals(dictPageSizeLimit(), other.dictPageSizeLimit())
                && Objects.equals(rowGroupLength(), other.rowGroupLength())
                && Objects.equals(dataPageSize(), other.dataPageSize())
                && Objects.equals(parquetVersionAsString(), other.parquetVersionAsString())
                && Objects.equals(enableStatistics(), other.enableStatistics())
                && Objects.equals(includeOpForFullLoad(), other.includeOpForFullLoad())
                && Objects.equals(cdcInsertsOnly(), other.cdcInsertsOnly())
                && Objects.equals(timestampColumnName(), other.timestampColumnName())
                && Objects.equals(parquetTimestampInMillisecond(), other.parquetTimestampInMillisecond())
                && Objects.equals(cdcInsertsAndUpdates(), other.cdcInsertsAndUpdates())
                && Objects.equals(datePartitionEnabled(), other.datePartitionEnabled())
                && Objects.equals(datePartitionSequenceAsString(), other.datePartitionSequenceAsString())
                && Objects.equals(datePartitionDelimiterAsString(), other.datePartitionDelimiterAsString())
                && Objects.equals(useCsvNoSupValue(), other.useCsvNoSupValue())
                && Objects.equals(csvNoSupValue(), other.csvNoSupValue())
                && Objects.equals(preserveTransactions(), other.preserveTransactions())
                && Objects.equals(cdcPath(), other.cdcPath())
                && Objects.equals(cannedAclForObjectsAsString(), other.cannedAclForObjectsAsString())
                && Objects.equals(addColumnName(), other.addColumnName())
                && Objects.equals(cdcMaxBatchInterval(), other.cdcMaxBatchInterval())
                && Objects.equals(cdcMinFileSize(), other.cdcMinFileSize())
                && Objects.equals(csvNullValue(), other.csvNullValue())
                && Objects.equals(ignoreHeaderRows(), other.ignoreHeaderRows())
                && Objects.equals(maxFileSize(), other.maxFileSize()) && Objects.equals(rfc4180(), other.rfc4180());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Settings").add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("ExternalTableDefinition", externalTableDefinition()).add("CsvRowDelimiter", csvRowDelimiter())
                .add("CsvDelimiter", csvDelimiter()).add("BucketFolder", bucketFolder()).add("BucketName", bucketName())
                .add("CompressionType", compressionTypeAsString()).add("EncryptionMode", encryptionModeAsString())
                .add("ServerSideEncryptionKmsKeyId", serverSideEncryptionKmsKeyId()).add("DataFormat", dataFormatAsString())
                .add("EncodingType", encodingTypeAsString()).add("DictPageSizeLimit", dictPageSizeLimit())
                .add("RowGroupLength", rowGroupLength()).add("DataPageSize", dataPageSize())
                .add("ParquetVersion", parquetVersionAsString()).add("EnableStatistics", enableStatistics())
                .add("IncludeOpForFullLoad", includeOpForFullLoad()).add("CdcInsertsOnly", cdcInsertsOnly())
                .add("TimestampColumnName", timestampColumnName())
                .add("ParquetTimestampInMillisecond", parquetTimestampInMillisecond())
                .add("CdcInsertsAndUpdates", cdcInsertsAndUpdates()).add("DatePartitionEnabled", datePartitionEnabled())
                .add("DatePartitionSequence", datePartitionSequenceAsString())
                .add("DatePartitionDelimiter", datePartitionDelimiterAsString()).add("UseCsvNoSupValue", useCsvNoSupValue())
                .add("CsvNoSupValue", csvNoSupValue()).add("PreserveTransactions", preserveTransactions())
                .add("CdcPath", cdcPath()).add("CannedAclForObjects", cannedAclForObjectsAsString())
                .add("AddColumnName", addColumnName()).add("CdcMaxBatchInterval", cdcMaxBatchInterval())
                .add("CdcMinFileSize", cdcMinFileSize()).add("CsvNullValue", csvNullValue())
                .add("IgnoreHeaderRows", ignoreHeaderRows()).add("MaxFileSize", maxFileSize()).add("Rfc4180", rfc4180()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ExternalTableDefinition":
            return Optional.ofNullable(clazz.cast(externalTableDefinition()));
        case "CsvRowDelimiter":
            return Optional.ofNullable(clazz.cast(csvRowDelimiter()));
        case "CsvDelimiter":
            return Optional.ofNullable(clazz.cast(csvDelimiter()));
        case "BucketFolder":
            return Optional.ofNullable(clazz.cast(bucketFolder()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "CompressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "ServerSideEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionKmsKeyId()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "EncodingType":
            return Optional.ofNullable(clazz.cast(encodingTypeAsString()));
        case "DictPageSizeLimit":
            return Optional.ofNullable(clazz.cast(dictPageSizeLimit()));
        case "RowGroupLength":
            return Optional.ofNullable(clazz.cast(rowGroupLength()));
        case "DataPageSize":
            return Optional.ofNullable(clazz.cast(dataPageSize()));
        case "ParquetVersion":
            return Optional.ofNullable(clazz.cast(parquetVersionAsString()));
        case "EnableStatistics":
            return Optional.ofNullable(clazz.cast(enableStatistics()));
        case "IncludeOpForFullLoad":
            return Optional.ofNullable(clazz.cast(includeOpForFullLoad()));
        case "CdcInsertsOnly":
            return Optional.ofNullable(clazz.cast(cdcInsertsOnly()));
        case "TimestampColumnName":
            return Optional.ofNullable(clazz.cast(timestampColumnName()));
        case "ParquetTimestampInMillisecond":
            return Optional.ofNullable(clazz.cast(parquetTimestampInMillisecond()));
        case "CdcInsertsAndUpdates":
            return Optional.ofNullable(clazz.cast(cdcInsertsAndUpdates()));
        case "DatePartitionEnabled":
            return Optional.ofNullable(clazz.cast(datePartitionEnabled()));
        case "DatePartitionSequence":
            return Optional.ofNullable(clazz.cast(datePartitionSequenceAsString()));
        case "DatePartitionDelimiter":
            return Optional.ofNullable(clazz.cast(datePartitionDelimiterAsString()));
        case "UseCsvNoSupValue":
            return Optional.ofNullable(clazz.cast(useCsvNoSupValue()));
        case "CsvNoSupValue":
            return Optional.ofNullable(clazz.cast(csvNoSupValue()));
        case "PreserveTransactions":
            return Optional.ofNullable(clazz.cast(preserveTransactions()));
        case "CdcPath":
            return Optional.ofNullable(clazz.cast(cdcPath()));
        case "CannedAclForObjects":
            return Optional.ofNullable(clazz.cast(cannedAclForObjectsAsString()));
        case "AddColumnName":
            return Optional.ofNullable(clazz.cast(addColumnName()));
        case "CdcMaxBatchInterval":
            return Optional.ofNullable(clazz.cast(cdcMaxBatchInterval()));
        case "CdcMinFileSize":
            return Optional.ofNullable(clazz.cast(cdcMinFileSize()));
        case "CsvNullValue":
            return Optional.ofNullable(clazz.cast(csvNullValue()));
        case "IgnoreHeaderRows":
            return Optional.ofNullable(clazz.cast(ignoreHeaderRows()));
        case "MaxFileSize":
            return Optional.ofNullable(clazz.cast(maxFileSize()));
        case "Rfc4180":
            return Optional.ofNullable(clazz.cast(rfc4180()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Settings, T> g) {
        return obj -> g.apply((S3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Settings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
         * <code>iam:PassRole</code> action. It is a required parameter that enables DMS to write and read objects from
         * an S3 bucket.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
         *        <code>iam:PassRole</code> action. It is a required parameter that enables DMS to write and read
         *        objects from an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Specifies how tables are defined in the S3 source files only.
         * </p>
         * 
         * @param externalTableDefinition
         *        Specifies how tables are defined in the S3 source files only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalTableDefinition(String externalTableDefinition);

        /**
         * <p>
         * The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage
         * return (<code>\n</code>).
         * </p>
         * 
         * @param csvRowDelimiter
         *        The delimiter used to separate rows in the .csv file for both source and target. The default is a
         *        carriage return (<code>\n</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvRowDelimiter(String csvRowDelimiter);

        /**
         * <p>
         * The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
         * </p>
         * 
         * @param csvDelimiter
         *        The delimiter used to separate columns in the .csv file for both source and target. The default is a
         *        comma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvDelimiter(String csvDelimiter);

        /**
         * <p>
         * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
         * <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter isn't specified,
         * then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
         * </p>
         * 
         * @param bucketFolder
         *        An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the
         *        path <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter isn't
         *        specified, then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketFolder(String bucketFolder);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
         * Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This
         * parameter applies to both .csv and .parquet file formats.
         * </p>
         * 
         * @param compressionType
         *        An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target
         *        files. Either set this parameter to NONE (the default) or don't use it to leave the files
         *        uncompressed. This parameter applies to both .csv and .parquet file formats.
         * @see CompressionTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionTypeValue
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
         * Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This
         * parameter applies to both .csv and .parquet file formats.
         * </p>
         * 
         * @param compressionType
         *        An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target
         *        files. Either set this parameter to NONE (the default) or don't use it to leave the files
         *        uncompressed. This parameter applies to both .csv and .parquet file formats.
         * @see CompressionTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionTypeValue
         */
        Builder compressionType(CompressionTypeValue compressionType);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>.
         * </p>
         * <note>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change
         * the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         * </p>
         * </note>
         * <p>
         * To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to allow
         * <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:CreateBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObjectVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucketPolicy</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
         *        <p>
         *        For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         *        <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
         *        change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         *        </p>
         *        </note>
         *        <p>
         *        To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to
         *        allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:CreateBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObjectVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucketPolicy</code>
         *        </p>
         *        </li>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>.
         * </p>
         * <note>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         * <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change
         * the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         * </p>
         * </note>
         * <p>
         * To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to allow
         * <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:CreateBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObjectVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucketPolicy</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note>
         *        <p>
         *        For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
         *        <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t
         *        change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.
         *        </p>
         *        </note>
         *        <p>
         *        To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to
         *        allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:CreateBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObjectVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucketPolicy</code>
         *        </p>
         *        </li>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(EncryptionModeValue encryptionMode);

        /**
         * <p>
         * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the KMS key ID. The key
         * that you use needs an attached policy that enables Identity and Access Management (IAM) user permissions and
         * allows use of the key.
         * </p>
         * <p>
         * Here is a CLI example:
         * <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
         * </p>
         * 
         * @param serverSideEncryptionKmsKeyId
         *        If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the KMS key ID. The
         *        key that you use needs an attached policy that enables Identity and Access Management (IAM) user
         *        permissions and allows use of the key.</p>
         *        <p>
         *        Here is a CLI example:
         *        <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId);

        /**
         * <p>
         * The format of the data that you want to use for output. You can choose one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
         * compression and provides faster query response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The format of the data that you want to use for output. You can choose one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
         *        efficient compression and provides faster query response.
         *        </p>
         *        </li>
         * @see DataFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormatValue
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The format of the data that you want to use for output. You can choose one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
         * compression and provides faster query response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The format of the data that you want to use for output. You can choose one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
         *        efficient compression and provides faster query response.
         *        </p>
         *        </li>
         * @see DataFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormatValue
         */
        Builder dataFormat(DataFormatValue dataFormat);

        /**
         * <p>
         * The type of encoding you are using:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
         * values more efficiently. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary
         * is stored in a dictionary page for each column chunk.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encodingType
         *        The type of encoding you are using: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store
         *        repeated values more efficiently. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
         *        dictionary is stored in a dictionary page for each column chunk.
         *        </p>
         *        </li>
         * @see EncodingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingTypeValue
         */
        Builder encodingType(String encodingType);

        /**
         * <p>
         * The type of encoding you are using:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
         * values more efficiently. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary
         * is stored in a dictionary page for each column chunk.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encodingType
         *        The type of encoding you are using: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store
         *        repeated values more efficiently. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
         *        dictionary is stored in a dictionary page for each column chunk.
         *        </p>
         *        </li>
         * @see EncodingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingTypeValue
         */
        Builder encodingType(EncodingTypeValue encodingType);

        /**
         * <p>
         * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column
         * is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024 bytes (1 MiB),
         * the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for
         * .parquet file format only.
         * </p>
         * 
         * @param dictPageSizeLimit
         *        The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this
         *        column is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024
         *        bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding.
         *        This size is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dictPageSizeLimit(Integer dictPageSizeLimit);

        /**
         * <p>
         * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row
         * groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for
         * .parquet file format only.
         * </p>
         * <p>
         * If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length
         * in bytes (64 * 1024 * 1024).
         * </p>
         * 
         * @param rowGroupLength
         *        The number of rows in a row group. A smaller row group size provides faster reads. But as the number
         *        of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is
         *        used for .parquet file format only. </p>
         *        <p>
         *        If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group
         *        length in bytes (64 * 1024 * 1024).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowGroupLength(Integer rowGroupLength);

        /**
         * <p>
         * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used
         * for .parquet file format only.
         * </p>
         * 
         * @param dataPageSize
         *        The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number
         *        is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPageSize(Integer dataPageSize);

        /**
         * <p>
         * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
         * <code>parquet_2_0</code>.
         * </p>
         * 
         * @param parquetVersion
         *        The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default)
         *        or <code>parquet_2_0</code>.
         * @see ParquetVersionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetVersionValue
         */
        Builder parquetVersion(String parquetVersion);

        /**
         * <p>
         * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
         * <code>parquet_2_0</code>.
         * </p>
         * 
         * @param parquetVersion
         *        The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default)
         *        or <code>parquet_2_0</code>.
         * @see ParquetVersionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetVersionValue
         */
        Builder parquetVersion(ParquetVersionValue parquetVersion);

        /**
         * <p>
         * A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
         * statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>,
         * <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This value is
         * used for .parquet file format only.
         * </p>
         * 
         * @param enableStatistics
         *        A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
         *        statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>
         *        , <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This
         *        value is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableStatistics(Boolean enableStatistics);

        /**
         * <p>
         * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files
         * only to indicate how the rows were added to the source database.
         * </p>
         * <note>
         * <p>
         * DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * For full load, records can only be inserted. By default (the <code>false</code> setting), no information is
         * recorded in these output files for a full load to indicate that the rows were inserted at the source
         * database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT is
         * recorded as an I annotation in the first field of the .csv file. This allows the format of your target
         * records from a full load to be consistent with the target records from a CDC load.
         * </p>
         * <note>
         * <p>
         * This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code>
         * parameters for output to .csv files only. For more information about how these settings work together, see <a
         * href
         * ="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         * Guide.</i>.
         * </p>
         * </note>
         * 
         * @param includeOpForFullLoad
         *        A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output
         *        files only to indicate how the rows were added to the source database.</p> <note>
         *        <p>
         *        DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        For full load, records can only be inserted. By default (the <code>false</code> setting), no
         *        information is recorded in these output files for a full load to indicate that the rows were inserted
         *        at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or
         *        <code>y</code>, the INSERT is recorded as an I annotation in the first field of the .csv file. This
         *        allows the format of your target records from a full load to be consistent with the target records
         *        from a CDC load.
         *        </p>
         *        <note>
         *        <p>
         *        This setting works together with the <code>CdcInsertsOnly</code> and the
         *        <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about
         *        how these settings work together, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         *        >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         *        Guide.</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOpForFullLoad(Boolean includeOpForFullLoad);

        /**
         * <p>
         * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar
         * storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or
         * .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the
         * row was inserted, updated, or deleted at the source database for a CDC load to the target.
         * </p>
         * <p>
         * If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the source
         * database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded
         * depends on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
         * <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT operation at the
         * source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC record is written
         * without a first field to indicate the INSERT operation at the source. For more information about how these
         * settings work together, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         * Guide.</i>.
         * </p>
         * <note>
         * <p>
         * DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and
         * <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
         * </p>
         * <p>
         * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for
         * the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to
         * <code>true</code> for the same endpoint, but not both.
         * </p>
         * </note>
         * 
         * @param cdcInsertsOnly
         *        A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or
         *        columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field
         *        in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values
         *        indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to
         *        the target.</p>
         *        <p>
         *        If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the
         *        source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are
         *        recorded depends on the value of <code>IncludeOpForFullLoad</code>. If
         *        <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every CDC record is
         *        set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set
         *        to <code>false</code>, every CDC record is written without a first field to indicate the INSERT
         *        operation at the source. For more information about how these settings work together, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         *        >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         *        Guide.</i>.
         *        </p>
         *        <note>
         *        <p>
         *        DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and
         *        <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
         *        </p>
         *        <p>
         *        <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to
         *        <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or
         *        <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcInsertsOnly(Boolean cdcInsertsOnly);

        /**
         * <p>
         * A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for an
         * Amazon S3 target.
         * </p>
         * <note>
         * <p>
         * DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated
         * data when you set <code>TimestampColumnName</code> to a nonblank value.
         * </p>
         * <p>
         * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred
         * from the source to the target by DMS.
         * </p>
         * <p>
         * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit
         * of that row in the source database.
         * </p>
         * <p>
         * The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
         * precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the
         * commit timestamp supported by DMS for the source database.
         * </p>
         * <p>
         * When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for the
         * timestamp column that you set with <code>TimestampColumnName</code>.
         * </p>
         * 
         * @param timestampColumnName
         *        A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data
         *        for an Amazon S3 target.</p> <note>
         *        <p>
         *        DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your
         *        migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
         *        </p>
         *        <p>
         *        For a full load, each row of this timestamp column contains a timestamp for when the data was
         *        transferred from the source to the target by DMS.
         *        </p>
         *        <p>
         *        For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the
         *        commit of that row in the source database.
         *        </p>
         *        <p>
         *        The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By
         *        default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision
         *        depends on the commit timestamp supported by DMS for the source database.
         *        </p>
         *        <p>
         *        When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name
         *        for the timestamp column that you set with <code>TimestampColumnName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampColumnName(String timestampColumnName);

        /**
         * <p>
         * A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an
         * Amazon S3 object file in .parquet format.
         * </p>
         * <note>
         * <p>
         * DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, DMS writes all
         * <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes
         * them with microsecond precision.
         * </p>
         * <p>
         * Currently, Amazon Athena and Glue can handle only millisecond precision for <code>TIMESTAMP</code> values.
         * Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you
         * plan to query or process the data with Athena or Glue.
         * </p>
         * <note>
         * <p>
         * DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond
         * precision.
         * </p>
         * <p>
         * Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column
         * value that is inserted by setting the <code>TimestampColumnName</code> parameter.
         * </p>
         * </note>
         * 
         * @param parquetTimestampInMillisecond
         *        A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to
         *        an Amazon S3 object file in .parquet format.</p> <note>
         *        <p>
         *        DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, DMS
         *        writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision.
         *        Otherwise, DMS writes them with microsecond precision.
         *        </p>
         *        <p>
         *        Currently, Amazon Athena and Glue can handle only millisecond precision for <code>TIMESTAMP</code>
         *        values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet
         *        formatted only if you plan to query or process the data with Athena or Glue.
         *        </p>
         *        <note>
         *        <p>
         *        DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with
         *        microsecond precision.
         *        </p>
         *        <p>
         *        Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp
         *        column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond);

        /**
         * <p>
         * A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or
         * .parquet (columnar storage) output files. The default setting is <code>false</code>, but when
         * <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code>, only INSERTs and UPDATEs
         * from the source database are migrated to the .csv or .parquet file.
         * </p>
         * <p>
         * For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the
         * <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code>
         * , the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT
         * and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code>,
         * CDC records are written without an indication of INSERT or UPDATE operations at the source. For more
         * information about how these settings work together, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         * Guide.</i>.
         * </p>
         * <note>
         * <p>
         * DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
         * </p>
         * <p>
         * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for
         * the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to
         * <code>true</code> for the same endpoint, but not both.
         * </p>
         * </note>
         * 
         * @param cdcInsertsAndUpdates
         *        A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or
         *        .parquet (columnar storage) output files. The default setting is <code>false</code>, but when
         *        <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code>, only INSERTs and
         *        UPDATEs from the source database are migrated to the .csv or .parquet file. </p>
         *        <p>
         *        For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the
         *        <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to
         *        <code>true</code>, the first field of every CDC record is set to either <code>I</code> or
         *        <code>U</code> to indicate INSERT and UPDATE operations at the source. But if
         *        <code>IncludeOpForFullLoad</code> is set to <code>false</code>, CDC records are written without an
         *        indication of INSERT or UPDATE operations at the source. For more information about how these settings
         *        work together, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         *        >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User
         *        Guide.</i>.
         *        </p>
         *        <note>
         *        <p>
         *        DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
         *        </p>
         *        <p>
         *        <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to
         *        <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or
         *        <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates);

        /**
         * <p>
         * When set to <code>true</code>, this parameter partitions S3 bucket folders based on transaction commit dates.
         * The default value is <code>false</code>. For more information about date-based folder partitioning, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">
         * Using date-based folder partitioning</a>.
         * </p>
         * 
         * @param datePartitionEnabled
         *        When set to <code>true</code>, this parameter partitions S3 bucket folders based on transaction commit
         *        dates. The default value is <code>false</code>. For more information about date-based folder
         *        partitioning, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning"
         *        >Using date-based folder partitioning</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datePartitionEnabled(Boolean datePartitionEnabled);

        /**
         * <p>
         * Identifies the sequence of the date format to use during folder partitioning. The default value is
         * <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         * <code>true</code>.
         * </p>
         * 
         * @param datePartitionSequence
         *        Identifies the sequence of the date format to use during folder partitioning. The default value is
         *        <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         *        <code>true</code>.
         * @see DatePartitionSequenceValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatePartitionSequenceValue
         */
        Builder datePartitionSequence(String datePartitionSequence);

        /**
         * <p>
         * Identifies the sequence of the date format to use during folder partitioning. The default value is
         * <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         * <code>true</code>.
         * </p>
         * 
         * @param datePartitionSequence
         *        Identifies the sequence of the date format to use during folder partitioning. The default value is
         *        <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         *        <code>true</code>.
         * @see DatePartitionSequenceValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatePartitionSequenceValue
         */
        Builder datePartitionSequence(DatePartitionSequenceValue datePartitionSequence);

        /**
         * <p>
         * Specifies a date separating delimiter to use during folder partitioning. The default value is
         * <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
         * </p>
         * 
         * @param datePartitionDelimiter
         *        Specifies a date separating delimiter to use during folder partitioning. The default value is
         *        <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         *        <code>true</code>.
         * @see DatePartitionDelimiterValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatePartitionDelimiterValue
         */
        Builder datePartitionDelimiter(String datePartitionDelimiter);

        /**
         * <p>
         * Specifies a date separating delimiter to use during folder partitioning. The default value is
         * <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.
         * </p>
         * 
         * @param datePartitionDelimiter
         *        Specifies a date separating delimiter to use during folder partitioning. The default value is
         *        <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to
         *        <code>true</code>.
         * @see DatePartitionDelimiterValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatePartitionDelimiterValue
         */
        Builder datePartitionDelimiter(DatePartitionDelimiterValue datePartitionDelimiter);

        /**
         * <p>
         * This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv
         * format. If set to <code>true</code> for columns not included in the supplemental log, DMS uses the value
         * specified by <a href=
         * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
         * <code>CsvNoSupValue</code> </a>. If not set or set to <code>false</code>, DMS uses the null value for these
         * columns.
         * </p>
         * <note>
         * <p>
         * This setting is supported in DMS versions 3.4.1 and later.
         * </p>
         * </note>
         * 
         * @param useCsvNoSupValue
         *        This setting applies if the S3 output files during a change data capture (CDC) load are written in
         *        .csv format. If set to <code>true</code> for columns not included in the supplemental log, DMS uses
         *        the value specified by <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"
         *        > <code>CsvNoSupValue</code> </a>. If not set or set to <code>false</code>, DMS uses the null value
         *        for these columns.</p> <note>
         *        <p>
         *        This setting is supported in DMS versions 3.4.1 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCsvNoSupValue(Boolean useCsvNoSupValue);

        /**
         * <p>
         * This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written
         * in .csv format. If <a href=
         * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"
         * > <code>UseCsvNoSupValue</code> </a> is set to true, specify a string value that you want DMS to use for all
         * columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value
         * for these columns regardless of the <code>UseCsvNoSupValue</code> setting.
         * </p>
         * <note>
         * <p>
         * This setting is supported in DMS versions 3.4.1 and later.
         * </p>
         * </note>
         * 
         * @param csvNoSupValue
         *        This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are
         *        written in .csv format. If <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"
         *        > <code>UseCsvNoSupValue</code> </a> is set to true, specify a string value that you want DMS to use
         *        for all columns not included in the supplemental log. If you do not specify a string value, DMS uses
         *        the null value for these columns regardless of the <code>UseCsvNoSupValue</code> setting.</p> <note>
         *        <p>
         *        This setting is supported in DMS versions 3.4.1 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvNoSupValue(String csvNoSupValue);

        /**
         * <p>
         * If set to <code>true</code>, DMS saves the transaction order for a change data capture (CDC) load on the
         * Amazon S3 target specified by <a
         * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
         * <code>CdcPath</code> </a>. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
         * >Capturing data changes (CDC) including transaction order on the S3 target</a>.
         * </p>
         * <note>
         * <p>
         * This setting is supported in DMS versions 3.4.2 and later.
         * </p>
         * </note>
         * 
         * @param preserveTransactions
         *        If set to <code>true</code>, DMS saves the transaction order for a change data capture (CDC) load on
         *        the Amazon S3 target specified by <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
         *        <code>CdcPath</code> </a>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
         *        >Capturing data changes (CDC) including transaction order on the S3 target</a>.</p> <note>
         *        <p>
         *        This setting is supported in DMS versions 3.4.2 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveTransactions(Boolean preserveTransactions);

        /**
         * <p>
         * Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures change
         * data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS reads CDC files from this path and
         * replicates the data changes to the target endpoint. For an S3 target if you set <a href=
         * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"
         * > <code>PreserveTransactions</code> </a> to <code>true</code>, DMS verifies that you have set this parameter
         * to a folder path on your S3 target where DMS can save the transaction order for the CDC load. DMS creates
         * this CDC folder path in either your S3 target working directory or the S3 target location specified by <a
         * href
         * ="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
         * <code>BucketFolder</code> </a> and <a href=
         * "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
         * <code>BucketName</code> </a>.
         * </p>
         * <p>
         * For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you specify
         * <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code>, DMS
         * creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code>.
         * </p>
         * <p>
         * If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
         * <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>, DMS creates the CDC
         * folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code>.
         * </p>
         * <p>
         * For more information on CDC including transaction order on an S3 target, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
         * >Capturing data changes (CDC) including transaction order on the S3 target</a>.
         * </p>
         * <note>
         * <p>
         * This setting is supported in DMS versions 3.4.2 and later.
         * </p>
         * </note>
         * 
         * @param cdcPath
         *        Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures
         *        change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS reads CDC files from this
         *        path and replicates the data changes to the target endpoint. For an S3 target if you set <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"
         *        > <code>PreserveTransactions</code> </a> to <code>true</code>, DMS verifies that you have set this
         *        parameter to a folder path on your S3 target where DMS can save the transaction order for the CDC
         *        load. DMS creates this CDC folder path in either your S3 target working directory or the S3 target
         *        location specified by <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder"
         *        > <code>BucketFolder</code> </a> and <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName"
         *        > <code>BucketName</code> </a>.</p>
         *        <p>
         *        For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you specify
         *        <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code>,
         *        DMS creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code>.
         *        </p>
         *        <p>
         *        If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
         *        <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>, DMS creates
         *        the CDC folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code>.
         *        </p>
         *        <p>
         *        For more information on CDC including transaction order on an S3 target, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath"
         *        >Capturing data changes (CDC) including transaction order on the S3 target</a>.
         *        </p>
         *        <note>
         *        <p>
         *        This setting is supported in DMS versions 3.4.2 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcPath(String cdcPath);

        /**
         * <p>
         * A value that enables DMS to specify a predefined (canned) access control list for objects created in an
         * Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
         * <i>Amazon S3 Developer Guide.</i>
         * </p>
         * <p>
         * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
         * AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         * </p>
         * 
         * @param cannedAclForObjects
         *        A value that enables DMS to specify a predefined (canned) access control list for objects created in
         *        an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see
         *        <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a>
         *        in the <i>Amazon S3 Developer Guide.</i> </p>
         *        <p>
         *        The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
         *        AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         * @see CannedAclForObjectsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAclForObjectsValue
         */
        Builder cannedAclForObjects(String cannedAclForObjects);

        /**
         * <p>
         * A value that enables DMS to specify a predefined (canned) access control list for objects created in an
         * Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the
         * <i>Amazon S3 Developer Guide.</i>
         * </p>
         * <p>
         * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
         * AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         * </p>
         * 
         * @param cannedAclForObjects
         *        A value that enables DMS to specify a predefined (canned) access control list for objects created in
         *        an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see
         *        <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a>
         *        in the <i>Amazon S3 Developer Guide.</i> </p>
         *        <p>
         *        The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE,
         *        AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         * @see CannedAclForObjectsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAclForObjectsValue
         */
        Builder cannedAclForObjects(CannedAclForObjectsValue cannedAclForObjects);

        /**
         * <p>
         * An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use to add column name
         * information to the .csv output file.
         * </p>
         * <p>
         * The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
         * <code>y</code>, and <code>n</code>.
         * </p>
         * 
         * @param addColumnName
         *        An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use to add column
         *        name information to the .csv output file.</p>
         *        <p>
         *        The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
         *        <code>y</code>, and <code>n</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addColumnName(Boolean addColumnName);

        /**
         * <p>
         * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
         * </p>
         * <p>
         * When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write is
         * triggered by whichever parameter condition is met first within an DMS CloudFormation template.
         * </p>
         * <p>
         * The default value is 60 seconds.
         * </p>
         * 
         * @param cdcMaxBatchInterval
         *        Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
         *        <p>
         *        When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file
         *        write is triggered by whichever parameter condition is met first within an DMS CloudFormation
         *        template.
         *        </p>
         *        <p>
         *        The default value is 60 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcMaxBatchInterval(Integer cdcMaxBatchInterval);

        /**
         * <p>
         * Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.
         * </p>
         * <p>
         * When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write is
         * triggered by whichever parameter condition is met first within an DMS CloudFormation template.
         * </p>
         * <p>
         * The default value is 32 MB.
         * </p>
         * 
         * @param cdcMinFileSize
         *        Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
         *        <p>
         *        When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file
         *        write is triggered by whichever parameter condition is met first within an DMS CloudFormation
         *        template.
         *        </p>
         *        <p>
         *        The default value is 32 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcMinFileSize(Integer cdcMinFileSize);

        /**
         * <p>
         * An optional parameter that specifies how DMS treats null values. While handling the null value, you can use
         * this parameter to pass a user-defined string as null when writing to the target. For example, when target
         * columns are not nullable, you can use this option to differentiate between the empty string value and the
         * null value. So, if you set this parameter value to the empty string ("" or ''), DMS treats the empty string
         * as the null value instead of <code>NULL</code>.
         * </p>
         * <p>
         * The default value is <code>NULL</code>. Valid values include any valid string.
         * </p>
         * 
         * @param csvNullValue
         *        An optional parameter that specifies how DMS treats null values. While handling the null value, you
         *        can use this parameter to pass a user-defined string as null when writing to the target. For example,
         *        when target columns are not nullable, you can use this option to differentiate between the empty
         *        string value and the null value. So, if you set this parameter value to the empty string ("" or ''),
         *        DMS treats the empty string as the null value instead of <code>NULL</code>.</p>
         *        <p>
         *        The default value is <code>NULL</code>. Valid values include any valid string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvNullValue(String csvNullValue);

        /**
         * <p>
         * When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the
         * feature; a value of 0 turns off the feature.
         * </p>
         * <p>
         * The default is 0.
         * </p>
         * 
         * @param ignoreHeaderRows
         *        When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on
         *        the feature; a value of 0 turns off the feature.</p>
         *        <p>
         *        The default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreHeaderRows(Integer ignoreHeaderRows);

        /**
         * <p>
         * A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3
         * target during full load.
         * </p>
         * <p>
         * The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
         * </p>
         * 
         * @param maxFileSize
         *        A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an
         *        S3 target during full load.</p>
         *        <p>
         *        The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFileSize(Integer maxFileSize);

        /**
         * <p>
         * For an S3 source, when this value is set to <code>true</code> or <code>y</code>, each leading double
         * quotation mark has to be followed by an ending double quotation mark. This formatting complies with RFC 4180.
         * When this value is set to <code>false</code> or <code>n</code>, string literals are copied to the target as
         * is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter
         * as part of the string, because it signals the end of the value.
         * </p>
         * <p>
         * For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to
         * Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using
         * Amazon S3 as a target, if the data has quotation marks or newline characters in it, DMS encloses the entire
         * column with an additional pair of double quotation marks ("). Every quotation mark within the data is
         * repeated twice.
         * </p>
         * <p>
         * The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
         * <code>y</code>, and <code>n</code>.
         * </p>
         * 
         * @param rfc4180
         *        For an S3 source, when this value is set to <code>true</code> or <code>y</code>, each leading double
         *        quotation mark has to be followed by an ending double quotation mark. This formatting complies with
         *        RFC 4180. When this value is set to <code>false</code> or <code>n</code>, string literals are copied
         *        to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you
         *        can't use a delimiter as part of the string, because it signals the end of the value.</p>
         *        <p>
         *        For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated
         *        to Amazon S3 using .csv file format only. When this value is set to <code>true</code> or
         *        <code>y</code> using Amazon S3 as a target, if the data has quotation marks or newline characters in
         *        it, DMS encloses the entire column with an additional pair of double quotation marks ("). Every
         *        quotation mark within the data is repeated twice.
         *        </p>
         *        <p>
         *        The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
         *        <code>y</code>, and <code>n</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfc4180(Boolean rfc4180);
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccessRoleArn;

        private String externalTableDefinition;

        private String csvRowDelimiter;

        private String csvDelimiter;

        private String bucketFolder;

        private String bucketName;

        private String compressionType;

        private String encryptionMode;

        private String serverSideEncryptionKmsKeyId;

        private String dataFormat;

        private String encodingType;

        private Integer dictPageSizeLimit;

        private Integer rowGroupLength;

        private Integer dataPageSize;

        private String parquetVersion;

        private Boolean enableStatistics;

        private Boolean includeOpForFullLoad;

        private Boolean cdcInsertsOnly;

        private String timestampColumnName;

        private Boolean parquetTimestampInMillisecond;

        private Boolean cdcInsertsAndUpdates;

        private Boolean datePartitionEnabled;

        private String datePartitionSequence;

        private String datePartitionDelimiter;

        private Boolean useCsvNoSupValue;

        private String csvNoSupValue;

        private Boolean preserveTransactions;

        private String cdcPath;

        private String cannedAclForObjects;

        private Boolean addColumnName;

        private Integer cdcMaxBatchInterval;

        private Integer cdcMinFileSize;

        private String csvNullValue;

        private Integer ignoreHeaderRows;

        private Integer maxFileSize;

        private Boolean rfc4180;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Settings model) {
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            externalTableDefinition(model.externalTableDefinition);
            csvRowDelimiter(model.csvRowDelimiter);
            csvDelimiter(model.csvDelimiter);
            bucketFolder(model.bucketFolder);
            bucketName(model.bucketName);
            compressionType(model.compressionType);
            encryptionMode(model.encryptionMode);
            serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            dataFormat(model.dataFormat);
            encodingType(model.encodingType);
            dictPageSizeLimit(model.dictPageSizeLimit);
            rowGroupLength(model.rowGroupLength);
            dataPageSize(model.dataPageSize);
            parquetVersion(model.parquetVersion);
            enableStatistics(model.enableStatistics);
            includeOpForFullLoad(model.includeOpForFullLoad);
            cdcInsertsOnly(model.cdcInsertsOnly);
            timestampColumnName(model.timestampColumnName);
            parquetTimestampInMillisecond(model.parquetTimestampInMillisecond);
            cdcInsertsAndUpdates(model.cdcInsertsAndUpdates);
            datePartitionEnabled(model.datePartitionEnabled);
            datePartitionSequence(model.datePartitionSequence);
            datePartitionDelimiter(model.datePartitionDelimiter);
            useCsvNoSupValue(model.useCsvNoSupValue);
            csvNoSupValue(model.csvNoSupValue);
            preserveTransactions(model.preserveTransactions);
            cdcPath(model.cdcPath);
            cannedAclForObjects(model.cannedAclForObjects);
            addColumnName(model.addColumnName);
            cdcMaxBatchInterval(model.cdcMaxBatchInterval);
            cdcMinFileSize(model.cdcMinFileSize);
            csvNullValue(model.csvNullValue);
            ignoreHeaderRows(model.ignoreHeaderRows);
            maxFileSize(model.maxFileSize);
            rfc4180(model.rfc4180);
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getExternalTableDefinition() {
            return externalTableDefinition;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        @Override
        @Transient
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final String getCsvRowDelimiter() {
            return csvRowDelimiter;
        }

        public final void setCsvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
        }

        @Override
        @Transient
        public final Builder csvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        public final String getCsvDelimiter() {
            return csvDelimiter;
        }

        public final void setCsvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        @Override
        @Transient
        public final Builder csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        public final String getBucketFolder() {
            return bucketFolder;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        @Override
        @Transient
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getCompressionType() {
            return compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        @Transient
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        @Transient
        public final Builder compressionType(CompressionTypeValue compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        @Transient
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return serverSideEncryptionKmsKeyId;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        @Transient
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder dataFormat(DataFormatValue dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncodingType() {
            return encodingType;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        @Transient
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        @Transient
        public final Builder encodingType(EncodingTypeValue encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final Integer getDictPageSizeLimit() {
            return dictPageSizeLimit;
        }

        public final void setDictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
        }

        @Override
        @Transient
        public final Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        public final Integer getRowGroupLength() {
            return rowGroupLength;
        }

        public final void setRowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
        }

        @Override
        @Transient
        public final Builder rowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
            return this;
        }

        public final Integer getDataPageSize() {
            return dataPageSize;
        }

        public final void setDataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
        }

        @Override
        @Transient
        public final Builder dataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
            return this;
        }

        public final String getParquetVersion() {
            return parquetVersion;
        }

        public final void setParquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
        }

        @Override
        @Transient
        public final Builder parquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
            return this;
        }

        @Override
        @Transient
        public final Builder parquetVersion(ParquetVersionValue parquetVersion) {
            this.parquetVersion(parquetVersion == null ? null : parquetVersion.toString());
            return this;
        }

        public final Boolean getEnableStatistics() {
            return enableStatistics;
        }

        public final void setEnableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
        }

        @Override
        @Transient
        public final Builder enableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
            return this;
        }

        public final Boolean getIncludeOpForFullLoad() {
            return includeOpForFullLoad;
        }

        public final void setIncludeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
        }

        @Override
        @Transient
        public final Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        public final Boolean getCdcInsertsOnly() {
            return cdcInsertsOnly;
        }

        public final void setCdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
        }

        @Override
        @Transient
        public final Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        public final String getTimestampColumnName() {
            return timestampColumnName;
        }

        public final void setTimestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
        }

        @Override
        @Transient
        public final Builder timestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
            return this;
        }

        public final Boolean getParquetTimestampInMillisecond() {
            return parquetTimestampInMillisecond;
        }

        public final void setParquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
        }

        @Override
        @Transient
        public final Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
            return this;
        }

        public final Boolean getCdcInsertsAndUpdates() {
            return cdcInsertsAndUpdates;
        }

        public final void setCdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
        }

        @Override
        @Transient
        public final Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        public final Boolean getDatePartitionEnabled() {
            return datePartitionEnabled;
        }

        public final void setDatePartitionEnabled(Boolean datePartitionEnabled) {
            this.datePartitionEnabled = datePartitionEnabled;
        }

        @Override
        @Transient
        public final Builder datePartitionEnabled(Boolean datePartitionEnabled) {
            this.datePartitionEnabled = datePartitionEnabled;
            return this;
        }

        public final String getDatePartitionSequence() {
            return datePartitionSequence;
        }

        public final void setDatePartitionSequence(String datePartitionSequence) {
            this.datePartitionSequence = datePartitionSequence;
        }

        @Override
        @Transient
        public final Builder datePartitionSequence(String datePartitionSequence) {
            this.datePartitionSequence = datePartitionSequence;
            return this;
        }

        @Override
        @Transient
        public final Builder datePartitionSequence(DatePartitionSequenceValue datePartitionSequence) {
            this.datePartitionSequence(datePartitionSequence == null ? null : datePartitionSequence.toString());
            return this;
        }

        public final String getDatePartitionDelimiter() {
            return datePartitionDelimiter;
        }

        public final void setDatePartitionDelimiter(String datePartitionDelimiter) {
            this.datePartitionDelimiter = datePartitionDelimiter;
        }

        @Override
        @Transient
        public final Builder datePartitionDelimiter(String datePartitionDelimiter) {
            this.datePartitionDelimiter = datePartitionDelimiter;
            return this;
        }

        @Override
        @Transient
        public final Builder datePartitionDelimiter(DatePartitionDelimiterValue datePartitionDelimiter) {
            this.datePartitionDelimiter(datePartitionDelimiter == null ? null : datePartitionDelimiter.toString());
            return this;
        }

        public final Boolean getUseCsvNoSupValue() {
            return useCsvNoSupValue;
        }

        public final void setUseCsvNoSupValue(Boolean useCsvNoSupValue) {
            this.useCsvNoSupValue = useCsvNoSupValue;
        }

        @Override
        @Transient
        public final Builder useCsvNoSupValue(Boolean useCsvNoSupValue) {
            this.useCsvNoSupValue = useCsvNoSupValue;
            return this;
        }

        public final String getCsvNoSupValue() {
            return csvNoSupValue;
        }

        public final void setCsvNoSupValue(String csvNoSupValue) {
            this.csvNoSupValue = csvNoSupValue;
        }

        @Override
        @Transient
        public final Builder csvNoSupValue(String csvNoSupValue) {
            this.csvNoSupValue = csvNoSupValue;
            return this;
        }

        public final Boolean getPreserveTransactions() {
            return preserveTransactions;
        }

        public final void setPreserveTransactions(Boolean preserveTransactions) {
            this.preserveTransactions = preserveTransactions;
        }

        @Override
        @Transient
        public final Builder preserveTransactions(Boolean preserveTransactions) {
            this.preserveTransactions = preserveTransactions;
            return this;
        }

        public final String getCdcPath() {
            return cdcPath;
        }

        public final void setCdcPath(String cdcPath) {
            this.cdcPath = cdcPath;
        }

        @Override
        @Transient
        public final Builder cdcPath(String cdcPath) {
            this.cdcPath = cdcPath;
            return this;
        }

        public final String getCannedAclForObjects() {
            return cannedAclForObjects;
        }

        public final void setCannedAclForObjects(String cannedAclForObjects) {
            this.cannedAclForObjects = cannedAclForObjects;
        }

        @Override
        @Transient
        public final Builder cannedAclForObjects(String cannedAclForObjects) {
            this.cannedAclForObjects = cannedAclForObjects;
            return this;
        }

        @Override
        @Transient
        public final Builder cannedAclForObjects(CannedAclForObjectsValue cannedAclForObjects) {
            this.cannedAclForObjects(cannedAclForObjects == null ? null : cannedAclForObjects.toString());
            return this;
        }

        public final Boolean getAddColumnName() {
            return addColumnName;
        }

        public final void setAddColumnName(Boolean addColumnName) {
            this.addColumnName = addColumnName;
        }

        @Override
        @Transient
        public final Builder addColumnName(Boolean addColumnName) {
            this.addColumnName = addColumnName;
            return this;
        }

        public final Integer getCdcMaxBatchInterval() {
            return cdcMaxBatchInterval;
        }

        public final void setCdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            this.cdcMaxBatchInterval = cdcMaxBatchInterval;
        }

        @Override
        @Transient
        public final Builder cdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            this.cdcMaxBatchInterval = cdcMaxBatchInterval;
            return this;
        }

        public final Integer getCdcMinFileSize() {
            return cdcMinFileSize;
        }

        public final void setCdcMinFileSize(Integer cdcMinFileSize) {
            this.cdcMinFileSize = cdcMinFileSize;
        }

        @Override
        @Transient
        public final Builder cdcMinFileSize(Integer cdcMinFileSize) {
            this.cdcMinFileSize = cdcMinFileSize;
            return this;
        }

        public final String getCsvNullValue() {
            return csvNullValue;
        }

        public final void setCsvNullValue(String csvNullValue) {
            this.csvNullValue = csvNullValue;
        }

        @Override
        @Transient
        public final Builder csvNullValue(String csvNullValue) {
            this.csvNullValue = csvNullValue;
            return this;
        }

        public final Integer getIgnoreHeaderRows() {
            return ignoreHeaderRows;
        }

        public final void setIgnoreHeaderRows(Integer ignoreHeaderRows) {
            this.ignoreHeaderRows = ignoreHeaderRows;
        }

        @Override
        @Transient
        public final Builder ignoreHeaderRows(Integer ignoreHeaderRows) {
            this.ignoreHeaderRows = ignoreHeaderRows;
            return this;
        }

        public final Integer getMaxFileSize() {
            return maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        @Transient
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final Boolean getRfc4180() {
            return rfc4180;
        }

        public final void setRfc4180(Boolean rfc4180) {
            this.rfc4180 = rfc4180;
        }

        @Override
        @Transient
        public final Builder rfc4180(Boolean rfc4180) {
            this.rfc4180 = rfc4180;
            return this;
        }

        @Override
        public S3Settings build() {
            return new S3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
