/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReplicationTaskAssessmentRunRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartReplicationTaskAssessmentRunRequest.Builder, StartReplicationTaskAssessmentRunRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(StartReplicationTaskAssessmentRunRequest::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(StartReplicationTaskAssessmentRunRequest::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationBucket").getter(getter(StartReplicationTaskAssessmentRunRequest::resultLocationBucket))
            .setter(setter(Builder::resultLocationBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationBucket").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationFolder").getter(getter(StartReplicationTaskAssessmentRunRequest::resultLocationFolder))
            .setter(setter(Builder::resultLocationFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationFolder").build())
            .build();

    private static final SdkField<String> RESULT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultEncryptionMode").getter(getter(StartReplicationTaskAssessmentRunRequest::resultEncryptionMode))
            .setter(setter(Builder::resultEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultEncryptionMode").build())
            .build();

    private static final SdkField<String> RESULT_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultKmsKeyArn").getter(getter(StartReplicationTaskAssessmentRunRequest::resultKmsKeyArn))
            .setter(setter(Builder::resultKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultKmsKeyArn").build()).build();

    private static final SdkField<String> ASSESSMENT_RUN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentRunName").getter(getter(StartReplicationTaskAssessmentRunRequest::assessmentRunName))
            .setter(setter(Builder::assessmentRunName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentRunName").build()).build();

    private static final SdkField<List<String>> INCLUDE_ONLY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeOnly")
            .getter(getter(StartReplicationTaskAssessmentRunRequest::includeOnly))
            .setter(setter(Builder::includeOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOnly").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Exclude")
            .getter(getter(StartReplicationTaskAssessmentRunRequest::exclude))
            .setter(setter(Builder::exclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD,
                    RESULT_LOCATION_BUCKET_FIELD, RESULT_LOCATION_FOLDER_FIELD, RESULT_ENCRYPTION_MODE_FIELD,
                    RESULT_KMS_KEY_ARN_FIELD, ASSESSMENT_RUN_NAME_FIELD, INCLUDE_ONLY_FIELD, EXCLUDE_FIELD));

    private final String replicationTaskArn;

    private final String serviceAccessRoleArn;

    private final String resultLocationBucket;

    private final String resultLocationFolder;

    private final String resultEncryptionMode;

    private final String resultKmsKeyArn;

    private final String assessmentRunName;

    private final List<String> includeOnly;

    private final List<String> exclude;

    private StartReplicationTaskAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.resultLocationBucket = builder.resultLocationBucket;
        this.resultLocationFolder = builder.resultLocationFolder;
        this.resultEncryptionMode = builder.resultEncryptionMode;
        this.resultKmsKeyArn = builder.resultKmsKeyArn;
        this.assessmentRunName = builder.assessmentRunName;
        this.includeOnly = builder.includeOnly;
        this.exclude = builder.exclude;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you want to
     * start.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you
     *         want to start.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code>
     * action.
     * </p>
     * 
     * @return ARN of the service role needed to start the assessment run. The role must allow the
     *         <code>iam:PassRole</code> action.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Amazon S3 bucket where you want DMS to store the results of this assessment run.
     * </p>
     * 
     * @return Amazon S3 bucket where you want DMS to store the results of this assessment run.
     */
    public final String resultLocationBucket() {
        return resultLocationBucket;
    }

    /**
     * <p>
     * Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.
     * </p>
     * 
     * @return Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.
     */
    public final String resultLocationFolder() {
        return resultLocationFolder;
    }

    /**
     * <p>
     * Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify this
     * request parameter, DMS stores the assessment run results without encryption. You can specify one of the options
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS
     * encryption key that you specify or the default KMS encryption key that DMS provides.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify
     *         this request parameter, DMS stores the assessment run results without encryption. You can specify one of
     *         the options following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom
     *         KMS encryption key that you specify or the default KMS encryption key that DMS provides.
     *         </p>
     *         </li>
     */
    public final String resultEncryptionMode() {
        return resultEncryptionMode;
    }

    /**
     * <p>
     * ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
     * <code>"SSE_KMS</code>".
     * </p>
     * 
     * @return ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
     *         <code>"SSE_KMS</code>".
     */
    public final String resultKmsKeyArn() {
        return resultKmsKeyArn;
    }

    /**
     * <p>
     * Unique name to identify the assessment run.
     * </p>
     * 
     * @return Unique name to identify the assessment run.
     */
    public final String assessmentRunName() {
        return assessmentRunName;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeOnly property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeOnly() {
        return includeOnly != null && !(includeOnly instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Space-separated list of names for specific individual assessments that you want to include. These names come from
     * the default list of individual assessments that DMS supports for the associated migration task. This task is
     * specified by <code>ReplicationTaskArn</code>.
     * </p>
     * <note>
     * <p>
     * You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the API
     * operation.
     * </p>
     * <p>
     * To identify the names of the default individual assessments that DMS supports for the associated migration task,
     * run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
     * <code>ReplicationTaskArn</code> request parameter.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeOnly} method.
     * </p>
     * 
     * @return Space-separated list of names for specific individual assessments that you want to include. These names
     *         come from the default list of individual assessments that DMS supports for the associated migration task.
     *         This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
     *         <p>
     *         You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in
     *         the API operation.
     *         </p>
     *         <p>
     *         To identify the names of the default individual assessments that DMS supports for the associated
     *         migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
     *         <code>ReplicationTaskArn</code> request parameter.
     *         </p>
     */
    public final List<String> includeOnly() {
        return includeOnly;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exclude property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExclude() {
        return exclude != null && !(exclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Space-separated list of names for specific individual assessments that you want to exclude. These names come from
     * the default list of individual assessments that DMS supports for the associated migration task. This task is
     * specified by <code>ReplicationTaskArn</code>.
     * </p>
     * <note>
     * <p>
     * You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the API
     * operation.
     * </p>
     * <p>
     * To identify the names of the default individual assessments that DMS supports for the associated migration task,
     * run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
     * <code>ReplicationTaskArn</code> request parameter.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclude} method.
     * </p>
     * 
     * @return Space-separated list of names for specific individual assessments that you want to exclude. These names
     *         come from the default list of individual assessments that DMS supports for the associated migration task.
     *         This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
     *         <p>
     *         You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in
     *         the API operation.
     *         </p>
     *         <p>
     *         To identify the names of the default individual assessments that DMS supports for the associated
     *         migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
     *         <code>ReplicationTaskArn</code> request parameter.
     *         </p>
     */
    public final List<String> exclude() {
        return exclude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationFolder());
        hashCode = 31 * hashCode + Objects.hashCode(resultEncryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(resultKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeOnly() ? includeOnly() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclude() ? exclude() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationTaskAssessmentRunRequest)) {
            return false;
        }
        StartReplicationTaskAssessmentRunRequest other = (StartReplicationTaskAssessmentRunRequest) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(resultLocationBucket(), other.resultLocationBucket())
                && Objects.equals(resultLocationFolder(), other.resultLocationFolder())
                && Objects.equals(resultEncryptionMode(), other.resultEncryptionMode())
                && Objects.equals(resultKmsKeyArn(), other.resultKmsKeyArn())
                && Objects.equals(assessmentRunName(), other.assessmentRunName()) && hasIncludeOnly() == other.hasIncludeOnly()
                && Objects.equals(includeOnly(), other.includeOnly()) && hasExclude() == other.hasExclude()
                && Objects.equals(exclude(), other.exclude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReplicationTaskAssessmentRunRequest").add("ReplicationTaskArn", replicationTaskArn())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn()).add("ResultLocationBucket", resultLocationBucket())
                .add("ResultLocationFolder", resultLocationFolder()).add("ResultEncryptionMode", resultEncryptionMode())
                .add("ResultKmsKeyArn", resultKmsKeyArn()).add("AssessmentRunName", assessmentRunName())
                .add("IncludeOnly", hasIncludeOnly() ? includeOnly() : null).add("Exclude", hasExclude() ? exclude() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ResultLocationBucket":
            return Optional.ofNullable(clazz.cast(resultLocationBucket()));
        case "ResultLocationFolder":
            return Optional.ofNullable(clazz.cast(resultLocationFolder()));
        case "ResultEncryptionMode":
            return Optional.ofNullable(clazz.cast(resultEncryptionMode()));
        case "ResultKmsKeyArn":
            return Optional.ofNullable(clazz.cast(resultKmsKeyArn()));
        case "AssessmentRunName":
            return Optional.ofNullable(clazz.cast(assessmentRunName()));
        case "IncludeOnly":
            return Optional.ofNullable(clazz.cast(includeOnly()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationTaskAssessmentRunRequest, T> g) {
        return obj -> g.apply((StartReplicationTaskAssessmentRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartReplicationTaskAssessmentRunRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you
         * want to start.
         * </p>
         * 
         * @param replicationTaskArn
         *        Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that
         *        you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code>
         * action.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        ARN of the service role needed to start the assessment run. The role must allow the
         *        <code>iam:PassRole</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Amazon S3 bucket where you want DMS to store the results of this assessment run.
         * </p>
         * 
         * @param resultLocationBucket
         *        Amazon S3 bucket where you want DMS to store the results of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationBucket(String resultLocationBucket);

        /**
         * <p>
         * Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.
         * </p>
         * 
         * @param resultLocationFolder
         *        Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationFolder(String resultLocationFolder);

        /**
         * <p>
         * Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify this
         * request parameter, DMS stores the assessment run results without encryption. You can specify one of the
         * options following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS
         * encryption key that you specify or the default KMS encryption key that DMS provides.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resultEncryptionMode
         *        Encryption mode that you can specify to encrypt the results of this assessment run. If you don't
         *        specify this request parameter, DMS stores the assessment run results without encryption. You can
         *        specify one of the options following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a
         *        custom KMS encryption key that you specify or the default KMS encryption key that DMS provides.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultEncryptionMode(String resultEncryptionMode);

        /**
         * <p>
         * ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
         * <code>"SSE_KMS</code>".
         * </p>
         * 
         * @param resultKmsKeyArn
         *        ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
         *        <code>"SSE_KMS</code>".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultKmsKeyArn(String resultKmsKeyArn);

        /**
         * <p>
         * Unique name to identify the assessment run.
         * </p>
         * 
         * @param assessmentRunName
         *        Unique name to identify the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunName(String assessmentRunName);

        /**
         * <p>
         * Space-separated list of names for specific individual assessments that you want to include. These names come
         * from the default list of individual assessments that DMS supports for the associated migration task. This
         * task is specified by <code>ReplicationTaskArn</code>.
         * </p>
         * <note>
         * <p>
         * You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the
         * API operation.
         * </p>
         * <p>
         * To identify the names of the default individual assessments that DMS supports for the associated migration
         * task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         * <code>ReplicationTaskArn</code> request parameter.
         * </p>
         * </note>
         * 
         * @param includeOnly
         *        Space-separated list of names for specific individual assessments that you want to include. These
         *        names come from the default list of individual assessments that DMS supports for the associated
         *        migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
         *        <p>
         *        You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in
         *        the API operation.
         *        </p>
         *        <p>
         *        To identify the names of the default individual assessments that DMS supports for the associated
         *        migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         *        <code>ReplicationTaskArn</code> request parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnly(Collection<String> includeOnly);

        /**
         * <p>
         * Space-separated list of names for specific individual assessments that you want to include. These names come
         * from the default list of individual assessments that DMS supports for the associated migration task. This
         * task is specified by <code>ReplicationTaskArn</code>.
         * </p>
         * <note>
         * <p>
         * You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the
         * API operation.
         * </p>
         * <p>
         * To identify the names of the default individual assessments that DMS supports for the associated migration
         * task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         * <code>ReplicationTaskArn</code> request parameter.
         * </p>
         * </note>
         * 
         * @param includeOnly
         *        Space-separated list of names for specific individual assessments that you want to include. These
         *        names come from the default list of individual assessments that DMS supports for the associated
         *        migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
         *        <p>
         *        You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in
         *        the API operation.
         *        </p>
         *        <p>
         *        To identify the names of the default individual assessments that DMS supports for the associated
         *        migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         *        <code>ReplicationTaskArn</code> request parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnly(String... includeOnly);

        /**
         * <p>
         * Space-separated list of names for specific individual assessments that you want to exclude. These names come
         * from the default list of individual assessments that DMS supports for the associated migration task. This
         * task is specified by <code>ReplicationTaskArn</code>.
         * </p>
         * <note>
         * <p>
         * You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the
         * API operation.
         * </p>
         * <p>
         * To identify the names of the default individual assessments that DMS supports for the associated migration
         * task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         * <code>ReplicationTaskArn</code> request parameter.
         * </p>
         * </note>
         * 
         * @param exclude
         *        Space-separated list of names for specific individual assessments that you want to exclude. These
         *        names come from the default list of individual assessments that DMS supports for the associated
         *        migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
         *        <p>
         *        You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in
         *        the API operation.
         *        </p>
         *        <p>
         *        To identify the names of the default individual assessments that DMS supports for the associated
         *        migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         *        <code>ReplicationTaskArn</code> request parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(Collection<String> exclude);

        /**
         * <p>
         * Space-separated list of names for specific individual assessments that you want to exclude. These names come
         * from the default list of individual assessments that DMS supports for the associated migration task. This
         * task is specified by <code>ReplicationTaskArn</code>.
         * </p>
         * <note>
         * <p>
         * You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the
         * API operation.
         * </p>
         * <p>
         * To identify the names of the default individual assessments that DMS supports for the associated migration
         * task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         * <code>ReplicationTaskArn</code> request parameter.
         * </p>
         * </note>
         * 
         * @param exclude
         *        Space-separated list of names for specific individual assessments that you want to exclude. These
         *        names come from the default list of individual assessments that DMS supports for the associated
         *        migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
         *        <p>
         *        You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in
         *        the API operation.
         *        </p>
         *        <p>
         *        To identify the names of the default individual assessments that DMS supports for the associated
         *        migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own
         *        <code>ReplicationTaskArn</code> request parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(String... exclude);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private String serviceAccessRoleArn;

        private String resultLocationBucket;

        private String resultLocationFolder;

        private String resultEncryptionMode;

        private String resultKmsKeyArn;

        private String assessmentRunName;

        private List<String> includeOnly = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclude = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationTaskAssessmentRunRequest model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            resultLocationBucket(model.resultLocationBucket);
            resultLocationFolder(model.resultLocationFolder);
            resultEncryptionMode(model.resultEncryptionMode);
            resultKmsKeyArn(model.resultKmsKeyArn);
            assessmentRunName(model.assessmentRunName);
            includeOnly(model.includeOnly);
            exclude(model.exclude);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getResultLocationBucket() {
            return resultLocationBucket;
        }

        public final void setResultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
        }

        @Override
        @Transient
        public final Builder resultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
            return this;
        }

        public final String getResultLocationFolder() {
            return resultLocationFolder;
        }

        public final void setResultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
        }

        @Override
        @Transient
        public final Builder resultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
            return this;
        }

        public final String getResultEncryptionMode() {
            return resultEncryptionMode;
        }

        public final void setResultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
        }

        @Override
        @Transient
        public final Builder resultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
            return this;
        }

        public final String getResultKmsKeyArn() {
            return resultKmsKeyArn;
        }

        public final void setResultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
        }

        @Override
        @Transient
        public final Builder resultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
            return this;
        }

        public final String getAssessmentRunName() {
            return assessmentRunName;
        }

        public final void setAssessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
        }

        @Override
        @Transient
        public final Builder assessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
            return this;
        }

        public final Collection<String> getIncludeOnly() {
            if (includeOnly instanceof SdkAutoConstructList) {
                return null;
            }
            return includeOnly;
        }

        public final void setIncludeOnly(Collection<String> includeOnly) {
            this.includeOnly = IncludeTestListCopier.copy(includeOnly);
        }

        @Override
        @Transient
        public final Builder includeOnly(Collection<String> includeOnly) {
            this.includeOnly = IncludeTestListCopier.copy(includeOnly);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeOnly(String... includeOnly) {
            includeOnly(Arrays.asList(includeOnly));
            return this;
        }

        public final Collection<String> getExclude() {
            if (exclude instanceof SdkAutoConstructList) {
                return null;
            }
            return exclude;
        }

        public final void setExclude(Collection<String> exclude) {
            this.exclude = ExcludeTestListCopier.copy(exclude);
        }

        @Override
        @Transient
        public final Builder exclude(Collection<String> exclude) {
            this.exclude = ExcludeTestListCopier.copy(exclude);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exclude(String... exclude) {
            exclude(Arrays.asList(exclude));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationTaskAssessmentRunRequest build() {
            return new StartReplicationTaskAssessmentRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
