/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelReplicationTaskAssessmentRunResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CancelReplicationTaskAssessmentRunResponse.Builder, CancelReplicationTaskAssessmentRunResponse> {
    private static final SdkField<ReplicationTaskAssessmentRun> REPLICATION_TASK_ASSESSMENT_RUN_FIELD = SdkField
            .<ReplicationTaskAssessmentRun> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicationTaskAssessmentRun")
            .getter(getter(CancelReplicationTaskAssessmentRunResponse::replicationTaskAssessmentRun))
            .setter(setter(Builder::replicationTaskAssessmentRun))
            .constructor(ReplicationTaskAssessmentRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentRun")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REPLICATION_TASK_ASSESSMENT_RUN_FIELD));

    private final ReplicationTaskAssessmentRun replicationTaskAssessmentRun;

    private CancelReplicationTaskAssessmentRunResponse(BuilderImpl builder) {
        super(builder);
        this.replicationTaskAssessmentRun = builder.replicationTaskAssessmentRun;
    }

    /**
     * <p>
     * The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.
     * </p>
     * 
     * @return The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.
     */
    public final ReplicationTaskAssessmentRun replicationTaskAssessmentRun() {
        return replicationTaskAssessmentRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskAssessmentRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReplicationTaskAssessmentRunResponse)) {
            return false;
        }
        CancelReplicationTaskAssessmentRunResponse other = (CancelReplicationTaskAssessmentRunResponse) obj;
        return Objects.equals(replicationTaskAssessmentRun(), other.replicationTaskAssessmentRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelReplicationTaskAssessmentRunResponse")
                .add("ReplicationTaskAssessmentRun", replicationTaskAssessmentRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskAssessmentRun":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelReplicationTaskAssessmentRunResponse, T> g) {
        return obj -> g.apply((CancelReplicationTaskAssessmentRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelReplicationTaskAssessmentRunResponse> {
        /**
         * <p>
         * The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.
         * </p>
         * 
         * @param replicationTaskAssessmentRun
         *        The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRun(ReplicationTaskAssessmentRun replicationTaskAssessmentRun);

        /**
         * <p>
         * The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationTaskAssessmentRun.Builder}
         * avoiding the need to create one manually via {@link ReplicationTaskAssessmentRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationTaskAssessmentRun.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationTaskAssessmentRun(ReplicationTaskAssessmentRun)}.
         * 
         * @param replicationTaskAssessmentRun
         *        a consumer that will call methods on {@link ReplicationTaskAssessmentRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTaskAssessmentRun(ReplicationTaskAssessmentRun)
         */
        default Builder replicationTaskAssessmentRun(Consumer<ReplicationTaskAssessmentRun.Builder> replicationTaskAssessmentRun) {
            return replicationTaskAssessmentRun(ReplicationTaskAssessmentRun.builder()
                    .applyMutation(replicationTaskAssessmentRun).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private ReplicationTaskAssessmentRun replicationTaskAssessmentRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReplicationTaskAssessmentRunResponse model) {
            super(model);
            replicationTaskAssessmentRun(model.replicationTaskAssessmentRun);
        }

        public final ReplicationTaskAssessmentRun.Builder getReplicationTaskAssessmentRun() {
            return replicationTaskAssessmentRun != null ? replicationTaskAssessmentRun.toBuilder() : null;
        }

        public final void setReplicationTaskAssessmentRun(ReplicationTaskAssessmentRun.BuilderImpl replicationTaskAssessmentRun) {
            this.replicationTaskAssessmentRun = replicationTaskAssessmentRun != null ? replicationTaskAssessmentRun.build()
                    : null;
        }

        @Override
        public final Builder replicationTaskAssessmentRun(ReplicationTaskAssessmentRun replicationTaskAssessmentRun) {
            this.replicationTaskAssessmentRun = replicationTaskAssessmentRun;
            return this;
        }

        @Override
        public CancelReplicationTaskAssessmentRunResponse build() {
            return new CancelReplicationTaskAssessmentRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
