/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFleetAdvisorDatabasesRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DeleteFleetAdvisorDatabasesRequest.Builder, DeleteFleetAdvisorDatabasesRequest> {
    private static final SdkField<List<String>> DATABASE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DatabaseIds")
            .getter(getter(DeleteFleetAdvisorDatabasesRequest::databaseIds))
            .setter(setter(Builder::databaseIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_IDS_FIELD));

    private final List<String> databaseIds;

    private DeleteFleetAdvisorDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.databaseIds = builder.databaseIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatabaseIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatabaseIds() {
        return databaseIds != null && !(databaseIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Fleet Advisor collector databases to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabaseIds} method.
     * </p>
     * 
     * @return The IDs of the Fleet Advisor collector databases to delete.
     */
    public final List<String> databaseIds() {
        return databaseIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabaseIds() ? databaseIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetAdvisorDatabasesRequest)) {
            return false;
        }
        DeleteFleetAdvisorDatabasesRequest other = (DeleteFleetAdvisorDatabasesRequest) obj;
        return hasDatabaseIds() == other.hasDatabaseIds() && Objects.equals(databaseIds(), other.databaseIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFleetAdvisorDatabasesRequest").add("DatabaseIds", hasDatabaseIds() ? databaseIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseIds":
            return Optional.ofNullable(clazz.cast(databaseIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetAdvisorDatabasesRequest, T> g) {
        return obj -> g.apply((DeleteFleetAdvisorDatabasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFleetAdvisorDatabasesRequest> {
        /**
         * <p>
         * The IDs of the Fleet Advisor collector databases to delete.
         * </p>
         * 
         * @param databaseIds
         *        The IDs of the Fleet Advisor collector databases to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseIds(Collection<String> databaseIds);

        /**
         * <p>
         * The IDs of the Fleet Advisor collector databases to delete.
         * </p>
         * 
         * @param databaseIds
         *        The IDs of the Fleet Advisor collector databases to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseIds(String... databaseIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private List<String> databaseIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetAdvisorDatabasesRequest model) {
            super(model);
            databaseIds(model.databaseIds);
        }

        public final Collection<String> getDatabaseIds() {
            if (databaseIds instanceof SdkAutoConstructList) {
                return null;
            }
            return databaseIds;
        }

        public final void setDatabaseIds(Collection<String> databaseIds) {
            this.databaseIds = StringListCopier.copy(databaseIds);
        }

        @Override
        public final Builder databaseIds(Collection<String> databaseIds) {
            this.databaseIds = StringListCopier.copy(databaseIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseIds(String... databaseIds) {
            databaseIds(Arrays.asList(databaseIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFleetAdvisorDatabasesRequest build() {
            return new DeleteFleetAdvisorDatabasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
