/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecastquery;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest;
import software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse;
import software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest;
import software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse;

/**
 * Service client for accessing Amazon Forecast Query Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Provides APIs for creating and managing Amazon Forecast resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ForecastqueryAsyncClient extends SdkClient {
    String SERVICE_NAME = "forecast";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "forecastquery";

    /**
     * <p>
     * Retrieves a forecast for a single item, filtered by the supplied criteria.
     * </p>
     * <p>
     * The criteria is a key-value pair. The key is either <code>item_id</code> (or the equivalent non-timestamp,
     * non-target field) from the <code>TARGET_TIME_SERIES</code> dataset, or one of the forecast dimensions specified
     * as part of the <code>FeaturizationConfig</code> object.
     * </p>
     * <p>
     * By default, <code>QueryForecast</code> returns the complete date range for the filtered forecast. You can request
     * a specific date range.
     * </p>
     * <p>
     * To get the full forecast, use the <a
     * href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
     * >CreateForecastExportJob</a> operation.
     * </p>
     * <note>
     * <p>
     * The forecasts generated by Amazon Forecast are in the same timezone as the dataset that was used to create the
     * predictor.
     * </p>
     * </note>
     *
     * @param queryForecastRequest
     * @return A Java Future containing the result of the QueryForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException We can't find that resource. Check the information that you've provided and
     *         try again.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidInputException The value is invalid or is too long.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>InvalidNextTokenException The token is not valid. Tokens expire after 24 hours.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ForecastqueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ForecastqueryAsyncClient.QueryForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecastquery-2018-06-26/QueryForecast" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<QueryForecastResponse> queryForecast(QueryForecastRequest queryForecastRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a forecast for a single item, filtered by the supplied criteria.
     * </p>
     * <p>
     * The criteria is a key-value pair. The key is either <code>item_id</code> (or the equivalent non-timestamp,
     * non-target field) from the <code>TARGET_TIME_SERIES</code> dataset, or one of the forecast dimensions specified
     * as part of the <code>FeaturizationConfig</code> object.
     * </p>
     * <p>
     * By default, <code>QueryForecast</code> returns the complete date range for the filtered forecast. You can request
     * a specific date range.
     * </p>
     * <p>
     * To get the full forecast, use the <a
     * href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
     * >CreateForecastExportJob</a> operation.
     * </p>
     * <note>
     * <p>
     * The forecasts generated by Amazon Forecast are in the same timezone as the dataset that was used to create the
     * predictor.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryForecastRequest.Builder} avoiding the need to
     * create one manually via {@link QueryForecastRequest#builder()}
     * </p>
     *
     * @param queryForecastRequest
     *        A {@link Consumer} that will call methods on {@link QueryForecastRequest.Builder} to create a request.
     * @return A Java Future containing the result of the QueryForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException We can't find that resource. Check the information that you've provided and
     *         try again.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidInputException The value is invalid or is too long.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>InvalidNextTokenException The token is not valid. Tokens expire after 24 hours.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ForecastqueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ForecastqueryAsyncClient.QueryForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecastquery-2018-06-26/QueryForecast" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<QueryForecastResponse> queryForecast(Consumer<QueryForecastRequest.Builder> queryForecastRequest) {
        return queryForecast(QueryForecastRequest.builder().applyMutation(queryForecastRequest).build());
    }

    /**
     * <p>
     * Retrieves a what-if forecast.
     * </p>
     *
     * @param queryWhatIfForecastRequest
     * @return A Java Future containing the result of the QueryWhatIfForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException We can't find that resource. Check the information that you've provided and
     *         try again.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidInputException The value is invalid or is too long.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>InvalidNextTokenException The token is not valid. Tokens expire after 24 hours.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ForecastqueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ForecastqueryAsyncClient.QueryWhatIfForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecastquery-2018-06-26/QueryWhatIfForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryWhatIfForecastResponse> queryWhatIfForecast(
            QueryWhatIfForecastRequest queryWhatIfForecastRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a what-if forecast.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryWhatIfForecastRequest.Builder} avoiding the
     * need to create one manually via {@link QueryWhatIfForecastRequest#builder()}
     * </p>
     *
     * @param queryWhatIfForecastRequest
     *        A {@link Consumer} that will call methods on {@link QueryWhatIfForecastRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the QueryWhatIfForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException We can't find that resource. Check the information that you've provided and
     *         try again.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidInputException The value is invalid or is too long.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>InvalidNextTokenException The token is not valid. Tokens expire after 24 hours.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ForecastqueryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ForecastqueryAsyncClient.QueryWhatIfForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecastquery-2018-06-26/QueryWhatIfForecast"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryWhatIfForecastResponse> queryWhatIfForecast(
            Consumer<QueryWhatIfForecastRequest.Builder> queryWhatIfForecastRequest) {
        return queryWhatIfForecast(QueryWhatIfForecastRequest.builder().applyMutation(queryWhatIfForecastRequest).build());
    }

    /**
     * Create a {@link ForecastqueryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ForecastqueryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ForecastqueryAsyncClient}.
     */
    static ForecastqueryAsyncClientBuilder builder() {
        return new DefaultForecastqueryAsyncClientBuilder();
    }
}
