/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria by which the behavior is determined to be normal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BehaviorCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<BehaviorCriteria.Builder, BehaviorCriteria> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparisonOperator").getter(getter(BehaviorCriteria::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build())
            .build();

    private static final SdkField<MetricValue> VALUE_FIELD = SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(BehaviorCriteria::value)).setter(setter(Builder::value))
            .constructor(MetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationSeconds").getter(getter(BehaviorCriteria::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<Integer> CONSECUTIVE_DATAPOINTS_TO_ALARM_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("consecutiveDatapointsToAlarm")
            .getter(getter(BehaviorCriteria::consecutiveDatapointsToAlarm))
            .setter(setter(Builder::consecutiveDatapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consecutiveDatapointsToAlarm")
                    .build()).build();

    private static final SdkField<Integer> CONSECUTIVE_DATAPOINTS_TO_CLEAR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("consecutiveDatapointsToClear")
            .getter(getter(BehaviorCriteria::consecutiveDatapointsToClear))
            .setter(setter(Builder::consecutiveDatapointsToClear))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consecutiveDatapointsToClear")
                    .build()).build();

    private static final SdkField<StatisticalThreshold> STATISTICAL_THRESHOLD_FIELD = SdkField
            .<StatisticalThreshold> builder(MarshallingType.SDK_POJO).memberName("statisticalThreshold")
            .getter(getter(BehaviorCriteria::statisticalThreshold)).setter(setter(Builder::statisticalThreshold))
            .constructor(StatisticalThreshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticalThreshold").build())
            .build();

    private static final SdkField<MachineLearningDetectionConfig> ML_DETECTION_CONFIG_FIELD = SdkField
            .<MachineLearningDetectionConfig> builder(MarshallingType.SDK_POJO).memberName("mlDetectionConfig")
            .getter(getter(BehaviorCriteria::mlDetectionConfig)).setter(setter(Builder::mlDetectionConfig))
            .constructor(MachineLearningDetectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlDetectionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD,
            VALUE_FIELD, DURATION_SECONDS_FIELD, CONSECUTIVE_DATAPOINTS_TO_ALARM_FIELD, CONSECUTIVE_DATAPOINTS_TO_CLEAR_FIELD,
            STATISTICAL_THRESHOLD_FIELD, ML_DETECTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparisonOperator;

    private final MetricValue value;

    private final Integer durationSeconds;

    private final Integer consecutiveDatapointsToAlarm;

    private final Integer consecutiveDatapointsToClear;

    private final StatisticalThreshold statisticalThreshold;

    private final MachineLearningDetectionConfig mlDetectionConfig;

    private BehaviorCriteria(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.value = builder.value;
        this.durationSeconds = builder.durationSeconds;
        this.consecutiveDatapointsToAlarm = builder.consecutiveDatapointsToAlarm;
        this.consecutiveDatapointsToClear = builder.consecutiveDatapointsToClear;
        this.statisticalThreshold = builder.statisticalThreshold;
        this.mlDetectionConfig = builder.mlDetectionConfig;
    }

    /**
     * <p>
     * The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
     * <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and
     * <code>greater-than-equals</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
     *         <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>,
     *         and <code>greater-than-equals</code>
     *         </p>
     *         </li>
     * @see ComparisonOperator
     */
    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
     * <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and
     * <code>greater-than-equals</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
     *         <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>,
     *         and <code>greater-than-equals</code>
     *         </p>
     *         </li>
     * @see ComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * The value to be compared with the <code>metric</code>.
     * </p>
     * 
     * @return The value to be compared with the <code>metric</code>.
     */
    public final MetricValue value() {
        return value;
    }

    /**
     * <p>
     * Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a time
     * dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a <code>statisticalThreshhold</code> metric
     * comparison, measurements from all devices are accumulated over this time duration before being used to calculate
     * percentiles, and later, measurements from an individual device are also accumulated over this time duration
     * before being given a percentile rank. Cannot be used with list-based metric datatypes.
     * </p>
     * 
     * @return Use this to specify the time duration over which the behavior is evaluated, for those criteria that have
     *         a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a <code>statisticalThreshhold</code>
     *         metric comparison, measurements from all devices are accumulated over this time duration before being
     *         used to calculate percentiles, and later, measurements from an individual device are also accumulated
     *         over this time duration before being given a percentile rank. Cannot be used with list-based metric
     *         datatypes.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs.
     * If not specified, the default is 1.
     * </p>
     * 
     * @return If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm
     *         occurs. If not specified, the default is 1.
     */
    public final Integer consecutiveDatapointsToAlarm() {
        return consecutiveDatapointsToAlarm;
    }

    /**
     * <p>
     * If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified
     * number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.
     * </p>
     * 
     * @return If an alarm has occurred and the offending device is no longer in violation of the behavior for the
     *         specified number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.
     */
    public final Integer consecutiveDatapointsToClear() {
        return consecutiveDatapointsToClear;
    }

    /**
     * <p>
     * A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in
     * compliance or in violation of the behavior.
     * </p>
     * 
     * @return A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to
     *         be in compliance or in violation of the behavior.
     */
    public final StatisticalThreshold statisticalThreshold() {
        return statisticalThreshold;
    }

    /**
     * <p>
     * The configuration of an ML Detect
     * </p>
     * 
     * @return The configuration of an ML Detect
     */
    public final MachineLearningDetectionConfig mlDetectionConfig() {
        return mlDetectionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(consecutiveDatapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(consecutiveDatapointsToClear());
        hashCode = 31 * hashCode + Objects.hashCode(statisticalThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(mlDetectionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BehaviorCriteria)) {
            return false;
        }
        BehaviorCriteria other = (BehaviorCriteria) obj;
        return Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(value(), other.value()) && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(consecutiveDatapointsToAlarm(), other.consecutiveDatapointsToAlarm())
                && Objects.equals(consecutiveDatapointsToClear(), other.consecutiveDatapointsToClear())
                && Objects.equals(statisticalThreshold(), other.statisticalThreshold())
                && Objects.equals(mlDetectionConfig(), other.mlDetectionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BehaviorCriteria").add("ComparisonOperator", comparisonOperatorAsString()).add("Value", value())
                .add("DurationSeconds", durationSeconds()).add("ConsecutiveDatapointsToAlarm", consecutiveDatapointsToAlarm())
                .add("ConsecutiveDatapointsToClear", consecutiveDatapointsToClear())
                .add("StatisticalThreshold", statisticalThreshold()).add("MlDetectionConfig", mlDetectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "consecutiveDatapointsToAlarm":
            return Optional.ofNullable(clazz.cast(consecutiveDatapointsToAlarm()));
        case "consecutiveDatapointsToClear":
            return Optional.ofNullable(clazz.cast(consecutiveDatapointsToClear()));
        case "statisticalThreshold":
            return Optional.ofNullable(clazz.cast(statisticalThreshold()));
        case "mlDetectionConfig":
            return Optional.ofNullable(clazz.cast(mlDetectionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BehaviorCriteria, T> g) {
        return obj -> g.apply((BehaviorCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BehaviorCriteria> {
        /**
         * <p>
         * The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
         * <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and
         * <code>greater-than-equals</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparisonOperator
         *        The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
         *        <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>,
         *        and <code>greater-than-equals</code>
         *        </p>
         *        </li>
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
         * <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and
         * <code>greater-than-equals</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparisonOperator
         *        The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a
         *        <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>,
         *        and <code>greater-than-equals</code>
         *        </p>
         *        </li>
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * The value to be compared with the <code>metric</code>.
         * </p>
         * 
         * @param value
         *        The value to be compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MetricValue value);

        /**
         * <p>
         * The value to be compared with the <code>metric</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricValue.Builder} avoiding the need to create
         * one manually via {@link MetricValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(MetricValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MetricValue)
         */
        default Builder value(Consumer<MetricValue.Builder> value) {
            return value(MetricValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a
         * time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a <code>statisticalThreshhold</code> metric
         * comparison, measurements from all devices are accumulated over this time duration before being used to
         * calculate percentiles, and later, measurements from an individual device are also accumulated over this time
         * duration before being given a percentile rank. Cannot be used with list-based metric datatypes.
         * </p>
         * 
         * @param durationSeconds
         *        Use this to specify the time duration over which the behavior is evaluated, for those criteria that
         *        have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a
         *        <code>statisticalThreshhold</code> metric comparison, measurements from all devices are accumulated
         *        over this time duration before being used to calculate percentiles, and later, measurements from an
         *        individual device are also accumulated over this time duration before being given a percentile rank.
         *        Cannot be used with list-based metric datatypes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm
         * occurs. If not specified, the default is 1.
         * </p>
         * 
         * @param consecutiveDatapointsToAlarm
         *        If a device is in violation of the behavior for the specified number of consecutive datapoints, an
         *        alarm occurs. If not specified, the default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consecutiveDatapointsToAlarm(Integer consecutiveDatapointsToAlarm);

        /**
         * <p>
         * If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified
         * number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.
         * </p>
         * 
         * @param consecutiveDatapointsToClear
         *        If an alarm has occurred and the offending device is no longer in violation of the behavior for the
         *        specified number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consecutiveDatapointsToClear(Integer consecutiveDatapointsToClear);

        /**
         * <p>
         * A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in
         * compliance or in violation of the behavior.
         * </p>
         * 
         * @param statisticalThreshold
         *        A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined
         *        to be in compliance or in violation of the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticalThreshold(StatisticalThreshold statisticalThreshold);

        /**
         * <p>
         * A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in
         * compliance or in violation of the behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link StatisticalThreshold.Builder} avoiding the need
         * to create one manually via {@link StatisticalThreshold#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatisticalThreshold.Builder#build()} is called immediately and
         * its result is passed to {@link #statisticalThreshold(StatisticalThreshold)}.
         * 
         * @param statisticalThreshold
         *        a consumer that will call methods on {@link StatisticalThreshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statisticalThreshold(StatisticalThreshold)
         */
        default Builder statisticalThreshold(Consumer<StatisticalThreshold.Builder> statisticalThreshold) {
            return statisticalThreshold(StatisticalThreshold.builder().applyMutation(statisticalThreshold).build());
        }

        /**
         * <p>
         * The configuration of an ML Detect
         * </p>
         * 
         * @param mlDetectionConfig
         *        The configuration of an ML Detect
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlDetectionConfig(MachineLearningDetectionConfig mlDetectionConfig);

        /**
         * <p>
         * The configuration of an ML Detect
         * </p>
         * This is a convenience that creates an instance of the {@link MachineLearningDetectionConfig.Builder} avoiding
         * the need to create one manually via {@link MachineLearningDetectionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MachineLearningDetectionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #mlDetectionConfig(MachineLearningDetectionConfig)}.
         * 
         * @param mlDetectionConfig
         *        a consumer that will call methods on {@link MachineLearningDetectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlDetectionConfig(MachineLearningDetectionConfig)
         */
        default Builder mlDetectionConfig(Consumer<MachineLearningDetectionConfig.Builder> mlDetectionConfig) {
            return mlDetectionConfig(MachineLearningDetectionConfig.builder().applyMutation(mlDetectionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOperator;

        private MetricValue value;

        private Integer durationSeconds;

        private Integer consecutiveDatapointsToAlarm;

        private Integer consecutiveDatapointsToClear;

        private StatisticalThreshold statisticalThreshold;

        private MachineLearningDetectionConfig mlDetectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(BehaviorCriteria model) {
            comparisonOperator(model.comparisonOperator);
            value(model.value);
            durationSeconds(model.durationSeconds);
            consecutiveDatapointsToAlarm(model.consecutiveDatapointsToAlarm);
            consecutiveDatapointsToClear(model.consecutiveDatapointsToClear);
            statisticalThreshold(model.statisticalThreshold);
            mlDetectionConfig(model.mlDetectionConfig);
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final MetricValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MetricValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        @Transient
        public final Builder value(MetricValue value) {
            this.value = value;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        @Transient
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Integer getConsecutiveDatapointsToAlarm() {
            return consecutiveDatapointsToAlarm;
        }

        public final void setConsecutiveDatapointsToAlarm(Integer consecutiveDatapointsToAlarm) {
            this.consecutiveDatapointsToAlarm = consecutiveDatapointsToAlarm;
        }

        @Override
        @Transient
        public final Builder consecutiveDatapointsToAlarm(Integer consecutiveDatapointsToAlarm) {
            this.consecutiveDatapointsToAlarm = consecutiveDatapointsToAlarm;
            return this;
        }

        public final Integer getConsecutiveDatapointsToClear() {
            return consecutiveDatapointsToClear;
        }

        public final void setConsecutiveDatapointsToClear(Integer consecutiveDatapointsToClear) {
            this.consecutiveDatapointsToClear = consecutiveDatapointsToClear;
        }

        @Override
        @Transient
        public final Builder consecutiveDatapointsToClear(Integer consecutiveDatapointsToClear) {
            this.consecutiveDatapointsToClear = consecutiveDatapointsToClear;
            return this;
        }

        public final StatisticalThreshold.Builder getStatisticalThreshold() {
            return statisticalThreshold != null ? statisticalThreshold.toBuilder() : null;
        }

        public final void setStatisticalThreshold(StatisticalThreshold.BuilderImpl statisticalThreshold) {
            this.statisticalThreshold = statisticalThreshold != null ? statisticalThreshold.build() : null;
        }

        @Override
        @Transient
        public final Builder statisticalThreshold(StatisticalThreshold statisticalThreshold) {
            this.statisticalThreshold = statisticalThreshold;
            return this;
        }

        public final MachineLearningDetectionConfig.Builder getMlDetectionConfig() {
            return mlDetectionConfig != null ? mlDetectionConfig.toBuilder() : null;
        }

        public final void setMlDetectionConfig(MachineLearningDetectionConfig.BuilderImpl mlDetectionConfig) {
            this.mlDetectionConfig = mlDetectionConfig != null ? mlDetectionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder mlDetectionConfig(MachineLearningDetectionConfig mlDetectionConfig) {
            this.mlDetectionConfig = mlDetectionConfig;
            return this;
        }

        @Override
        public BehaviorCriteria build() {
            return new BehaviorCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
