/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBillingGroupResponse extends IotResponse implements
        ToCopyableBuilder<CreateBillingGroupResponse.Builder, CreateBillingGroupResponse> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupName").getter(getter(CreateBillingGroupResponse::billingGroupName))
            .setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupArn").getter(getter(CreateBillingGroupResponse::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupArn").build()).build();

    private static final SdkField<String> BILLING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupId").getter(getter(CreateBillingGroupResponse::billingGroupId))
            .setter(setter(Builder::billingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD,
            BILLING_GROUP_ARN_FIELD, BILLING_GROUP_ID_FIELD));

    private final String billingGroupName;

    private final String billingGroupArn;

    private final String billingGroupId;

    private CreateBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupArn = builder.billingGroupArn;
        this.billingGroupId = builder.billingGroupId;
    }

    /**
     * <p>
     * The name you gave to the billing group.
     * </p>
     * 
     * @return The name you gave to the billing group.
     */
    public final String billingGroupName() {
        return billingGroupName;
    }

    /**
     * <p>
     * The ARN of the billing group.
     * </p>
     * 
     * @return The ARN of the billing group.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The ID of the billing group.
     * </p>
     * 
     * @return The ID of the billing group.
     */
    public final String billingGroupId() {
        return billingGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingGroupResponse)) {
            return false;
        }
        CreateBillingGroupResponse other = (CreateBillingGroupResponse) obj;
        return Objects.equals(billingGroupName(), other.billingGroupName())
                && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(billingGroupId(), other.billingGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBillingGroupResponse").add("BillingGroupName", billingGroupName())
                .add("BillingGroupArn", billingGroupArn()).add("BillingGroupId", billingGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        case "billingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "billingGroupId":
            return Optional.ofNullable(clazz.cast(billingGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingGroupResponse, T> g) {
        return obj -> g.apply((CreateBillingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateBillingGroupResponse> {
        /**
         * <p>
         * The name you gave to the billing group.
         * </p>
         * 
         * @param billingGroupName
         *        The name you gave to the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        /**
         * <p>
         * The ARN of the billing group.
         * </p>
         * 
         * @param billingGroupArn
         *        The ARN of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The ID of the billing group.
         * </p>
         * 
         * @param billingGroupId
         *        The ID of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupId(String billingGroupId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String billingGroupName;

        private String billingGroupArn;

        private String billingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingGroupResponse model) {
            super(model);
            billingGroupName(model.billingGroupName);
            billingGroupArn(model.billingGroupArn);
            billingGroupId(model.billingGroupId);
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        @Transient
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        @Transient
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getBillingGroupId() {
            return billingGroupId;
        }

        public final void setBillingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
        }

        @Override
        @Transient
        public final Builder billingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
            return this;
        }

        @Override
        public CreateBillingGroupResponse build() {
            return new CreateBillingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
