/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVerificationStateOnViolationRequest extends IotRequest implements
        ToCopyableBuilder<PutVerificationStateOnViolationRequest.Builder, PutVerificationStateOnViolationRequest> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(PutVerificationStateOnViolationRequest::violationId))
            .setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("violationId").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationState").getter(getter(PutVerificationStateOnViolationRequest::verificationStateAsString))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationState").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("verificationStateDescription")
            .getter(getter(PutVerificationStateOnViolationRequest::verificationStateDescription))
            .setter(setter(Builder::verificationStateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationStateDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD,
            VERIFICATION_STATE_FIELD, VERIFICATION_STATE_DESCRIPTION_FIELD));

    private final String violationId;

    private final String verificationState;

    private final String verificationStateDescription;

    private PutVerificationStateOnViolationRequest(BuilderImpl builder) {
        super(builder);
        this.violationId = builder.violationId;
        this.verificationState = builder.verificationState;
        this.verificationStateDescription = builder.verificationStateDescription;
    }

    /**
     * <p>
     * The violation ID.
     * </p>
     * 
     * @return The violation ID.
     */
    public final String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The verification state of the violation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation.
     * @see VerificationState
     */
    public final VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * The verification state of the violation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation.
     * @see VerificationState
     */
    public final String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The description of the verification state of the violation (detect alarm).
     * </p>
     * 
     * @return The description of the verification state of the violation (detect alarm).
     */
    public final String verificationStateDescription() {
        return verificationStateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVerificationStateOnViolationRequest)) {
            return false;
        }
        PutVerificationStateOnViolationRequest other = (PutVerificationStateOnViolationRequest) obj;
        return Objects.equals(violationId(), other.violationId())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(verificationStateDescription(), other.verificationStateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVerificationStateOnViolationRequest").add("ViolationId", violationId())
                .add("VerificationState", verificationStateAsString())
                .add("VerificationStateDescription", verificationStateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "verificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "verificationStateDescription":
            return Optional.ofNullable(clazz.cast(verificationStateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVerificationStateOnViolationRequest, T> g) {
        return obj -> g.apply((PutVerificationStateOnViolationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVerificationStateOnViolationRequest> {
        /**
         * <p>
         * The violation ID.
         * </p>
         * 
         * @param violationId
         *        The violation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The verification state of the violation.
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * The verification state of the violation.
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The description of the verification state of the violation (detect alarm).
         * </p>
         * 
         * @param verificationStateDescription
         *        The description of the verification state of the violation (detect alarm).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationStateDescription(String verificationStateDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String violationId;

        private String verificationState;

        private String verificationStateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVerificationStateOnViolationRequest model) {
            super(model);
            violationId(model.violationId);
            verificationState(model.verificationState);
            verificationStateDescription(model.verificationStateDescription);
        }

        public final String getViolationId() {
            return violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        @Transient
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        @Transient
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        @Transient
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getVerificationStateDescription() {
            return verificationStateDescription;
        }

        public final void setVerificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
        }

        @Override
        @Transient
        public final Builder verificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVerificationStateOnViolationRequest build() {
            return new PutVerificationStateOnViolationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
