/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeUserProfiles</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserProfilesResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeUserProfilesResponse.Builder, DescribeUserProfilesResponse> {
    private static final SdkField<List<UserProfile>> USER_PROFILES_FIELD = SdkField
            .<List<UserProfile>> builder(MarshallingType.LIST)
            .getter(getter(DescribeUserProfilesResponse::userProfiles))
            .setter(setter(Builder::userProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD));

    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
    }

    /**
     * Returns true if the UserProfiles property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserProfiles() {
        return userProfiles != null && !(userProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>Users</code> object that describes the specified users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A <code>Users</code> object that describes the specified users.
     */
    public List<UserProfile> userProfiles() {
        return userProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userProfiles());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse) obj;
        return Objects.equals(userProfiles(), other.userProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserProfilesResponse").add("UserProfiles", userProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfiles":
            return Optional.ofNullable(clazz.cast(userProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesResponse, T> g) {
        return obj -> g.apply((DescribeUserProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(Collection<UserProfile> userProfiles);

        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(UserProfile... userProfiles);

        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserProfile>.Builder} avoiding the need to
         * create one manually via {@link List<UserProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserProfile>.Builder#build()} is called immediately and its
         * result is passed to {@link #userProfiles(List<UserProfile>)}.
         * 
         * @param userProfiles
         *        a consumer that will call methods on {@link List<UserProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfiles(List<UserProfile>)
         */
        Builder userProfiles(Consumer<UserProfile.Builder>... userProfiles);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<UserProfile> userProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            super(model);
            userProfiles(model.userProfiles);
        }

        public final Collection<UserProfile.Builder> getUserProfiles() {
            return userProfiles != null ? userProfiles.stream().map(UserProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfile.Builder>... userProfiles) {
            userProfiles(Stream.of(userProfiles).map(c -> UserProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
