/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDiscovererResponse extends SchemasResponse implements
        ToCopyableBuilder<DescribeDiscovererResponse.Builder, DescribeDiscovererResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDiscovererResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISCOVERER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDiscovererResponse::discovererArn)).setter(setter(Builder::discovererArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererArn").build()).build();

    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDiscovererResponse::discovererId)).setter(setter(Builder::discovererId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDiscovererResponse::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDiscovererResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeDiscovererResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DISCOVERER_ARN_FIELD, DISCOVERER_ID_FIELD, SOURCE_ARN_FIELD, STATE_FIELD, TAGS_FIELD));

    private final String description;

    private final String discovererArn;

    private final String discovererId;

    private final String sourceArn;

    private final String state;

    private final Map<String, String> tags;

    private DescribeDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.discovererArn = builder.discovererArn;
        this.discovererId = builder.discovererId;
        this.sourceArn = builder.sourceArn;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The description of the discoverer.
     * </p>
     * 
     * @return The description of the discoverer.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the discoverer.
     * </p>
     * 
     * @return The ARN of the discoverer.
     */
    public String discovererArn() {
        return discovererArn;
    }

    /**
     * <p>
     * The ID of the discoverer.
     * </p>
     * 
     * @return The ID of the discoverer.
     */
    public String discovererId() {
        return discovererId;
    }

    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     * 
     * @return The ARN of the event bus.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public DiscovererState state() {
        return DiscovererState.fromValue(state);
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags associated with the resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(discovererArn());
        hashCode = 31 * hashCode + Objects.hashCode(discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDiscovererResponse)) {
            return false;
        }
        DescribeDiscovererResponse other = (DescribeDiscovererResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(discovererArn(), other.discovererArn())
                && Objects.equals(discovererId(), other.discovererId()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDiscovererResponse").add("Description", description())
                .add("DiscovererArn", discovererArn()).add("DiscovererId", discovererId()).add("SourceArn", sourceArn())
                .add("State", stateAsString()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiscovererArn":
            return Optional.ofNullable(clazz.cast(discovererArn()));
        case "DiscovererId":
            return Optional.ofNullable(clazz.cast(discovererId()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDiscovererResponse, T> g) {
        return obj -> g.apply((DescribeDiscovererResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDiscovererResponse> {
        /**
         * <p>
         * The description of the discoverer.
         * </p>
         * 
         * @param description
         *        The description of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the discoverer.
         * </p>
         * 
         * @param discovererArn
         *        The ARN of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererArn(String discovererArn);

        /**
         * <p>
         * The ID of the discoverer.
         * </p>
         * 
         * @param discovererId
         *        The ID of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererId(String discovererId);

        /**
         * <p>
         * The ARN of the event bus.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(DiscovererState state);

        /**
         * <p>
         * Tags associated with the resource.
         * </p>
         * 
         * @param tags
         *        Tags associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String description;

        private String discovererArn;

        private String discovererId;

        private String sourceArn;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDiscovererResponse model) {
            super(model);
            description(model.description);
            discovererArn(model.discovererArn);
            discovererId(model.discovererId);
            sourceArn(model.sourceArn);
            state(model.state);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDiscovererArn() {
            return discovererArn;
        }

        @Override
        public final Builder discovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
            return this;
        }

        public final void setDiscovererArn(String discovererArn) {
            this.discovererArn = discovererArn;
        }

        public final String getDiscovererId() {
            return discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public DescribeDiscovererResponse build() {
            return new DescribeDiscovererResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
