/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the kind of currency detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpenseCurrency implements SdkPojo, Serializable, ToCopyableBuilder<ExpenseCurrency.Builder, ExpenseCurrency> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ExpenseCurrency::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(ExpenseCurrency::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final Float confidence;

    private ExpenseCurrency(BuilderImpl builder) {
        this.code = builder.code;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Currency code for detected currency. the current supported codes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * USD
     * </p>
     * </li>
     * <li>
     * <p>
     * EUR
     * </p>
     * </li>
     * <li>
     * <p>
     * GBP
     * </p>
     * </li>
     * <li>
     * <p>
     * CAD
     * </p>
     * </li>
     * <li>
     * <p>
     * INR
     * </p>
     * </li>
     * <li>
     * <p>
     * JPY
     * </p>
     * </li>
     * <li>
     * <p>
     * CHF
     * </p>
     * </li>
     * <li>
     * <p>
     * AUD
     * </p>
     * </li>
     * <li>
     * <p>
     * CNY
     * </p>
     * </li>
     * <li>
     * <p>
     * BZR
     * </p>
     * </li>
     * <li>
     * <p>
     * SEK
     * </p>
     * </li>
     * <li>
     * <p>
     * HKD
     * </p>
     * </li>
     * </ul>
     * 
     * @return Currency code for detected currency. the current supported codes are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         USD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EUR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GBP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CAD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JPY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CHF
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AUD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CNY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BZR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SEK
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HKD
     *         </p>
     *         </li>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Percentage confideence in the detected currency.
     * </p>
     * 
     * @return Percentage confideence in the detected currency.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseCurrency)) {
            return false;
        }
        ExpenseCurrency other = (ExpenseCurrency) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpenseCurrency").add("Code", code()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseCurrency, T> g) {
        return obj -> g.apply((ExpenseCurrency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpenseCurrency> {
        /**
         * <p>
         * Currency code for detected currency. the current supported codes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * USD
         * </p>
         * </li>
         * <li>
         * <p>
         * EUR
         * </p>
         * </li>
         * <li>
         * <p>
         * GBP
         * </p>
         * </li>
         * <li>
         * <p>
         * CAD
         * </p>
         * </li>
         * <li>
         * <p>
         * INR
         * </p>
         * </li>
         * <li>
         * <p>
         * JPY
         * </p>
         * </li>
         * <li>
         * <p>
         * CHF
         * </p>
         * </li>
         * <li>
         * <p>
         * AUD
         * </p>
         * </li>
         * <li>
         * <p>
         * CNY
         * </p>
         * </li>
         * <li>
         * <p>
         * BZR
         * </p>
         * </li>
         * <li>
         * <p>
         * SEK
         * </p>
         * </li>
         * <li>
         * <p>
         * HKD
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        Currency code for detected currency. the current supported codes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        USD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EUR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GBP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CAD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JPY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CHF
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AUD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CNY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BZR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SEK
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HKD
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Percentage confideence in the detected currency.
         * </p>
         * 
         * @param confidence
         *        Percentage confideence in the detected currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseCurrency model) {
            code(model.code);
            confidence(model.confidence);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public ExpenseCurrency build() {
            return new ExpenseCurrency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
