/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrateWorkspaceResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<MigrateWorkspaceResponse.Builder, MigrateWorkspaceResponse> {
    private static final SdkField<String> SOURCE_WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrateWorkspaceResponse::sourceWorkspaceId)).setter(setter(Builder::sourceWorkspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceWorkspaceId").build()).build();

    private static final SdkField<String> TARGET_WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrateWorkspaceResponse::targetWorkspaceId)).setter(setter(Builder::targetWorkspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetWorkspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_WORKSPACE_ID_FIELD,
            TARGET_WORKSPACE_ID_FIELD));

    private final String sourceWorkspaceId;

    private final String targetWorkspaceId;

    private MigrateWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.sourceWorkspaceId = builder.sourceWorkspaceId;
        this.targetWorkspaceId = builder.targetWorkspaceId;
    }

    /**
     * <p>
     * The original identifier of the WorkSpace that is being migrated.
     * </p>
     * 
     * @return The original identifier of the WorkSpace that is being migrated.
     */
    public String sourceWorkspaceId() {
        return sourceWorkspaceId;
    }

    /**
     * <p>
     * The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the target
     * WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.
     * </p>
     * 
     * @return The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the target
     *         WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.
     */
    public String targetWorkspaceId() {
        return targetWorkspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetWorkspaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrateWorkspaceResponse)) {
            return false;
        }
        MigrateWorkspaceResponse other = (MigrateWorkspaceResponse) obj;
        return Objects.equals(sourceWorkspaceId(), other.sourceWorkspaceId())
                && Objects.equals(targetWorkspaceId(), other.targetWorkspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MigrateWorkspaceResponse").add("SourceWorkspaceId", sourceWorkspaceId())
                .add("TargetWorkspaceId", targetWorkspaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceWorkspaceId":
            return Optional.ofNullable(clazz.cast(sourceWorkspaceId()));
        case "TargetWorkspaceId":
            return Optional.ofNullable(clazz.cast(targetWorkspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrateWorkspaceResponse, T> g) {
        return obj -> g.apply((MigrateWorkspaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, MigrateWorkspaceResponse> {
        /**
         * <p>
         * The original identifier of the WorkSpace that is being migrated.
         * </p>
         * 
         * @param sourceWorkspaceId
         *        The original identifier of the WorkSpace that is being migrated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceWorkspaceId(String sourceWorkspaceId);

        /**
         * <p>
         * The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the target
         * WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.
         * </p>
         * 
         * @param targetWorkspaceId
         *        The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the
         *        target WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetWorkspaceId(String targetWorkspaceId);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String sourceWorkspaceId;

        private String targetWorkspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrateWorkspaceResponse model) {
            super(model);
            sourceWorkspaceId(model.sourceWorkspaceId);
            targetWorkspaceId(model.targetWorkspaceId);
        }

        public final String getSourceWorkspaceId() {
            return sourceWorkspaceId;
        }

        @Override
        public final Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            return this;
        }

        public final void setSourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
        }

        public final String getTargetWorkspaceId() {
            return targetWorkspaceId;
        }

        @Override
        public final Builder targetWorkspaceId(String targetWorkspaceId) {
            this.targetWorkspaceId = targetWorkspaceId;
            return this;
        }

        public final void setTargetWorkspaceId(String targetWorkspaceId) {
            this.targetWorkspaceId = targetWorkspaceId;
        }

        @Override
        public MigrateWorkspaceResponse build() {
            return new MigrateWorkspaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
